/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover.node;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.spongycastle.util.encoders.Hex;
import org.tron.common.crypto.ECKey;
import org.tron.common.crypto.Hash;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Utils;

public class Node
implements Serializable {
    private static final long serialVersionUID = -4267600517925770636L;
    private byte[] id;
    private String host;
    private int port;
    private boolean isFakeNodeId = false;
    private int reputation = 0;

    public int getReputation() {
        return this.reputation;
    }

    public void setReputation(int reputation) {
        this.reputation = reputation;
    }

    public static Node instanceOf(String addressOrEnode) {
        try {
            URI uri = new URI(addressOrEnode);
            if (uri.getScheme().equals("enode")) {
                return new Node(addressOrEnode);
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        ECKey generatedNodeKey = ECKey.fromPrivate(Hash.sha3(addressOrEnode.getBytes()));
        String generatedNodeId = Hex.toHexString((byte[])generatedNodeKey.getNodeId());
        Node node = new Node("enode://" + generatedNodeId + "@" + addressOrEnode);
        node.isFakeNodeId = true;
        return node;
    }

    public String getEnodeURL() {
        return "enode://" + ByteArray.toHexString(this.id) + "@" + this.host + ":" + this.port;
    }

    public Node(String enodeURL) {
        try {
            URI uri = new URI(enodeURL);
            if (!uri.getScheme().equals("enode")) {
                throw new RuntimeException("expecting URL in the format enode://PUBKEY@HOST:PORT");
            }
            this.id = Hex.decode((String)uri.getUserInfo());
            this.host = uri.getHost();
            this.port = uri.getPort();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("expecting URL in the format enode://PUBKEY@HOST:PORT", e);
        }
    }

    public Node(byte[] id, String host, int port) {
        if (id != null) {
            this.id = (byte[])id.clone();
        }
        this.host = host;
        this.port = port;
    }

    public String getHexId() {
        return Hex.toHexString((byte[])this.id);
    }

    public String getHexIdShort() {
        return Utils.getIdShort(this.getHexId());
    }

    public boolean isDiscoveryNode() {
        return this.isFakeNodeId;
    }

    public byte[] getId() {
        return this.id == null ? this.id : (byte[])this.id.clone();
    }

    public void setId(byte[] id) {
        this.id = id == null ? null : (byte[])id.clone();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getIdString() {
        if (this.id == null) {
            return null;
        }
        return new String(this.id);
    }

    public String toString() {
        return "Node{ host='" + this.host + '\'' + ", port=" + this.port + ", id=" + ByteArray.toHexString(this.id) + '}';
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() == this.getClass()) {
            return StringUtils.equals((CharSequence)this.getIdString(), (CharSequence)((Node)o).getIdString());
        }
        return false;
    }
}

