/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.overlay.discover.node.NodeManager;
import org.tron.common.overlay.discover.table.NodeEntry;

public class DiscoverTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger((String)"DiscoverTask");
    NodeManager nodeManager;
    byte[] nodeId;

    public DiscoverTask(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
        this.nodeId = nodeManager.getPublicHomeNode().getId();
    }

    @Override
    public void run() {
        this.discover(this.nodeId, 0, new ArrayList<Node>());
    }

    public synchronized void discover(byte[] nodeId, int round, List<Node> prevTried) {
        try {
            if (round == 8) {
                logger.debug("Node table contains [{}] peers", (Object)this.nodeManager.getTable().getNodesCount());
                logger.debug("{}", (Object)String.format("(KademliaOptions.MAX_STEPS) Terminating discover after %d rounds.", round));
                logger.trace("{}\n{}", (Object)String.format("Nodes discovered %d ", this.nodeManager.getTable().getNodesCount()), (Object)this.dumpNodes());
                return;
            }
            List<Node> closest = this.nodeManager.getTable().getClosestNodes(nodeId);
            ArrayList<Node> tried = new ArrayList<Node>();
            for (Node n : closest) {
                if (!tried.contains(n) && !prevTried.contains(n)) {
                    try {
                        this.nodeManager.getNodeHandler(n).sendFindNode(nodeId);
                        tried.add(n);
                        this.wait(50L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception ex) {
                        logger.error("Unexpected Exception " + ex, (Throwable)ex);
                    }
                }
                if (tried.size() != 3) continue;
                break;
            }
            if (tried.isEmpty()) {
                logger.debug("{}", (Object)String.format("(tried.isEmpty()) Terminating discover after %d rounds.", round));
                logger.trace("{}\n{}", (Object)String.format("Nodes discovered %d ", this.nodeManager.getTable().getNodesCount()), (Object)this.dumpNodes());
                return;
            }
            tried.addAll(prevTried);
            this.discover(nodeId, round + 1, tried);
        }
        catch (Exception ex) {
            logger.error("{}", (Throwable)ex);
        }
    }

    private String dumpNodes() {
        String ret = "";
        for (NodeEntry entry : this.nodeManager.getTable().getAllNodes()) {
            ret = ret + "    " + entry.getNode() + "\n";
        }
        return ret;
    }
}

