/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.net.udp.message.discover;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.net.udp.message.Message;
import org.tron.common.net.udp.message.UdpMessageTypeEnum;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.utils.ByteArray;
import org.tron.protos.Discover;

public class NeighborsMessage
extends Message {
    private static final Logger logger = LoggerFactory.getLogger(NeighborsMessage.class);
    private Discover.Neighbours neighbours;

    public NeighborsMessage(byte[] data) throws Exception {
        super(UdpMessageTypeEnum.DISCOVER_NEIGHBORS, data);
        this.neighbours = Discover.Neighbours.parseFrom(data);
    }

    public NeighborsMessage(Node from, List<Node> neighbours) {
        super(UdpMessageTypeEnum.DISCOVER_NEIGHBORS, null);
        Discover.Neighbours.Builder builder = Discover.Neighbours.newBuilder().setTimestamp(System.currentTimeMillis());
        neighbours.forEach(neighbour -> {
            Discover.Endpoint endpoint = Discover.Endpoint.newBuilder().setAddress(ByteString.copyFrom((byte[])ByteArray.fromString(neighbour.getHost()))).setPort(neighbour.getPort()).setNodeId(ByteString.copyFrom((byte[])neighbour.getId())).build();
            builder.addNeighbours(endpoint);
        });
        Discover.Endpoint fromEndpoint = Discover.Endpoint.newBuilder().setAddress(ByteString.copyFrom((byte[])ByteArray.fromString(from.getHost()))).setPort(from.getPort()).setNodeId(ByteString.copyFrom((byte[])from.getId())).build();
        builder.setFrom(fromEndpoint);
        this.neighbours = builder.build();
        this.data = this.neighbours.toByteArray();
    }

    public List<Node> getNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.neighbours.getNeighboursList().forEach(neighbour -> nodes.add(new Node(neighbour.getNodeId().toByteArray(), ByteArray.toStr(neighbour.getAddress().toByteArray()), neighbour.getPort())));
        return nodes;
    }

    @Override
    public Node getFrom() {
        return Message.getNode(this.neighbours.getFrom());
    }

    @Override
    public String toString() {
        return "[neighbours: " + this.neighbours;
    }
}

