/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.net.udp.message;

import java.util.HashMap;
import java.util.Map;

public enum UdpMessageTypeEnum {
    DISCOVER_PING(1),
    DISCOVER_PONG(2),
    DISCOVER_FIND_NODE(3),
    DISCOVER_NEIGHBORS(4),
    BACKUP_KEEP_ALIVE(5),
    UNKNOWN(-1);

    private final byte type;
    private static final Map<Byte, UdpMessageTypeEnum> intToTypeMap;

    private UdpMessageTypeEnum(byte type) {
        this.type = type;
    }

    public static UdpMessageTypeEnum fromByte(byte type) {
        UdpMessageTypeEnum typeEnum = intToTypeMap.get(type);
        return typeEnum == null ? UNKNOWN : typeEnum;
    }

    public byte getType() {
        return this.type;
    }

    static {
        intToTypeMap = new HashMap<Byte, UdpMessageTypeEnum>();
        for (UdpMessageTypeEnum value : UdpMessageTypeEnum.values()) {
            intToTypeMap.put(value.type, value);
        }
    }
}

