/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.crypto.zksnark;

import java.math.BigInteger;
import org.tron.common.crypto.zksnark.Field;
import org.tron.common.crypto.zksnark.Fp2;

class Fp6
implements Field<Fp6> {
    static final Fp6 ZERO = new Fp6(Fp2.ZERO, Fp2.ZERO, Fp2.ZERO);
    static final Fp6 _1 = new Fp6(Fp2._1, Fp2.ZERO, Fp2.ZERO);
    static final Fp2 NON_RESIDUE = new Fp2(BigInteger.valueOf(9L), BigInteger.ONE);
    Fp2 a;
    Fp2 b;
    Fp2 c;
    static final Fp2[] FROBENIUS_COEFFS_B = new Fp2[]{new Fp2(BigInteger.ONE, BigInteger.ZERO), new Fp2(new BigInteger("21575463638280843010398324269430826099269044274347216827212613867836435027261"), new BigInteger("10307601595873709700152284273816112264069230130616436755625194854815875713954")), new Fp2(new BigInteger("21888242871839275220042445260109153167277707414472061641714758635765020556616"), BigInteger.ZERO), new Fp2(new BigInteger("3772000881919853776433695186713858239009073593817195771773381919316419345261"), new BigInteger("2236595495967245188281701248203181795121068902605861227855261137820944008926")), new Fp2(new BigInteger("2203960485148121921418603742825762020974279258880205651966"), BigInteger.ZERO), new Fp2(new BigInteger("18429021223477853657660792034369865839114504446431234726392080002137598044644"), new BigInteger("9344045779998320333812420223237981029506012124075525679208581902008406485703"))};
    static final Fp2[] FROBENIUS_COEFFS_C = new Fp2[]{new Fp2(BigInteger.ONE, BigInteger.ZERO), new Fp2(new BigInteger("2581911344467009335267311115468803099551665605076196740867805258568234346338"), new BigInteger("19937756971775647987995932169929341994314640652964949448313374472400716661030")), new Fp2(new BigInteger("2203960485148121921418603742825762020974279258880205651966"), BigInteger.ZERO), new Fp2(new BigInteger("5324479202449903542726783395506214481928257762400643279780343368557297135718"), new BigInteger("16208900380737693084919495127334387981393726419856888799917914180988844123039")), new Fp2(new BigInteger("21888242871839275220042445260109153167277707414472061641714758635765020556616"), BigInteger.ZERO), new Fp2(new BigInteger("13981852324922362344252311234282257507216387789820983642040889267519694726527"), new BigInteger("7629828391165209371577384193250820201684255241773809077146787135900891633097"))};

    Fp6(Fp2 a, Fp2 b, Fp2 c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    @Override
    public Fp6 squared() {
        Fp2 s0 = this.a.squared();
        Fp2 ab = this.a.mul(this.b);
        Fp2 s1 = ab.dbl();
        Fp2 s2 = this.a.sub(this.b).add(this.c).squared();
        Fp2 bc = this.b.mul(this.c);
        Fp2 s3 = bc.dbl();
        Fp2 s4 = this.c.squared();
        Fp2 ra = s0.add(s3.mulByNonResidue());
        Fp2 rb = s1.add(s4.mulByNonResidue());
        Fp2 rc = s1.add(s2).add(s3).sub(s0).sub(s4);
        return new Fp6(ra, rb, rc);
    }

    @Override
    public Fp6 dbl() {
        return this.add(this);
    }

    @Override
    public Fp6 mul(Fp6 o) {
        Fp2 a1 = this.a;
        Fp2 b1 = this.b;
        Fp2 c1 = this.c;
        Fp2 a2 = o.a;
        Fp2 b2 = o.b;
        Fp2 c2 = o.c;
        Fp2 a1a2 = a1.mul(a2);
        Fp2 b1b2 = b1.mul(b2);
        Fp2 c1c2 = c1.mul(c2);
        Fp2 ra = a1a2.add(b1.add(c1).mul(b2.add(c2)).sub(b1b2).sub(c1c2).mulByNonResidue());
        Fp2 rb = a1.add(b1).mul(a2.add(b2)).sub(a1a2).sub(b1b2).add(c1c2.mulByNonResidue());
        Fp2 rc = a1.add(c1).mul(a2.add(c2)).sub(a1a2).add(b1b2).sub(c1c2);
        return new Fp6(ra, rb, rc);
    }

    @Override
    Fp6 mul(Fp2 o) {
        Fp2 ra = this.a.mul(o);
        Fp2 rb = this.b.mul(o);
        Fp2 rc = this.c.mul(o);
        return new Fp6(ra, rb, rc);
    }

    Fp6 mulByNonResidue() {
        Fp2 ra = NON_RESIDUE.mul(this.c);
        Fp2 rb = this.a;
        Fp2 rc = this.b;
        return new Fp6(ra, rb, rc);
    }

    @Override
    public Fp6 add(Fp6 o) {
        Fp2 ra = this.a.add(o.a);
        Fp2 rb = this.b.add(o.b);
        Fp2 rc = this.c.add(o.c);
        return new Fp6(ra, rb, rc);
    }

    @Override
    public Fp6 sub(Fp6 o) {
        Fp2 ra = this.a.sub(o.a);
        Fp2 rb = this.b.sub(o.b);
        Fp2 rc = this.c.sub(o.c);
        return new Fp6(ra, rb, rc);
    }

    @Override
    public Fp6 inverse() {
        Fp2 t0 = this.a.squared();
        Fp2 t1 = this.b.squared();
        Fp2 t2 = this.c.squared();
        Fp2 t3 = this.a.mul(this.b);
        Fp2 t4 = this.a.mul(this.c);
        Fp2 t5 = this.b.mul(this.c);
        Fp2 c0 = t0.sub(t5.mulByNonResidue());
        Fp2 c1 = t2.mulByNonResidue().sub(t3);
        Fp2 c2 = t1.sub(t4);
        Fp2 t6 = this.a.mul(c0).add(this.c.mul(c1).add(this.b.mul(c2)).mulByNonResidue()).inverse();
        Fp2 ra = t6.mul(c0);
        Fp2 rb = t6.mul(c1);
        Fp2 rc = t6.mul(c2);
        return new Fp6(ra, rb, rc);
    }

    @Override
    public Fp6 negate() {
        return new Fp6(this.a.negate(), this.b.negate(), this.c.negate());
    }

    @Override
    public boolean isZero() {
        return this.equals(ZERO);
    }

    @Override
    public boolean isValid() {
        return this.a.isValid() && this.b.isValid() && this.c.isValid();
    }

    Fp6 frobeniusMap(int power) {
        Fp2 ra = this.a.frobeniusMap(power);
        Fp2 rb = FROBENIUS_COEFFS_B[power % 6].mul(this.b.frobeniusMap(power));
        Fp2 rc = FROBENIUS_COEFFS_C[power % 6].mul(this.c.frobeniusMap(power));
        return new Fp6(ra, rb, rc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Fp6 fp6 = (Fp6)o;
        if (this.a != null ? !this.a.equals(fp6.a) : fp6.a != null) {
            return false;
        }
        if (this.b != null ? !this.b.equals(fp6.b) : fp6.b != null) {
            return false;
        }
        return !(this.c == null ? fp6.c != null : !this.c.equals(fp6.c));
    }

    public int hashCode() {
        return new Integer(this.a.hashCode() + this.b.hashCode() + this.c.hashCode()).hashCode();
    }
}

