/*
 * Decompiled with CFR 0.152.
 */
package com.github.triplet.gradle.common.validation;

import com.android.Version;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.builder.model.BuildType;
import com.github.triplet.gradle.common.validation.RuntimeValidator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.gradle.util.GradleVersion;
import org.gradle.util.VersionNumber;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0006\u0010\n\u001a\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"MIN_AGP_VERSION", "Lorg/gradle/util/VersionNumber;", "MIN_GRADLE_VERSION", "Lorg/gradle/util/GradleVersion;", "validateDebuggability", "", "variant", "Lcom/android/build/gradle/api/ApplicationVariant;", "logger", "Lorg/gradle/api/logging/Logger;", "validateRuntime", "", "validation"})
public final class ValidationKt {
    private static final GradleVersion MIN_GRADLE_VERSION;
    private static final VersionNumber MIN_AGP_VERSION;

    public static final void validateRuntime() {
        String string;
        try {
            string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        }
        catch (NoClassDefFoundError e) {
            string = com.android.builder.model.Version.ANDROID_GRADLE_PLUGIN_VERSION;
        }
        VersionNumber versionNumber = VersionNumber.parse((String)string);
        Intrinsics.checkExpressionValueIsNotNull((Object)versionNumber, (String)"VersionNumber.parse(try \u2026DLE_PLUGIN_VERSION\n    })");
        VersionNumber agpVersion = versionNumber;
        GradleVersion gradleVersion = GradleVersion.current();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion, (String)"GradleVersion.current()");
        RuntimeValidator validator = new RuntimeValidator(gradleVersion, MIN_GRADLE_VERSION, agpVersion, MIN_AGP_VERSION);
        validator.validate();
    }

    public static final boolean validateDebuggability(@NotNull ApplicationVariant variant, @NotNull Logger logger) {
        boolean isValid;
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        BuildType buildType = variant.getBuildType();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildType, (String)"variant.buildType");
        boolean bl = isValid = !buildType.isDebuggable();
        if (!isValid) {
            BuildType buildType2 = variant.getBuildType();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildType2, (String)"variant.buildType");
            String typeName = buildType2.getName();
            if (StringsKt.equals((String)typeName, (String)"release", (boolean)true)) {
                logger.error("GPP cannot configure variant '" + variant.getName() + "' because it is debuggable");
            } else {
                logger.info("Skipping debuggable build with type '" + typeName + '\'');
            }
        }
        return isValid;
    }

    static {
        GradleVersion gradleVersion = GradleVersion.version((String)"6.0");
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion, (String)"GradleVersion.version(\"6.0\")");
        MIN_GRADLE_VERSION = gradleVersion;
        VersionNumber versionNumber = VersionNumber.parse((String)"3.5.0");
        Intrinsics.checkExpressionValueIsNotNull((Object)versionNumber, (String)"VersionNumber.parse(\"3.5.0\")");
        MIN_AGP_VERSION = versionNumber;
    }
}

