/*
 * Decompiled with CFR 0.152.
 */
package com.github.triplet.gradle.common.validation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.gradle.util.VersionNumber;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/triplet/gradle/common/validation/RuntimeValidator;", "", "currentGradleVersion", "Lorg/gradle/util/GradleVersion;", "minGradleVersion", "currentAgpVersion", "Lorg/gradle/util/VersionNumber;", "minAgpVersion", "(Lorg/gradle/util/GradleVersion;Lorg/gradle/util/GradleVersion;Lorg/gradle/util/VersionNumber;Lorg/gradle/util/VersionNumber;)V", "validate", "", "validateAgp", "validateGradle", "validation"})
public final class RuntimeValidator {
    private final GradleVersion currentGradleVersion;
    private final GradleVersion minGradleVersion;
    private final VersionNumber currentAgpVersion;
    private final VersionNumber minAgpVersion;

    public final void validate() {
        this.validateGradle();
        this.validateAgp();
    }

    private final void validateGradle() {
        boolean bl = this.currentGradleVersion.compareTo(this.minGradleVersion) >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = StringsKt.trimMargin$default((String)("\n            |Gradle Play Publisher's minimum Gradle version is at least " + this.minGradleVersion + " and yours\n            |is " + this.currentGradleVersion + ". Find the latest version at\n            |https://github.com/gradle/gradle/releases/latest, then run\n            |$ ./gradlew wrapper --gradle-version=$LATEST --distribution-type=ALL\n            "), null, (int)1, null);
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final void validateAgp() {
        boolean bl = this.currentAgpVersion.compareTo(this.minAgpVersion) >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = StringsKt.trimMargin$default((String)("\n            |Gradle Play Publisher's minimum Android Gradle Plugin version is at least\n            |" + this.minAgpVersion + " and yours is " + this.currentAgpVersion + ". Find the latest version and upgrade\n            |instructions at https://developer.android.com/studio/releases/gradle-plugin.\n            "), null, (int)1, null);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = this.currentAgpVersion.compareTo(VersionNumber.parse((String)"3.6.0-alpha01")) < 0 || this.currentAgpVersion.compareTo(VersionNumber.parse((String)"3.6.0-alpha11")) >= 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "GPP is only known to be compatible with AGP 3.6 alpha 11. Please upgrade.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public RuntimeValidator(@NotNull GradleVersion currentGradleVersion, @NotNull GradleVersion minGradleVersion, @NotNull VersionNumber currentAgpVersion, @NotNull VersionNumber minAgpVersion) {
        Intrinsics.checkParameterIsNotNull((Object)currentGradleVersion, (String)"currentGradleVersion");
        Intrinsics.checkParameterIsNotNull((Object)minGradleVersion, (String)"minGradleVersion");
        Intrinsics.checkParameterIsNotNull((Object)currentAgpVersion, (String)"currentAgpVersion");
        Intrinsics.checkParameterIsNotNull((Object)minAgpVersion, (String)"minAgpVersion");
        this.currentGradleVersion = currentGradleVersion;
        this.minGradleVersion = minGradleVersion;
        this.currentAgpVersion = currentAgpVersion;
        this.minAgpVersion = minAgpVersion;
    }
}

