/*
 * Decompiled with CFR 0.152.
 */
package com.github.triplet.gradle.androidpublisher.internal;

import com.github.triplet.gradle.androidpublisher.EditManager;
import com.github.triplet.gradle.androidpublisher.PlayPublisher;
import com.github.triplet.gradle.androidpublisher.ReleaseStatus;
import com.github.triplet.gradle.androidpublisher.ResolutionStrategy;
import com.github.triplet.gradle.androidpublisher.internal.AndroidPublisherKt;
import com.github.triplet.gradle.androidpublisher.internal.DefaultEditManager$WhenMappings;
import com.github.triplet.gradle.androidpublisher.internal.DefaultTrackManager;
import com.github.triplet.gradle.androidpublisher.internal.InternalPlayPublisher;
import com.github.triplet.gradle.androidpublisher.internal.TrackManager;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.androidpublisher.model.Apk;
import com.google.api.services.androidpublisher.model.Bundle;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001:\u00016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J2\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002Je\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010\"Jo\u0010#\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0!2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010(JM\u0010)\u001a\u0004\u0018\u00010\n2\u0006\u0010*\u001a\u00020\u00122\b\u0010+\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00072\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010-H\u0016\u00a2\u0006\u0002\u0010/J\u008b\u0001\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u00122\b\u0010+\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010!H\u0016\u00a2\u0006\u0002\u00102J\u001a\u00103\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020-2\b\u0010+\u001a\u0004\u0018\u00010\u0012H\u0002J\u001c\u00104\u001a\u00020\u0016*\u00020-2\u0006\u00105\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020-H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/github/triplet/gradle/androidpublisher/internal/DefaultEditManager;", "Lcom/github/triplet/gradle/androidpublisher/EditManager;", "publisher", "Lcom/github/triplet/gradle/androidpublisher/internal/InternalPlayPublisher;", "tracks", "Lcom/github/triplet/gradle/androidpublisher/internal/TrackManager;", "editId", "", "(Lcom/github/triplet/gradle/androidpublisher/internal/InternalPlayPublisher;Lcom/github/triplet/gradle/androidpublisher/internal/TrackManager;Ljava/lang/String;)V", "findMaxAppVersionCode", "", "handleUploadFailures", "", "e", "Lcom/google/api/client/googleapis/json/GoogleJsonResponseException;", "strategy", "Lcom/github/triplet/gradle/androidpublisher/ResolutionStrategy;", "artifact", "Ljava/io/File;", "versionCode", "variantName", "promoteRelease", "", "promoteTrackName", "fromTrackName", "releaseStatus", "Lcom/github/triplet/gradle/androidpublisher/ReleaseStatus;", "releaseName", "releaseNotes", "", "userFraction", "", "retainableArtifacts", "", "(Ljava/lang/String;Ljava/lang/String;Lcom/github/triplet/gradle/androidpublisher/ReleaseStatus;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Double;Ljava/util/List;)V", "publishApk", "versionCodes", "didPreviousBuildSkipCommit", "", "trackName", "(Ljava/util/List;ZLjava/lang/String;Lcom/github/triplet/gradle/androidpublisher/ReleaseStatus;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Double;Ljava/util/List;)V", "uploadApk", "apkFile", "mappingFile", "mainObbRetainable", "", "patchObbRetainable", "(Ljava/io/File;Ljava/io/File;Lcom/github/triplet/gradle/androidpublisher/ResolutionStrategy;JLjava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/Long;", "uploadBundle", "bundleFile", "(Ljava/io/File;Ljava/io/File;Lcom/github/triplet/gradle/androidpublisher/ResolutionStrategy;JLjava/lang/String;ZLjava/lang/String;Lcom/github/triplet/gradle/androidpublisher/ReleaseStatus;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Double;Ljava/util/List;)V", "uploadMappingFile", "attachObb", "type", "Factory", "android-publisher"})
public final class DefaultEditManager
implements EditManager {
    private final InternalPlayPublisher publisher;
    private final TrackManager tracks;
    private final String editId;

    @Override
    public long findMaxAppVersionCode() {
        return this.tracks.findMaxAppVersionCode();
    }

    @Override
    public void promoteRelease(@NotNull String promoteTrackName, @Nullable String fromTrackName, @Nullable ReleaseStatus releaseStatus, @Nullable String releaseName, @Nullable Map<String, String> releaseNotes, @Nullable Double userFraction, @Nullable List<Long> retainableArtifacts) {
        Intrinsics.checkParameterIsNotNull((Object)promoteTrackName, (String)"promoteTrackName");
        this.tracks.promote(new TrackManager.PromoteConfig(promoteTrackName, fromTrackName, new TrackManager.BaseConfig(releaseStatus, userFraction, releaseNotes, retainableArtifacts, releaseName)));
    }

    @Override
    public void uploadBundle(@NotNull File bundleFile, @Nullable File mappingFile, @NotNull ResolutionStrategy strategy, long versionCode, @NotNull String variantName, boolean didPreviousBuildSkipCommit, @NotNull String trackName, @NotNull ReleaseStatus releaseStatus, @Nullable String releaseName, @Nullable Map<String, String> releaseNotes, @Nullable Double userFraction, @Nullable List<Long> retainableArtifacts) {
        Bundle bundle;
        Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)strategy), (String)"strategy");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        Intrinsics.checkParameterIsNotNull((Object)trackName, (String)"trackName");
        Intrinsics.checkParameterIsNotNull((Object)((Object)releaseStatus), (String)"releaseStatus");
        try {
            bundle = this.publisher.uploadBundle(this.editId, bundleFile);
        }
        catch (GoogleJsonResponseException e) {
            bundle = (Bundle)this.handleUploadFailures(e, strategy, bundleFile, versionCode, variantName);
        }
        Bundle bundle2 = bundle;
        if (bundle2 == null) {
            return;
        }
        Bundle bundle3 = bundle2;
        Integer n = bundle3.getVersionCode();
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"bundle.versionCode");
        this.uploadMappingFile(n, mappingFile);
        this.tracks.update(new TrackManager.UpdateConfig(trackName, CollectionsKt.listOf((Object)bundle3.getVersionCode()), releaseStatus, didPreviousBuildSkipCommit, new TrackManager.BaseConfig(releaseStatus, userFraction, releaseNotes, retainableArtifacts, releaseName)));
    }

    @Override
    @Nullable
    public Long uploadApk(@NotNull File apkFile, @Nullable File mappingFile, @NotNull ResolutionStrategy strategy, long versionCode, @NotNull String variantName, @Nullable Integer mainObbRetainable, @Nullable Integer patchObbRetainable) {
        Apk apk;
        Intrinsics.checkParameterIsNotNull((Object)apkFile, (String)"apkFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)strategy), (String)"strategy");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        try {
            apk = this.publisher.uploadApk(this.editId, apkFile);
        }
        catch (GoogleJsonResponseException e) {
            this.handleUploadFailures(e, strategy, apkFile, versionCode, variantName);
            return null;
        }
        Apk apk2 = apk;
        Integer n = mainObbRetainable;
        if (n != null) {
            int n2 = n;
            Integer n3 = apk2.getVersionCode();
            Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"apk.versionCode");
            this.attachObb(n2, "main", n3);
        }
        Integer n4 = patchObbRetainable;
        if (n4 != null) {
            int n5 = n4;
            Integer n6 = apk2.getVersionCode();
            Intrinsics.checkExpressionValueIsNotNull((Object)n6, (String)"apk.versionCode");
            this.attachObb(n5, "patch", n6);
        }
        Integer n7 = apk2.getVersionCode();
        Intrinsics.checkExpressionValueIsNotNull((Object)n7, (String)"apk.versionCode");
        this.uploadMappingFile(n7, mappingFile);
        return (long)apk2.getVersionCode();
    }

    @Override
    public void publishApk(@NotNull List<Long> versionCodes, boolean didPreviousBuildSkipCommit, @NotNull String trackName, @NotNull ReleaseStatus releaseStatus, @Nullable String releaseName, @Nullable Map<String, String> releaseNotes, @Nullable Double userFraction, @Nullable List<Long> retainableArtifacts) {
        Intrinsics.checkParameterIsNotNull(versionCodes, (String)"versionCodes");
        Intrinsics.checkParameterIsNotNull((Object)trackName, (String)"trackName");
        Intrinsics.checkParameterIsNotNull((Object)((Object)releaseStatus), (String)"releaseStatus");
        if (versionCodes.isEmpty()) {
            return;
        }
        this.tracks.update(new TrackManager.UpdateConfig(trackName, versionCodes, releaseStatus, didPreviousBuildSkipCommit, new TrackManager.BaseConfig(releaseStatus, userFraction, releaseNotes, retainableArtifacts, releaseName)));
    }

    private final void uploadMappingFile(int versionCode, File mappingFile) {
        if (mappingFile != null && mappingFile.length() > 0L) {
            this.publisher.uploadDeobfuscationFile(this.editId, mappingFile, versionCode);
        }
    }

    private final void attachObb(int $this$attachObb, String type, int versionCode) {
        String string = "Attaching " + type + " OBB (" + $this$attachObb + ") to APK " + versionCode;
        boolean bl = false;
        System.out.println((Object)string);
        this.publisher.attachObb(this.editId, type, versionCode, $this$attachObb);
    }

    private final Void handleUploadFailures(GoogleJsonResponseException e, ResolutionStrategy strategy, File artifact, long versionCode, String variantName) {
        if (AndroidPublisherKt.has(e, "apkNotificationMessageKeyUpgradeVersionConflict") || AndroidPublisherKt.has(e, "apkUpgradeVersionConflict") || AndroidPublisherKt.has(e, "apkNoUpgradePath")) {
            switch (DefaultEditManager$WhenMappings.$EnumSwitchMapping$0[strategy.ordinal()]) {
                case 1: {
                    throw (Throwable)new IllegalStateException("Concurrent uploads for variant " + variantName + " (version code " + versionCode + ' ' + "already used). Make sure to synchronously upload your APKs such " + "that they don't conflict. If this problem persists, delete your " + "drafts in the Play Console's artifact library.", e);
                }
                case 2: {
                    throw (Throwable)new IllegalStateException("Version code " + versionCode + " is too low or has already been used for variant " + variantName + '.', e);
                }
                case 3: {
                    Logging.getLogger(EditManager.class).warn("Ignoring artifact (" + artifact + ") for version code " + versionCode);
                }
            }
        } else {
            throw (Throwable)e;
        }
        return null;
    }

    public DefaultEditManager(@NotNull InternalPlayPublisher publisher, @NotNull TrackManager tracks, @NotNull String editId) {
        Intrinsics.checkParameterIsNotNull((Object)publisher, (String)"publisher");
        Intrinsics.checkParameterIsNotNull((Object)tracks, (String)"tracks");
        Intrinsics.checkParameterIsNotNull((Object)editId, (String)"editId");
        this.publisher = publisher;
        this.tracks = tracks;
        this.editId = editId;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/github/triplet/gradle/androidpublisher/internal/DefaultEditManager$Factory;", "Lcom/github/triplet/gradle/androidpublisher/EditManager$Factory;", "()V", "create", "Lcom/github/triplet/gradle/androidpublisher/internal/DefaultEditManager;", "publisher", "Lcom/github/triplet/gradle/androidpublisher/PlayPublisher;", "editId", "", "android-publisher"})
    public static final class Factory
    implements EditManager.Factory {
        @Override
        @NotNull
        public DefaultEditManager create(@NotNull PlayPublisher publisher, @NotNull String editId) {
            Intrinsics.checkParameterIsNotNull((Object)publisher, (String)"publisher");
            Intrinsics.checkParameterIsNotNull((Object)editId, (String)"editId");
            return new DefaultEditManager((InternalPlayPublisher)publisher, new DefaultTrackManager((InternalPlayPublisher)publisher, editId), editId);
        }
    }
}

