/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.github.triniwiz.canvas.GLContext;
import com.github.triniwiz.canvas.TNSCanvas;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0010\u0010\u0016\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012J(\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0016J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/triniwiz/canvas/GLViewSV;", "Landroid/view/SurfaceView;", "Landroid/view/SurfaceHolder$Callback;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "<set-?>", "Lcom/github/triniwiz/canvas/GLContext;", "gLContext", "getGLContext", "()Lcom/github/triniwiz/canvas/GLContext;", "isCreated", "", "isCreatedWithZeroSized", "mListener", "Lcom/github/triniwiz/canvas/TNSCanvas$Listener;", "flush", "", "init", "queueEvent", "runnable", "Ljava/lang/Runnable;", "setListener", "listener", "surfaceChanged", "holder", "Landroid/view/SurfaceHolder;", "format", "", "width", "height", "surfaceCreated", "surfaceDestroyed", "canvas_release"})
public final class GLViewSV
extends SurfaceView
implements SurfaceHolder.Callback {
    private boolean isCreated;
    private boolean isCreatedWithZeroSized;
    @Nullable
    private GLContext gLContext;
    private TNSCanvas.Listener mListener;

    @Nullable
    public final GLContext getGLContext() {
        return this.gLContext;
    }

    public final void init() {
        this.gLContext = new GLContext();
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public final void flush() {
        GLContext gLContext = this.gLContext;
        Intrinsics.checkNotNull((Object)gLContext);
        gLContext.flush();
    }

    public final void queueEvent(@Nullable Runnable runnable) {
        GLContext gLContext = this.gLContext;
        Intrinsics.checkNotNull((Object)gLContext);
        Runnable runnable2 = runnable;
        Intrinsics.checkNotNull((Object)runnable2);
        gLContext.queueEvent(runnable2);
    }

    public final void setListener(@Nullable TNSCanvas.Listener listener) {
        this.mListener = listener;
    }

    public void surfaceCreated(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!this.isCreated) {
            this.isCreatedWithZeroSized = true;
            this.isCreated = true;
        }
    }

    public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (this.isCreatedWithZeroSized && (width != 0 || height != 0)) {
            GLContext gLContext = this.gLContext;
            Intrinsics.checkNotNull((Object)gLContext);
            gLContext.init(holder.getSurface());
            this.isCreatedWithZeroSized = false;
            if (this.mListener != null) {
                TNSCanvas.Listener listener = this.mListener;
                Intrinsics.checkNotNull((Object)listener);
                listener.contextReady();
            }
        }
    }

    public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.isCreated = false;
    }

    public GLViewSV(@Nullable Context context) {
        super(context);
        this.init();
    }

    public GLViewSV(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }
}

