/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.os.Handler;
import android.os.Looper;
import android.view.Choreographer;
import com.github.triniwiz.canvas.AnimationFrame;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\f"}, d2={"Lcom/github/triniwiz/canvas/AnimationFrame;", "Landroid/view/Choreographer$FrameCallback;", "()V", "doFrame", "", "frameTimeNanos", "", "fps", "currentTimeMillis", "raf", "reset", "Companion", "canvas_release"})
public final class AnimationFrame
implements Choreographer.FrameCallback {
    private static HashMap<Long, Function1<Long, Unit>> callbacks;
    private static long lastCall;
    private static int count;
    private static Timer timer;
    private static AnimationFrame instance;
    private static ExecutorService executorService;
    private static final Object lock;
    private static Choreographer choreographer;
    private static Handler handler;
    private static long animationId;
    private static int _minFps;
    private static int framesRendered;
    private static long frameStartTime;
    private static boolean inAnimationFrame;
    @NotNull
    public static final Companion Companion;

    public final void reset() {
        _minFps = 1000;
        frameStartTime = 0L;
        framesRendered = 0;
    }

    public final void raf(long fps) {
        executorService.submit(new Runnable(this, fps){
            final /* synthetic */ AnimationFrame this$0;
            final /* synthetic */ long $fps;

            public final void run() {
                HashMap hashMap = AnimationFrame.access$getCallbacks$cp();
                Intrinsics.checkNotNull((Object)hashMap);
                Object object = hashMap.clone();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.util.HashMap<kotlin.Long, (kotlin.Long) -> kotlin.Unit>");
                }
                HashMap cbs = (HashMap)object;
                HashMap hashMap2 = AnimationFrame.access$getCallbacks$cp();
                Intrinsics.checkNotNull((Object)hashMap2);
                hashMap2.clear();
                AnimationFrame.access$setInAnimationFrame$cp(true);
                Set<Map.Entry<K, V>> set = cbs.entrySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"cbs.entries");
                Set<Map.Entry<K, V>> set2 = set;
                Iterator<Map.Entry<K, V>> iterator = set2.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> entry;
                    Map.Entry<K, V> entry2 = entry = iterator.next();
                    boolean bl = false;
                    Function1 value = (Function1)entry2.getValue();
                    Handler handler = AnimationFrame.access$getHandler$cp();
                    Intrinsics.checkNotNull((Object)handler);
                    handler.post(new Runnable(this, value){
                        final /* synthetic */ raf.1 this$0;
                        final /* synthetic */ Function1 $value;

                        public final void run() {
                            this.$value.invoke((Object)this.this$0.$fps);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$value = function1;
                        }
                    });
                }
                AnimationFrame.access$setInAnimationFrame$cp(false);
                this.this$0.reset();
            }
            {
                this.this$0 = animationFrame;
                this.$fps = l;
            }
        });
    }

    public final void fps(long currentTimeMillis) {
        int fps = 0;
        if (frameStartTime > 0L) {
            long timeSpan = currentTimeMillis - frameStartTime;
            int n = framesRendered;
            framesRendered = n + 1;
            if (timeSpan > (long)1000) {
                fps = (int)((long)(framesRendered * 1000) / timeSpan);
                if (fps < _minFps) {
                    _minFps = fps;
                }
                this.raf(fps);
                frameStartTime = currentTimeMillis;
                framesRendered = 0;
            }
        } else {
            frameStartTime = currentTimeMillis;
        }
    }

    public void doFrame(long frameTimeNanos) {
        this.fps(frameTimeNanos / (long)1000000);
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)instance);
    }

    static {
        Companion = new Companion(null);
        executorService = Executors.newCachedThreadPool();
        lock = new Object();
        _minFps = 1000;
        callbacks = new HashMap();
        instance = new AnimationFrame();
        handler = new Handler(Looper.getMainLooper());
    }

    public static final /* synthetic */ void access$setCallbacks$cp(HashMap hashMap) {
        callbacks = hashMap;
    }

    public static final /* synthetic */ Handler access$getHandler$cp() {
        return handler;
    }

    public static final /* synthetic */ void access$setHandler$cp(Handler handler) {
        AnimationFrame.handler = handler;
    }

    public static final /* synthetic */ void access$setInstance$cp(AnimationFrame animationFrame) {
        instance = animationFrame;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u0006J\u001a\u0010$\u001a\u00020\u00062\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/github/triniwiz/canvas/AnimationFrame$Companion;", "", "()V", "_minFps", "", "animationId", "", "callbacks", "Ljava/util/HashMap;", "Lkotlin/Function1;", "", "choreographer", "Landroid/view/Choreographer;", "count", "executorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "frameStartTime", "framesRendered", "handler", "Landroid/os/Handler;", "inAnimationFrame", "", "instance", "Lcom/github/triniwiz/canvas/AnimationFrame;", "lastCall", "lock", "newId", "getNewId", "()J", "timeInFrameBase", "getTimeInFrameBase", "timer", "Ljava/util/Timer;", "cancelAnimationFrame", "id", "requestAnimationFrame", "callback", "canvas_release"})
    public static final class Companion {
        private final long getTimeInFrameBase() {
            return System.nanoTime() / (long)1000000;
        }

        private final long getNewId() {
            long l = animationId;
            animationId = l + 1L;
            return animationId;
        }

        public final synchronized long requestAnimationFrame(@NotNull Function1<? super Long, Unit> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            if (!inAnimationFrame) {
                inAnimationFrame = true;
                callback.invoke((Object)this.getTimeInFrameBase());
                inAnimationFrame = false;
                return this.getNewId();
            }
            long id = this.getNewId();
            HashMap hashMap = callbacks;
            Intrinsics.checkNotNull((Object)hashMap);
            ((Map)hashMap).put(id, callback);
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)instance);
            return id;
        }

        public final void cancelAnimationFrame(long id) {
            HashMap hashMap = callbacks;
            Intrinsics.checkNotNull((Object)hashMap);
            hashMap.remove(id);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

