/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import com.github.triniwiz.canvas.TNSCanvas;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J(\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0014R\"\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/github/triniwiz/canvas/CPUView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "canvasView", "Ljava/lang/ref/WeakReference;", "Lcom/github/triniwiz/canvas/TNSCanvas;", "getCanvasView$canvas_release", "()Ljava/lang/ref/WeakReference;", "setCanvasView$canvas_release", "(Ljava/lang/ref/WeakReference;)V", "view", "Landroid/graphics/Bitmap;", "flush", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "canvas_release"})
public final class CPUView
extends View {
    private Bitmap view;
    @Nullable
    private WeakReference<TNSCanvas> canvasView;

    @Nullable
    public final WeakReference<TNSCanvas> getCanvasView$canvas_release() {
        return this.canvasView;
    }

    public final void setCanvasView$canvas_release(@Nullable WeakReference<TNSCanvas> weakReference) {
        this.canvasView = weakReference;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        block2: {
            super.onSizeChanged(w, h, oldw, oldh);
            if (w == 0 || h == 0) break block2;
            this.view = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            WeakReference<TNSCanvas> weakReference = this.canvasView;
            Intrinsics.checkNotNull(weakReference);
            TNSCanvas canvas = (TNSCanvas)((Object)weakReference.get());
            if (canvas != null && canvas.getNativeContext$canvas_release() == 0L) {
                Resources resources = this.getResources();
                Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
                DisplayMetrics metrics = resources.getDisplayMetrics();
                canvas.setNativeContext$canvas_release(TNSCanvas.Companion.nativeInitContextWithCustomSurface(h, w, metrics.density, true, 0, metrics.densityDpi * 160, TNSCanvas.Companion.getDirection$canvas_release().toNative()));
                TNSCanvas.Listener listener = canvas.getListener();
                if (listener != null) {
                    listener.contextReady();
                }
            }
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.view != null) {
            Bitmap bitmap = this.view;
            Intrinsics.checkNotNull((Object)bitmap);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        }
    }

    public final void flush() {
        block1: {
            Object object = this.canvasView;
            if (object == null || (object = (TNSCanvas)((Object)((Reference)object).get())) == null) break block1;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object canvas = object2;
            boolean bl3 = false;
            if (((TNSCanvas)((Object)canvas)).getNativeContext$canvas_release() != 0L) {
                TNSCanvas.Companion.nativeCustomWithBitmapFlush(((TNSCanvas)((Object)canvas)).getNativeContext$canvas_release(), this.view);
                Handler handler = this.getHandler();
                Intrinsics.checkNotNull((Object)handler);
                handler.post(new Runnable((TNSCanvas)((Object)canvas), this){
                    final /* synthetic */ TNSCanvas $canvas;
                    final /* synthetic */ CPUView this$0;
                    {
                        this.$canvas = tNSCanvas;
                        this.this$0 = cPUView;
                    }

                    public final void run() {
                        this.this$0.invalidate();
                        this.$canvas.pendingInvalidate = false;
                    }
                });
            }
        }
    }

    @JvmOverloads
    public CPUView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
    }

    public /* synthetic */ CPUView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CPUView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CPUView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

