/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Base64;
import android.view.Choreographer;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.text.TextUtilsCompat;
import com.github.triniwiz.canvas.CPUView;
import com.github.triniwiz.canvas.CanvasDOMMatrix;
import com.github.triniwiz.canvas.CanvasRenderingContext;
import com.github.triniwiz.canvas.CanvasRenderingContext2D;
import com.github.triniwiz.canvas.GLView;
import com.github.triniwiz.canvas.Utils;
import com.github.triniwiz.canvas.WebGL2RenderingContext;
import com.github.triniwiz.canvas.WebGLRenderingContext;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;

public class CanvasView
extends FrameLayout
implements Choreographer.FrameCallback,
Application.ActivityLifecycleCallbacks {
    static ConcurrentHashMap views = new ConcurrentHashMap();
    private HandlerThread handlerThread = new HandlerThread("CanvasViewThread");
    private Handler handler;
    GLView glView;
    CPUView cpuView;
    private boolean handleInvalidationManually = false;
    volatile long canvas = 0L;
    CanvasRenderingContext renderingContext2d = null;
    float scale = 0.0f;
    Context ctx;
    boolean pendingInvalidate;
    final Object lock = new Object();
    static final long ONE_MILLISECOND_NS = 1000000L;
    static final long ONE_S_IN_NS = 1000000000L;
    Handler mainHandler;
    boolean wasPendingDraw = false;
    static long lastCall = 0L;
    ContextType contextType = ContextType.NONE;
    String actualContextType = "";
    boolean useCpu = false;
    Map<String, Object> contextAttributes = new HashMap<String, Object>();
    boolean contextAlpha = true;
    boolean contextAntialias = true;
    boolean contextDepth = true;
    boolean contextFailIfMajorPerformanceCaveat = false;
    String contextPowerPreference = "default";
    boolean contextPremultipliedAlpha = true;
    boolean contextPreserveDrawingBuffer = false;
    boolean contextStencil = false;
    boolean contextDesynchronized = false;
    boolean contextXrCompatible = false;
    int mClearStencil;
    float[] mClearColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    boolean mScissorEnabled = false;
    float mClearDepth = 1.0f;
    boolean[] mColorMask = new boolean[]{true, true, true, true};
    int mStencilMask = -1;
    int mStencilMaskBack = -1;
    int mStencilFuncRef = 0;
    int mStencilFuncRefBack = 0;
    int mStencilFuncMask = -1;
    int mStencilFuncMaskBack = -1;
    boolean mDepthMask = true;
    Bitmap view;
    private static boolean isLibraryLoaded = false;
    int glVersion;
    int previousOrientation = 0;
    static final String TAG = "CanvasView";
    Handler cpuHandler;
    HandlerThread cpuHandlerThread;
    WebGLRenderingContext webGLRenderingContext;
    WebGL2RenderingContext webGL2RenderingContext;
    int needRenderRequest = 0;
    boolean isPaused;
    SurfaceHolder holder;
    Listener listener;
    int mWidth = -1;
    int mHeight = -1;
    int textureId = 0;
    int renderCount = 0;
    boolean wasDestroyed = false;
    boolean isWebGL = false;
    Size lastSize;
    Size newSize;
    boolean readyEventSent = false;

    public static ConcurrentHashMap getViews() {
        return views;
    }

    static native long nativeInit(boolean var0, int var1, int var2, int var3, float var4, String var5);

    static native long nativeResize(long var0, int var2, int var3, int var4, float var5);

    static native long nativeRecreate(long var0, int var2, int var3, int var4, float var5);

    private static native long nativeDeInit(long var0);

    private static native long nativeDestroy(long var0);

    static native long nativeFlush(long var0);

    static native long nativeCpuFlush(long var0, Bitmap var2);

    private static native String nativeToDataUrl(long var0, String var2, float var3);

    private static native byte[] nativeToData(long var0);

    private static native byte[] nativeSnapshotCanvas(long var0);

    private static native ByteBuffer nativeSnapshotCanvasBuffer(long var0);

    void clear() {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                GLES20.glClear((int)16384);
            }
        });
    }

    public void doFrame(long frameTimeNanos) {
        if (!this.handleInvalidationManually && this.pendingInvalidate) {
            this.flush();
        }
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
    }

    public CanvasView(Context context) {
        super(context, null);
        this.init(context, false);
    }

    public CanvasView(Context context, boolean useCpu) {
        super(context, null);
        this.init(context, useCpu);
    }

    public CanvasView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, false);
    }

    private void init(Context context, boolean useCpu) {
        if (this.isInEditMode()) {
            return;
        }
        this.useCpu = useCpu;
        if (!isLibraryLoaded) {
            System.loadLibrary("canvasnative");
            isLibraryLoaded = true;
        }
        this.setBackgroundColor(0);
        this.glView = new GLView(context);
        this.glView.getGLContext().reference = new WeakReference<CanvasView>(this);
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper());
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.ctx = context;
        this.scale = context.getResources().getDisplayMetrics().density;
        this.glVersion = this.detectOpenGLES30() && !Utils.isEmulator() ? 3 : 2;
        this.glView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        if (useCpu) {
            this.cpuView = new CPUView(context);
            this.cpuView.canvasView = new WeakReference<CanvasView>(this);
            this.cpuView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.initCPUThread();
            this.addView(this.cpuView);
        } else {
            this.addView((View)this.glView);
        }
    }

    private void initCPUThread() {
        this.cpuHandlerThread = new HandlerThread("CanvasViewCpuThread");
        this.cpuHandlerThread.start();
        this.cpuHandler = new Handler(this.cpuHandlerThread.getLooper());
    }

    int getDrawingBufferWidth() {
        if (this.useCpu) {
            return this.cpuView.getWidth();
        }
        return this.glView.drawingBufferWidth;
    }

    int getDrawingBufferHeight() {
        if (this.useCpu) {
            return this.cpuView.getHeight();
        }
        return this.glView.drawingBufferHeight;
    }

    private boolean detectOpenGLES30() {
        ActivityManager am = (ActivityManager)this.getContext().getSystemService("activity");
        if (am == null) {
            return false;
        }
        ConfigurationInfo info = am.getDeviceConfigurationInfo();
        return info.reqGlEsVersion >= 196608;
    }

    public void onPause() {
        if (this.glView != null) {
            this.glView.getGLContext().onPause();
        }
    }

    public void onResume() {
        if (this.glView != null) {
            this.glView.getGLContext().onResume();
        }
    }

    public void destroy() {
        CanvasView.nativeDestroy(this.canvas);
        this.canvas = 0L;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.canvas != 0L) {
            this.destroy();
        }
    }

    public void setHandleInvalidationManually(boolean handleInvalidationManually) {
        this.handleInvalidationManually = handleInvalidationManually;
    }

    public boolean isHandleInvalidationManually() {
        return this.handleInvalidationManually;
    }

    public GLView getSurface() {
        return this.glView;
    }

    public void queueEvent(Runnable runnable) {
        if (this.useCpu) {
            if (!this.cpuHandlerThread.isAlive() || this.cpuHandlerThread.isInterrupted()) {
                this.cpuHandlerThread = null;
                this.cpuHandler = null;
                this.initCPUThread();
            }
            this.cpuHandler.post(runnable);
        } else {
            this.glView.queueEvent(runnable);
        }
    }

    public void setupActivityHandler(Application app) {
        app.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
    }

    public void onActivityStarted(@NonNull Activity activity) {
    }

    public void onActivityResumed(@NonNull Activity activity) {
    }

    public void onActivityPaused(@NonNull Activity activity) {
    }

    public void onActivityStopped(@NonNull Activity activity) {
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
    }

    public byte[] toData() {
        if (this.contextType == ContextType.CANVAS) {
            final CountDownLatch lock = new CountDownLatch(1);
            final byte[][] data = new byte[1][];
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    data[0] = CanvasView.nativeToData(CanvasView.this.canvas);
                    lock.countDown();
                }
            });
            try {
                lock.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return data[0];
        }
        if (this.contextType == ContextType.WEBGL) {
            Bitmap bm = this.glView.getBitmap(this.getWidth(), this.getHeight());
            byte[] data = new byte[bm.getWidth() * bm.getHeight() * 4];
            ByteBuffer buffer = ByteBuffer.wrap(data);
            bm.copyPixelsToBuffer((Buffer)buffer);
            return data;
        }
        return new byte[0];
    }

    byte[] snapshot() {
        if (this.contextType == ContextType.CANVAS) {
            final CountDownLatch lock = new CountDownLatch(1);
            final ArrayList ss = new ArrayList();
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    ss.add(CanvasView.nativeSnapshotCanvas(CanvasView.this.canvas));
                    lock.countDown();
                }
            });
            try {
                lock.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return (byte[])ss.get(0);
        }
        if (this.contextType == ContextType.WEBGL) {
            Bitmap bm = this.glView.getBitmap(this.getWidth(), this.getHeight());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            bm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
            return os.toByteArray();
        }
        return new byte[0];
    }

    public String toDataURL() {
        return this.toDataURL("image/png");
    }

    public void toDataURLAsync(DataURLListener listener) {
        this.toDataURLAsync("image/png", listener);
    }

    public void toDataURLAsync(String type, DataURLListener listener) {
        this.toDataURLAsync(type, 0.92f, listener);
    }

    public void toDataURLAsync(final String type, final float quality, final DataURLListener listener) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                listener.onResult(CanvasView.nativeToDataUrl(CanvasView.this.canvas, type, quality));
            }
        });
    }

    public String toDataURL(String type) {
        return this.toDataURL(type, 0.92f);
    }

    public String toDataURL(final String type, final float quality) {
        if (this.contextType == ContextType.WEBGL) {
            Bitmap bm = this.glView.getBitmap(this.getWidth(), this.getHeight());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            String dataType = "image/png";
            switch (type) {
                case "image/jpeg": {
                    dataType = "image/jpeg";
                    break;
                }
                case "image/jpg": {
                    dataType = "image/jpg";
                    break;
                }
            }
            if (bm != null) {
                if (type.equals("image/jpeg") || type.equals("image/jpg")) {
                    bm.compress(Bitmap.CompressFormat.JPEG, (int)(quality * 100.0f), (OutputStream)os);
                } else {
                    bm.compress(Bitmap.CompressFormat.PNG, (int)(quality * 100.0f), (OutputStream)os);
                }
            }
            return String.format("data:%s;base64,%s", dataType, Base64.encodeToString((byte[])os.toByteArray(), (int)2));
        }
        final CountDownLatch lock = new CountDownLatch(1);
        final String[] data = new String[1];
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                data[0] = CanvasView.nativeToDataUrl(CanvasView.this.canvas, type, quality);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return data[0];
    }

    public static CanvasDOMMatrix createSVGMatrix() {
        return new CanvasDOMMatrix();
    }

    public void resizeViewPort() {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                GLES20.glViewport((int)0, (int)0, (int)CanvasView.this.getWidth(), (int)CanvasView.this.getHeight());
            }
        });
    }

    static String getDirection() {
        String direction = "ltr";
        if (TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1) {
            direction = "rtl";
        }
        return direction;
    }

    void initCanvas() {
        if (this.glView != null && this.canvas == 0L) {
            int width = this.glView.getWidth();
            int height = this.glView.getHeight();
            ViewGroup.LayoutParams params = this.glView.getLayoutParams();
            if (width == 0 && params != null) {
                width = params.width;
                ++this.needRenderRequest;
            }
            if (height == 0 && params != null) {
                height = params.height;
                ++this.needRenderRequest;
            }
            if (width == 0) {
                width = 1;
                ++this.needRenderRequest;
            }
            if (height == 0) {
                height = 1;
                ++this.needRenderRequest;
            }
            if (this.newSize == null || this.newSize.width == 0 && this.newSize.height == 0) {
                this.newSize = new Size(width, height);
            }
            final int finalWidth = width;
            final int finalHeight = height;
            this.glView.queueEvent(new Runnable(){

                @Override
                public void run() {
                    if (CanvasView.this.canvas == 0L && finalWidth > 0 && finalHeight > 0) {
                        int[] frameBuffers = new int[1];
                        GLES20.glViewport((int)0, (int)0, (int)finalWidth, (int)finalHeight);
                        GLES20.glGetIntegerv((int)36006, (int[])frameBuffers, (int)0);
                        CanvasView.this.canvas = CanvasView.nativeInit(CanvasView.this.useCpu, frameBuffers[0], finalWidth, finalHeight, CanvasView.this.scale, CanvasView.getDirection());
                    }
                }
            });
        }
    }

    @Nullable
    public CanvasRenderingContext getContext(String type) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (type.equals("2d")) {
            attributes.put("alpha", true);
            attributes.put("desynchronized", false);
        } else if (type.contains("webgl")) {
            attributes.put("alpha", true);
            attributes.put("depth", true);
            attributes.put("failIfMajorPerformanceCaveat", false);
            attributes.put("powerPreference", "default");
            attributes.put("premultipliedAlpha", true);
            attributes.put("preserveDrawingBuffer", false);
            attributes.put("stencil", false);
            attributes.put("xrCompatible", false);
            attributes.put("desynchronized", false);
        }
        return this.getContext(type, attributes);
    }

    private void handleAttributes(@Nullable Map<String, Object> contextAttributes) {
        if (contextAttributes != null) {
            Set<String> keys = contextAttributes.keySet();
            for (String key : keys) {
                Object value = contextAttributes.get(key);
                switch (key) {
                    case "alpha": {
                        this.contextAlpha = (Boolean)value;
                    }
                    case "depth": {
                        this.contextDepth = (Boolean)value;
                    }
                    case "failIfMajorPerformanceCaveat": {
                        this.contextFailIfMajorPerformanceCaveat = (Boolean)value;
                    }
                    case "premultipliedAlpha": {
                        this.contextPremultipliedAlpha = (Boolean)value;
                    }
                    case "preserveDrawingBuffer": {
                        this.contextPreserveDrawingBuffer = (Boolean)value;
                    }
                    case "stencil": {
                        this.contextStencil = (Boolean)value;
                    }
                    case "xrCompatible": {
                        this.contextXrCompatible = (Boolean)value;
                    }
                    case "desynchronized": {
                        this.contextDesynchronized = (Boolean)value;
                        break;
                    }
                    case "powerPreference": {
                        this.contextPowerPreference = (String)value;
                        break;
                    }
                }
            }
        }
    }

    @Nullable
    public CanvasRenderingContext getContext(String type, @Nullable Map<String, Object> contextAttributes) {
        this.handleAttributes(contextAttributes);
        if (type.equals("2d") || type.equals("experimental-webgl") || type.equals("webgl") || type.equals("webgl2") && Build.VERSION.SDK_INT >= 18) {
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    CanvasView.this.glView.setOpaque(!CanvasView.this.contextAlpha);
                }
            });
            if (type.equals("2d")) {
                this.contextType = ContextType.CANVAS;
            }
            if (this.renderingContext2d == null && this.webGLRenderingContext == null && this.webGL2RenderingContext == null) {
                this.glView.setupContext();
            }
        }
        switch (type) {
            case "2d": {
                this.actualContextType = "2d";
                if (this.renderingContext2d == null) {
                    this.renderingContext2d = new CanvasRenderingContext2D(this);
                }
                this.contextType = ContextType.CANVAS;
                return this.renderingContext2d;
            }
            case "webgl": 
            case "experimental-webgl": {
                this.actualContextType = "webgl";
                if (this.webGLRenderingContext == null) {
                    this.webGLRenderingContext = new WebGLRenderingContext(this);
                }
                this.contextType = ContextType.WEBGL;
                return this.webGLRenderingContext;
            }
            case "webgl2": {
                if (this.webGL2RenderingContext == null) {
                    if (Build.VERSION.SDK_INT >= 18) {
                        this.actualContextType = "webgl";
                        this.webGL2RenderingContext = new WebGL2RenderingContext(this);
                        this.isWebGL = true;
                        this.contextType = ContextType.WEBGL;
                    } else {
                        this.isWebGL = false;
                        this.contextType = ContextType.NONE;
                        return null;
                    }
                }
                return this.webGL2RenderingContext;
            }
        }
        this.contextType = ContextType.NONE;
        return null;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.glView.resize(w, h);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.isPaused = true;
        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isPaused = false;
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
        if (this.glView != null) {
            this.glView.setListener(listener);
        }
    }

    public void flush() {
        if (this.useCpu) {
            this.cpuView.flush();
        } else {
            this.glView.flush();
        }
    }

    void showForeground() {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                CanvasView.this.setForeground((Drawable)new ColorDrawable(-1));
            }
        });
    }

    void hideForeground() {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                CanvasView.this.setForeground(null);
            }
        });
    }

    static class Size {
        int width;
        int height;

        Size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }
    }

    public static interface Listener {
        public void contextReady();
    }

    static enum ContextType {
        NONE,
        CANVAS,
        WEBGL;

    }

    public static interface DataURLListener {
        public void onResult(String var1);
    }
}

