/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.graphics.Bitmap;
import android.opengl.GLES30;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.github.triniwiz.canvas.CanvasView;
import com.github.triniwiz.canvas.ImageAsset;
import com.github.triniwiz.canvas.IndexedParameter;
import com.github.triniwiz.canvas.WebGLActiveInfo;
import com.github.triniwiz.canvas.WebGLRenderingContext;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

@RequiresApi(value=18)
public class WebGL2RenderingContext
extends WebGLRenderingContext {
    public final int READ_BUFFER = 3074;
    public final int UNPACK_ROW_LENGTH = 3314;
    public final int UNPACK_SKIP_ROWS = 3315;
    public final int UNPACK_SKIP_PIXELS = 3316;
    public final int PACK_ROW_LENGTH = 3330;
    public final int PACK_SKIP_ROWS = 3331;
    public final int PACK_SKIP_PIXELS = 3332;
    public final int TEXTURE_BINDING_3D = 32874;
    public final int UNPACK_SKIP_IMAGES = 32877;
    public final int UNPACK_IMAGE_HEIGHT = 32878;
    public final int MAX_3D_TEXTURE_SIZE = 32883;
    public final int MAX_ELEMENTS_VERTICES = 33000;
    public final int MAX_ELEMENTS_INDICES = 33001;
    public final int MAX_TEXTURE_LOD_BIAS = 34045;
    public final int MAX_FRAGMENT_UNIFORM_COMPONENTS = 35657;
    public final int MAX_VERTEX_UNIFORM_COMPONENTS = 35658;
    public final int MAX_ARRAY_TEXTURE_LAYERS = 35071;
    public final int MIN_PROGRAM_TEXEL_OFFSET = 35076;
    public final int MAX_PROGRAM_TEXEL_OFFSET = 35077;
    public final int MAX_VARYING_COMPONENTS = 35659;
    public final int FRAGMENT_SHADER_DERIVATIVE_HINT = 35723;
    public final int RASTERIZER_DISCARD = 35977;
    public final int VERTEX_ARRAY_BINDING = 34229;
    public final int MAX_VERTEX_OUTPUT_COMPONENTS = 37154;
    public final int MAX_FRAGMENT_INPUT_COMPONENTS = 37157;
    public final int MAX_SERVER_WAIT_TIMEOUT = 37137;
    public final int MAX_ELEMENT_INDEX = 36203;
    public final int RED = 6403;
    public final int RGB8 = 32849;
    public final int RGBA8 = 32856;
    public final int RGB10_A2 = 32857;
    public final int TEXTURE_3D = 32879;
    public final int TEXTURE_WRAP_R = 32882;
    public final int TEXTURE_MIN_LOD = 33082;
    public final int TEXTURE_MAX_LOD = 33083;
    public final int TEXTURE_BASE_LEVEL = 33084;
    public final int TEXTURE_MAX_LEVEL = 33085;
    public final int TEXTURE_COMPARE_MODE = 34892;
    public final int TEXTURE_COMPARE_FUNC = 34893;
    public final int SRGB = 35904;
    public final int SRGB8 = 35905;
    public final int SRGB8_ALPHA8 = 35907;
    public final int COMPARE_REF_TO_TEXTURE = 34894;
    public final int RGBA32F = 34836;
    public final int RGB32F = 34837;
    public final int RGBA16F = 34842;
    public final int RGB16F = 34843;
    public final int TEXTURE_2D_ARRAY = 35866;
    public final int TEXTURE_BINDING_2D_ARRAY = 35869;
    public final int R11F_G11F_B10F = 35898;
    public final int RGB9_E5 = 35901;
    public final int RGBA32UI = 36208;
    public final int RGB32UI = 36209;
    public final int RGBA16UI = 36214;
    public final int RGB16UI = 36215;
    public final int RGBA8UI = 36220;
    public final int RGB8UI = 36221;
    public final int RGBA32I = 36226;
    public final int RGB32I = 36227;
    public final int RGBA16I = 36232;
    public final int RGB16I = 36233;
    public final int RGBA8I = 36238;
    public final int RGB8I = 36239;
    public final int RED_INTEGER = 36244;
    public final int RGB_INTEGER = 36248;
    public final int RGBA_INTEGER = 36249;
    public final int R8 = 33321;
    public final int RG8 = 33323;
    public final int R16F = 33325;
    public final int R32F = 33326;
    public final int RG16F = 33327;
    public final int RG32F = 33328;
    public final int R8I = 33329;
    public final int R8UI = 33330;
    public final int R16I = 33331;
    public final int R16UI = 33332;
    public final int R32I = 33333;
    public final int R32UI = 33334;
    public final int RG8I = 33335;
    public final int RG8UI = 33336;
    public final int RG16I = 33337;
    public final int RG16UI = 33338;
    public final int RG32I = 33339;
    public final int RG32UI = 33340;
    public final int R8_SNORM = 36756;
    public final int RG8_SNORM = 36757;
    public final int RGB8_SNORM = 36758;
    public final int RGBA8_SNORM = 36759;
    public final int RGB10_A2UI = 36975;
    public final int TEXTURE_IMMUTABLE_FORMAT = 37167;
    public final int TEXTURE_IMMUTABLE_LEVELS = 33503;
    public final int UNSIGNED_INT_2_10_10_10_REV = 33640;
    public final int UNSIGNED_INT_10F_11F_11F_REV = 35899;
    public final int UNSIGNED_INT_5_9_9_9_REV = 35902;
    public final int FLOAT_32_UNSIGNED_INT_24_8_REV = 36269;
    public final int UNSIGNED_INT_24_8 = 34042;
    public final int HALF_FLOAT = 5131;
    public final int RG = 33319;
    public final int RG_INTEGER = 33320;
    public final int INT_2_10_10_10_REV = 36255;
    public final int QUERY_RESULT_AVAILABLE = 34919;
    public final int QUERY_RESULT = 34918;
    public final int CURRENT_QUERY = 34917;
    public final int ANY_SAMPLES_PASSED = 35887;
    public final int ANY_SAMPLES_PASSED_CONSERVATIVE = 36202;
    public final int MAX_DRAW_BUFFERS = 34852;
    public final int DRAW_BUFFER0 = 34853;
    public final int DRAW_BUFFER1 = 34854;
    public final int DRAW_BUFFER2 = 34855;
    public final int DRAW_BUFFER3 = 34856;
    public final int DRAW_BUFFER4 = 34857;
    public final int DRAW_BUFFER5 = 34858;
    public final int DRAW_BUFFER6 = 34859;
    public final int DRAW_BUFFER7 = 34860;
    public final int DRAW_BUFFER8 = 34861;
    public final int DRAW_BUFFER9 = 34862;
    public final int DRAW_BUFFER10 = 34863;
    public final int DRAW_BUFFER11 = 34864;
    public final int DRAW_BUFFER12 = 34865;
    public final int DRAW_BUFFER13 = 34866;
    public final int DRAW_BUFFER14 = 34867;
    public final int DRAW_BUFFER15 = 34868;
    public final int MAX_COLOR_ATTACHMENTS = 36063;
    public final int COLOR_ATTACHMENT1 = 36065;
    public final int COLOR_ATTACHMENT2 = 36066;
    public final int COLOR_ATTACHMENT3 = 36067;
    public final int COLOR_ATTACHMENT4 = 36068;
    public final int COLOR_ATTACHMENT5 = 36069;
    public final int COLOR_ATTACHMENT6 = 36070;
    public final int COLOR_ATTACHMENT7 = 36071;
    public final int COLOR_ATTACHMENT8 = 36072;
    public final int COLOR_ATTACHMENT9 = 36073;
    public final int COLOR_ATTACHMENT10 = 36074;
    public final int COLOR_ATTACHMENT11 = 36075;
    public final int COLOR_ATTACHMENT12 = 36076;
    public final int COLOR_ATTACHMENT13 = 36077;
    public final int COLOR_ATTACHMENT14 = 36078;
    public final int COLOR_ATTACHMENT15 = 36079;
    public final int SAMPLER_3D = 35679;
    public final int SAMPLER_2D_SHADOW = 35682;
    public final int SAMPLER_2D_ARRAY = 36289;
    public final int SAMPLER_2D_ARRAY_SHADOW = 36292;
    public final int SAMPLER_CUBE_SHADOW = 36293;
    public final int INT_SAMPLER_2D = 36298;
    public final int INT_SAMPLER_3D = 36299;
    public final int INT_SAMPLER_CUBE = 36300;
    public final int INT_SAMPLER_2D_ARRAY = 36303;
    public final int UNSIGNED_INT_SAMPLER_2D = 36306;
    public final int UNSIGNED_INT_SAMPLER_3D = 36307;
    public final int UNSIGNED_INT_SAMPLER_CUBE = 36308;
    public final int UNSIGNED_INT_SAMPLER_2D_ARRAY = 36311;
    public final int MAX_SAMPLES = 36183;
    public final int SAMPLER_BINDING = 35097;
    public final int PIXEL_PACK_BUFFER = 35051;
    public final int PIXEL_UNPACK_BUFFER = 35052;
    public final int PIXEL_PACK_BUFFER_BINDING = 35053;
    public final int PIXEL_UNPACK_BUFFER_BINDING = 35055;
    public final int COPY_READ_BUFFER = 36662;
    public final int COPY_WRITE_BUFFER = 36663;
    public final int COPY_READ_BUFFER_BINDING = 36662;
    public final int COPY_WRITE_BUFFER_BINDING = 36663;
    public final int FLOAT_MAT2x3 = 35685;
    public final int FLOAT_MAT2x4 = 35686;
    public final int FLOAT_MAT3x2 = 35687;
    public final int FLOAT_MAT3x4 = 35688;
    public final int FLOAT_MAT4x2 = 35689;
    public final int FLOAT_MAT4x3 = 35690;
    public final int UNSIGNED_INT_VEC2 = 36294;
    public final int UNSIGNED_INT_VEC3 = 36295;
    public final int UNSIGNED_INT_VEC4 = 36296;
    public final int UNSIGNED_NORMALIZED = 35863;
    public final int SIGNED_NORMALIZED = 36764;
    public final int VERTEX_ATTRIB_ARRAY_INTEGER = 35069;
    public final int VERTEX_ATTRIB_ARRAY_DIVISOR = 35070;
    public final int TRANSFORM_FEEDBACK_BUFFER_MODE = 35967;
    public final int MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = 35968;
    public final int TRANSFORM_FEEDBACK_VARYINGS = 35971;
    public final int TRANSFORM_FEEDBACK_BUFFER_START = 35972;
    public final int TRANSFORM_FEEDBACK_BUFFER_SIZE = 35973;
    public final int TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 35976;
    public final int MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = 35978;
    public final int MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = 35979;
    public final int INTERLEAVED_ATTRIBS = 35980;
    public final int SEPARATE_ATTRIBS = 35981;
    public final int TRANSFORM_FEEDBACK_BUFFER = 35982;
    public final int TRANSFORM_FEEDBACK_BUFFER_BINDING = 35983;
    public final int TRANSFORM_FEEDBACK = 36386;
    public final int TRANSFORM_FEEDBACK_PAUSED = 36387;
    public final int TRANSFORM_FEEDBACK_ACTIVE = 36388;
    public final int TRANSFORM_FEEDBACK_BINDING = 36389;
    public final int FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 33296;
    public final int FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 33297;
    public final int FRAMEBUFFER_ATTACHMENT_RED_SIZE = 33298;
    public final int FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 33299;
    public final int FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 33300;
    public final int FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 33301;
    public final int FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 33302;
    public final int FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 33303;
    public final int FRAMEBUFFER_DEFAULT = 33304;
    public final int DEPTH_STENCIL_ATTACHMENT = 33306;
    public final int DEPTH_STENCIL = 34041;
    public final int DEPTH24_STENCIL8 = 35056;
    public final int DRAW_FRAMEBUFFER_BINDING = 36006;
    public final int READ_FRAMEBUFFER = 36008;
    public final int DRAW_FRAMEBUFFER = 36009;
    public final int READ_FRAMEBUFFER_BINDING = 36010;
    public final int RENDERBUFFER_SAMPLES = 36011;
    public final int FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 36052;
    public final int FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 36182;
    public final int UNIFORM_BUFFER = 35345;
    public final int UNIFORM_BUFFER_BINDING = 35368;
    public final int UNIFORM_BUFFER_START = 35369;
    public final int UNIFORM_BUFFER_SIZE = 35370;
    public final int MAX_VERTEX_UNIFORM_BLOCKS = 35371;
    public final int MAX_FRAGMENT_UNIFORM_BLOCKS = 35373;
    public final int MAX_COMBINED_UNIFORM_BLOCKS = 35374;
    public final int MAX_UNIFORM_BUFFER_BINDINGS = 35375;
    public final int MAX_UNIFORM_BLOCK_SIZE = 35376;
    public final int MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 35377;
    public final int MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 35379;
    public final int UNIFORM_BUFFER_OFFSET_ALIGNMENT = 35380;
    public final int ACTIVE_UNIFORM_BLOCKS = 35382;
    public final int UNIFORM_TYPE = 35383;
    public final int UNIFORM_SIZE = 35384;
    public final int UNIFORM_BLOCK_INDEX = 35386;
    public final int UNIFORM_OFFSET = 35387;
    public final int UNIFORM_ARRAY_STRIDE = 35388;
    public final int UNIFORM_MATRIX_STRIDE = 35389;
    public final int UNIFORM_IS_ROW_MAJOR = 35390;
    public final int UNIFORM_BLOCK_BINDING = 35391;
    public final int UNIFORM_BLOCK_DATA_SIZE = 35392;
    public final int UNIFORM_BLOCK_ACTIVE_UNIFORMS = 35394;
    public final int UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 35395;
    public final int UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 35396;
    public final int UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 35398;
    public final int OBJECT_TYPE = 37138;
    public final int SYNC_CONDITION = 37139;
    public final int SYNC_STATUS = 37140;
    public final int SYNC_FLAGS = 37141;
    public final int SYNC_FENCE = 37142;
    public final int SYNC_GPU_COMMANDS_COMPLETE = 37143;
    public final int UNSIGNALED = 37144;
    public final int SIGNALED = 37145;
    public final int ALREADY_SIGNALED = 37146;
    public final int TIMEOUT_EXPIRED = 37147;
    public final int CONDITION_SATISFIED = 37148;
    public final int WAIT_FAILED = 37149;
    public final int SYNC_FLUSH_COMMANDS_BIT = 1;
    public final int COLOR = 6144;
    public final int DEPTH = 6145;
    public final int STENCIL = 6146;
    public final int MIN = 32775;
    public final int MAX = 32776;
    public final int DEPTH_COMPONENT24 = 33190;
    public final int STREAM_READ = 35041;
    public final int STREAM_COPY = 35042;
    public final int STATIC_READ = 35045;
    public final int STATIC_COPY = 35046;
    public final int DYNAMIC_READ = 35049;
    public final int DYNAMIC_COPY = 35050;
    public final int DEPTH_COMPONENT32F = 36012;
    public final int DEPTH32F_STENCIL8 = 36013;
    public final int INVALID_INDEX = -1;
    public final long TIMEOUT_IGNORED = -1L;
    public final int MAX_CLIENT_WAIT_TIMEOUT_WEBGL = 37447;

    native void nativeFlipInPlace3D(byte[] var1, int var2, int var3, int var4);

    native void nativeTexImage3DAsset(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, boolean var12);

    native void nativeTexSubImage3DAsset(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, boolean var13);

    public WebGL2RenderingContext(CanvasView canvas) {
        super(canvas);
    }

    public WebGL2RenderingContext(CanvasView canvas, Map<String, Object> attrs) {
        super(canvas, attrs);
    }

    public void beginQuery(final int target, final int query) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glBeginQuery((int)target, (int)query);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void beginTransformFeedback(final int primitiveMode) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glBeginTransformFeedback((int)primitiveMode);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bindBufferBase(final int target, final int index, final int buffer) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glBindBufferBase((int)target, (int)index, (int)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bindBufferRange(final int target, final int index, final int buffer, final int offset, final int size) {
        CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glBindBufferRange((int)target, (int)index, (int)buffer, (int)offset, (int)size);
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bindSampler(final int unit, final int sampler) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glBindSampler((int)unit, (int)sampler);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bindTransformFeedback(final int target, final int transformFeedback) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glBindTransformFeedback((int)target, (int)transformFeedback);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bindVertexArray(final int vertexArray) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glBindVertexArray((int)vertexArray);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void blitFramebuffer(final int srcX0, final int srcY0, final int srcX1, final int srcY1, final int dstX0, final int dstY0, final int dstX1, final int dstY1, final int mask, final int filter) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glBlitFramebuffer((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void clearBufferfv(final int buffer, final int drawbuffer, final float[] values) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glClearBufferfv((int)buffer, (int)drawbuffer, (FloatBuffer)FloatBuffer.wrap(values));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void clearBufferiv(final int buffer, final int drawbuffer, final int[] values) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glClearBufferiv((int)buffer, (int)drawbuffer, (IntBuffer)IntBuffer.wrap(values));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void clearBufferuiv(final int buffer, final int drawbuffer, final int[] values) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glClearBufferuiv((int)buffer, (int)drawbuffer, (IntBuffer)IntBuffer.wrap(values));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void clearBufferfi(final int buffer, final int drawbuffer, final float depth, final int stencil) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glClearBufferfi((int)buffer, (int)drawbuffer, (float)depth, (int)stencil);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int clientWaitSync(final long sync, final int flags, final long timeout) {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] value = new int[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES30.glClientWaitSync((long)sync, (int)flags, (long)timeout);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public void compressedTexSubImage3D(final int target, final int level, final int xoffset, final int yoffset, final int zoffset, final int width, final int height, final int depth, final int format, final int imageSize, final int offset) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glCompressedTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)imageSize, (int)offset);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void compressedTexSubImage3D(final int target, final int level, final int xoffset, final int yoffset, final int zoffset, final int width, final int height, final int depth, final int format, final byte[] srcData, final int srcOffset, int srcLengthOverride) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                ByteBuffer buffer = ByteBuffer.wrap(srcData);
                buffer.position(srcOffset);
                GLES30.glCompressedTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)(1 * srcData.length), (Buffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void copyBufferSubData(final int readTarget, final int writeTarget, final int readOffset, final int writeOffset, final int size) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glCopyBufferSubData((int)readTarget, (int)writeTarget, (int)readOffset, (int)writeOffset, (int)size);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void copyTexSubImage3D(final int target, final int level, final int xoffset, final int yoffset, final int zoffset, final int x, final int y, final int width, final int height) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                WebGL2RenderingContext.this.clearIfComposited();
                GLES30.glCopyTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)x, (int)y, (int)width, (int)height);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public int createQuery() {
        final CountDownLatch lock = new CountDownLatch(1);
        final IntBuffer query = IntBuffer.allocate(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glGenQueries((int)1, (IntBuffer)query);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return query.get(0);
    }

    public int createSampler() {
        final CountDownLatch lock = new CountDownLatch(1);
        final IntBuffer sampler = IntBuffer.allocate(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glGenSamplers((int)1, (IntBuffer)sampler);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return sampler.get(0);
    }

    public int createVertexArray() {
        final CountDownLatch lock = new CountDownLatch(1);
        final IntBuffer array = IntBuffer.allocate(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glGenVertexArrays((int)1, (IntBuffer)array);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return array.get(0);
    }

    public int createTransformFeedback() {
        final CountDownLatch lock = new CountDownLatch(1);
        final IntBuffer id = IntBuffer.allocate(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glGenTransformFeedbacks((int)1, (IntBuffer)id);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return id.get(0);
    }

    public void deleteQuery(final int query) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int[] id = new int[]{query};
                GLES30.glDeleteQueries((int)1, (int[])id, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void deleteSampler(final int sampler) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int[] id = new int[]{sampler};
                GLES30.glDeleteQueries((int)1, (int[])id, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void deleteSync(final int sync) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glDeleteSync((long)sync);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void deleteTransformFeedback(final int transformFeedback) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int[] feedback = new int[]{transformFeedback};
                GLES30.glDeleteTransformFeedbacks((int)1, (int[])feedback, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void deleteVertexArray(final int vertexArray) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int[] array = new int[]{vertexArray};
                GLES30.glDeleteVertexArrays((int)1, (int[])array, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void drawArraysInstanced(final int mode, final int first, final int count, final int instanceCount) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                WebGL2RenderingContext.this.clearIfComposited();
                GLES30.glDrawArraysInstanced((int)mode, (int)first, (int)count, (int)instanceCount);
                WebGL2RenderingContext.this.updateCanvas();
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void drawElementsInstanced(final int mode, final int count, final int type, final int offset, final int instanceCount) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                WebGL2RenderingContext.this.clearIfComposited();
                GLES30.glDrawElementsInstanced((int)mode, (int)count, (int)type, (int)offset, (int)instanceCount);
                WebGL2RenderingContext.this.updateCanvas();
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void drawRangeElements(final int mode, final int start, final int end, final int count, final int type, final int offset) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                WebGL2RenderingContext.this.clearIfComposited();
                GLES30.glDrawRangeElements((int)mode, (int)start, (int)end, (int)count, (int)type, (int)offset);
                WebGL2RenderingContext.this.updateCanvas();
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void drawBuffers(final int[] buffers) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glDrawBuffers((int)buffers.length, (IntBuffer)IntBuffer.wrap(buffers));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void endQuery(final int target) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glEndQuery((int)target);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void endTransformFeedback() {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glEndTransformFeedback();
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void fenceSync(final int condition, final int flags) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glFenceSync((int)condition, (int)flags);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void framebufferTextureLayer(final int target, final int attachment, final int texture, final int level, final int layer) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glFramebufferTextureLayer((int)target, (int)attachment, (int)texture, (int)level, (int)layer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getActiveUniformBlockName(final int program, final int uniformBlockIndex) {
        final CountDownLatch lock = new CountDownLatch(1);
        final String[] value = new String[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer maxNameLength = IntBuffer.allocate(1);
                GLES30.glGetProgramiv((int)program, (int)35381, (IntBuffer)maxNameLength);
                byte[] name = new byte[maxNameLength.get(0)];
                IntBuffer length = IntBuffer.allocate(1);
                GLES30.glGetActiveUniformBlockName((int)program, (int)uniformBlockIndex, (Buffer)length, (Buffer)ByteBuffer.wrap(name));
                value[0] = Build.VERSION.SDK_INT >= 19 ? new String(name, StandardCharsets.UTF_8) : new String(name, Charset.forName("UTF-8"));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public Object getActiveUniformBlockParameter(final int program, final int uniformBlockIndex, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final Object[] value = new Object[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                switch (pname) {
                    case 35391: 
                    case 35392: 
                    case 35394: {
                        IntBuffer intValue = IntBuffer.allocate(1);
                        GLES30.glGetActiveUniformBlockiv((int)program, (int)uniformBlockIndex, (int)pname, (IntBuffer)intValue);
                        value[0] = intValue.get(0);
                        break;
                    }
                    case 35395: {
                        IntBuffer uniformCount = IntBuffer.allocate(1);
                        GLES30.glGetActiveUniformBlockiv((int)program, (int)uniformBlockIndex, (int)35394, (IntBuffer)uniformCount);
                        int[] indices = new int[uniformCount.get(0)];
                        GLES30.glGetActiveUniformBlockiv((int)program, (int)uniformBlockIndex, (int)pname, (IntBuffer)IntBuffer.wrap(indices));
                        value[0] = indices;
                        break;
                    }
                    case 35396: 
                    case 35398: {
                        IntBuffer boolValue = IntBuffer.allocate(1);
                        GLES30.glGetActiveUniformBlockiv((int)program, (int)uniformBlockIndex, (int)pname, (IntBuffer)boolValue);
                        value[0] = boolValue.get(0) == 1;
                        break;
                    }
                    default: {
                        value[0] = null;
                    }
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public Object getActiveUniforms(final int program, final int[] uniformIndices, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final Object[] value = new Object[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                ReturnType returnType;
                switch (pname) {
                    case 35383: {
                        returnType = ReturnType.EnumType;
                        break;
                    }
                    case 35384: {
                        returnType = ReturnType.UnsignedIntType;
                        break;
                    }
                    case 35386: 
                    case 35387: 
                    case 35388: 
                    case 35389: {
                        returnType = ReturnType.IntType;
                        break;
                    }
                    case 35390: {
                        returnType = ReturnType.BoolType;
                        break;
                    }
                    default: {
                        value[0] = null;
                        lock.countDown();
                        return;
                    }
                }
                IntBuffer activeUniforms = IntBuffer.allocate(1);
                GLES30.glGetProgramiv((int)program, (int)35718, (IntBuffer)activeUniforms);
                IntBuffer activeUniformsUnsigned = activeUniforms;
                int size = uniformIndices.length;
                for (int i = 0; i < size; ++i) {
                    if (i < activeUniformsUnsigned.get(0)) continue;
                    value[0] = null;
                    lock.countDown();
                    return;
                }
                int[] indices = uniformIndices;
                int[] result = new int[size];
                GLES30.glGetActiveUniformsiv((int)program, (int)uniformIndices.length, (IntBuffer)IntBuffer.wrap(indices), (int)pname, (IntBuffer)IntBuffer.wrap(result));
                switch (returnType) {
                    case IntType: 
                    case EnumType: 
                    case UnsignedIntType: {
                        value[0] = result;
                        break;
                    }
                    case BoolType: {
                        value[0] = WebGL2RenderingContext.this.fromGLint(result);
                        break;
                    }
                    default: {
                        value[0] = null;
                    }
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    boolean[] fromGLint(int[] value) {
        boolean[] array = new boolean[value.length];
        for (int i = 0; i < value.length; ++i) {
            array[i] = value[i] == 1;
        }
        return array;
    }

    public void getBufferSubData(final int target, int srcByteOffset, final byte[] dstData, final int dstOffset, final int length) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                if (length == 0) {
                    // empty if block
                }
                int size = dstData.length * 1;
                int typeSize = 1;
                int byteLength = 0;
                if (length > 0) {
                    byteLength = length * typeSize;
                }
                int byteOffset = 0;
                if (dstOffset > 0) {
                    byteOffset = dstOffset * typeSize;
                }
                int total = byteOffset;
                if ((total += byteLength) > size) {
                    return;
                }
                if (byteLength == 0) {
                    byteLength = size - byteOffset;
                }
                GLES30.glBufferSubData((int)target, (int)byteOffset, (int)byteLength, (Buffer)ByteBuffer.wrap(dstData));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getFragDataLocation(final int program, final String name) {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] value = new int[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES30.glGetFragDataLocation((int)program, (String)name);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public Object getIndexedParameter(final int target, final int index) {
        final CountDownLatch lock = new CountDownLatch(1);
        final Object[] val = new Object[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IndexedParameter binding = new IndexedParameter();
                switch (target) {
                    case 35368: 
                    case 35983: {
                        IntBuffer newTarget = IntBuffer.allocate(1);
                        GLES30.glGetIntegerv((int)target, (IntBuffer)newTarget);
                        if (newTarget.get(0) == 0) {
                            val[0] = null;
                            break;
                        }
                        IntBuffer buffer = IntBuffer.allocate(1);
                        GLES30.glGetIntegeri_v((int)newTarget.get(0), (int)index, (IntBuffer)buffer);
                        binding.bufferValue = buffer.get(0);
                        binding.isBuffer = true;
                        val[0] = binding;
                        break;
                    }
                    case 35369: 
                    case 35370: 
                    case 35972: 
                    case 35973: {
                        LongBuffer value = LongBuffer.allocate(1);
                        GLES30.glGetInteger64i_v((int)target, (int)index, (LongBuffer)value);
                        binding.isBuffer = false;
                        binding.value = value.get(0);
                        val[0] = binding;
                        break;
                    }
                    default: {
                        val[0] = null;
                    }
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return val[0];
    }

    public Object getInternalformatParameter(final int target, final int internalformat, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final Object[] value = new Object[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                switch (internalformat) {
                    case 6407: 
                    case 6408: 
                    case 33329: 
                    case 33330: 
                    case 33331: 
                    case 33332: 
                    case 33333: 
                    case 33334: 
                    case 33335: 
                    case 33336: 
                    case 33337: 
                    case 33338: 
                    case 33339: 
                    case 33340: 
                    case 36208: 
                    case 36214: 
                    case 36220: 
                    case 36226: 
                    case 36232: 
                    case 36238: 
                    case 36975: {
                        value[0] = new int[0];
                        lock.countDown();
                        return;
                    }
                    case 32854: 
                    case 32855: 
                    case 32856: 
                    case 32857: 
                    case 33189: 
                    case 33190: 
                    case 33321: 
                    case 33323: 
                    case 35056: 
                    case 35907: 
                    case 36012: 
                    case 36013: 
                    case 36168: 
                    case 36194: {
                        break;
                    }
                    case 33325: 
                    case 33326: 
                    case 33327: 
                    case 33328: 
                    case 34836: 
                    case 35898: {
                        break;
                    }
                    default: {
                        value[0] = null;
                        lock.countDown();
                        return;
                    }
                }
                if (pname == 32937) {
                    IntBuffer length = IntBuffer.allocate(1);
                    GLES30.glGetInternalformativ((int)target, (int)internalformat, (int)37760, (int)1, (IntBuffer)length);
                    if (length.get(0) <= 0) {
                        value[0] = new int[0];
                        lock.countDown();
                        return;
                    }
                    int[] values = new int[length.get(0)];
                    GLES30.glGetInternalformativ((int)target, (int)internalformat, (int)pname, (int)length.get(0), (IntBuffer)IntBuffer.wrap(values));
                    value[0] = values;
                } else {
                    value[0] = null;
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public Object getQuery(final int target, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final Object[] value = new Object[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                if (pname == 34917) {
                    IntBuffer params = IntBuffer.allocate(1);
                    GLES30.glGetQueryiv((int)target, (int)pname, (IntBuffer)params);
                    value[0] = params.get(0);
                } else {
                    value[0] = null;
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public Object getQueryParameter(final int query, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final Object[] value = new Object[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer params = IntBuffer.allocate(1);
                GLES30.glGetQueryObjectuiv((int)query, (int)pname, (IntBuffer)params);
                switch (pname) {
                    case 34918: {
                        value[0] = params.get(0) == 1;
                        break;
                    }
                    case 34919: {
                        value[0] = params;
                        break;
                    }
                    default: {
                        value[0] = null;
                    }
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public Object getSamplerParameter(final int sampler, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final Object[] value = new Object[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                switch (pname) {
                    case 33082: 
                    case 33083: {
                        FloatBuffer floatValue = FloatBuffer.allocate(1);
                        GLES30.glGetSamplerParameterfv((int)sampler, (int)pname, (FloatBuffer)floatValue);
                        value[0] = Float.valueOf(floatValue.get(0));
                        break;
                    }
                    case 10240: 
                    case 10241: 
                    case 10242: 
                    case 10243: 
                    case 32882: 
                    case 34892: 
                    case 34893: {
                        IntBuffer intValue = IntBuffer.allocate(1);
                        GLES30.glGetSamplerParameteriv((int)sampler, (int)pname, (IntBuffer)intValue);
                        value[0] = intValue.get(0);
                        break;
                    }
                    default: {
                        value[0] = null;
                    }
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public Object getSyncParameter(final int sync, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final Object[] value = new Object[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                switch (pname) {
                    case 37138: 
                    case 37139: 
                    case 37140: 
                    case 37141: {
                        IntBuffer values = IntBuffer.allocate(1);
                        IntBuffer length = IntBuffer.allocate(1);
                        GLES30.glGetSynciv((long)sync, (int)pname, (int)1, (IntBuffer)length, (IntBuffer)values);
                        value[0] = values.get(0);
                        break;
                    }
                    default: {
                        value[0] = null;
                    }
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public Object getTransformFeedbackVarying(final int program, final int index) {
        final CountDownLatch lock = new CountDownLatch(1);
        final WebGLActiveInfo[] info = new WebGLActiveInfo[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer maxIndex = IntBuffer.allocate(1);
                GLES30.glGetProgramiv((int)program, (int)35971, (IntBuffer)maxIndex);
                if (index >= maxIndex.get(0)) {
                    info[0] = null;
                    return;
                }
                int[] maxNameLength = new int[1];
                GLES30.glGetProgramiv((int)program, (int)35958, (int[])maxNameLength, (int)0);
                if (maxNameLength[0] <= 0) {
                    info[0] = null;
                    return;
                }
                byte[] name = new byte[maxNameLength[0]];
                int[] length = new int[1];
                int[] size = new int[1];
                int[] type = new int[1];
                GLES30.glGetTransformFeedbackVarying((int)program, (int)index, (int)maxNameLength[0], (int[])length, (int)0, (int[])size, (int)0, (int[])type, (int)0, (byte[])name, (int)0);
                if (length[0] == 0 || size[0] == 0 || type[0] == 0) {
                    info[0] = null;
                    return;
                }
                name = Arrays.copyOfRange(name, 0, length[0]);
                String nameValue = new String(name);
                info[0] = new WebGLActiveInfo(nameValue, size[0], type[0]);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return info[0];
    }

    public int getUniformBlockIndex(final int program, final String uniformBlockName) {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] value = new int[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES30.glGetUniformBlockIndex((int)program, (String)uniformBlockName);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public int[] getUniformIndices(final int program, final String[] uniformNames) {
        CountDownLatch lock = new CountDownLatch(1);
        final int[][] value = new int[1][];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int[] indices = new int[uniformNames.length];
                GLES30.glGetUniformIndices((int)program, (String[])uniformNames, (IntBuffer)IntBuffer.wrap(indices));
                value[0] = indices;
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public void invalidateFramebuffer(final int target, final int[] attachments) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glInvalidateFramebuffer((int)target, (int)attachments.length, (IntBuffer)IntBuffer.wrap(attachments));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void invalidateSubFramebuffer(final int target, final int[] attachments, final int x, final int y, final int width, final int height) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glInvalidateSubFramebuffer((int)target, (int)attachments.length, (IntBuffer)IntBuffer.wrap(attachments), (int)x, (int)y, (int)width, (int)height);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isQuery(final int query) {
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES30.glIsQuery((int)query);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public boolean isSampler(final int sampler) {
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES30.glIsSampler((int)sampler);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public boolean isSync(final int sync) {
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES30.glIsSync((long)sync);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public boolean isTransformFeedback(final int transformFeedback) {
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES30.glIsTransformFeedback((int)transformFeedback);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public boolean isVertexArray(final int vertexArray) {
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES30.glIsVertexArray((int)vertexArray);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public void pauseTransformFeedback() {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glPauseTransformFeedback();
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void readBuffer(final int src) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glReadBuffer((int)src);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void renderbufferStorageMultisample(final int target, final int samples, final int internalFormat, final int width, final int height) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glRenderbufferStorageMultisample((int)target, (int)samples, (int)internalFormat, (int)width, (int)height);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void resumeTransformFeedback() {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glResumeTransformFeedback();
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void samplerParameteri(final int sampler, final int pname, final int param) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glSamplerParameteri((int)sampler, (int)pname, (int)param);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void samplerParameterf(final int sampler, final int pname, final float param) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glSamplerParameterf((int)sampler, (int)pname, (float)param);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texImage3D(final int target, final int level, final int internalformat, final int width, final int height, final int depth, final int border, final int format, final int type, final int offset) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glTexImage3D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, (int)format, (int)type, (int)offset);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texImage3D(final int target, final int level, final int internalformat, final int width, final int height, final int depth, final int border, final int format, final int type, final byte[] source) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                if (WebGL2RenderingContext.this.flipYWebGL) {
                    WebGL2RenderingContext.this.nativeFlipInPlace3D(source, WebGL2RenderingContext.this.bytesPerPixel(type, format) * width, height, depth);
                }
                ByteBuffer pixels = ByteBuffer.wrap(source);
                GLES30.glTexImage3D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, (int)format, (int)type, (Buffer)pixels);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texImage3D(final int target, final int level, final int internalformat, final int width, final int height, final int depth, final int border, final int format, final int type, final Bitmap source) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                ByteBuffer buffer = WebGL2RenderingContext.this.bufferFromBitmap(source, WebGL2RenderingContext.this.bytesPerPixel(type, format) * source.getWidth(), WebGL2RenderingContext.this.flipYWebGL);
                GLES30.glTexImage3D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, (int)format, (int)type, (Buffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texImage3D(final int target, final int level, final int internalformat, int width, int height, final int depth, int border, final int format, final int type, final ImageAsset asset) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                WebGL2RenderingContext.this.nativeTexImage3DAsset(target, level, internalformat, asset.getWidth(), asset.getHeight(), depth, 0, format, type, asset.nativeImageAsset, WebGL2RenderingContext.this.flipYWebGL);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texStorage2D(final int target, final int levels, final int internalformat, final int width, final int height) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glTexStorage2D((int)target, (int)levels, (int)internalformat, (int)width, (int)height);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texStorage3D(final int target, final int levels, final int internalformat, final int width, final int height, final int depth) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glTexStorage3D((int)target, (int)levels, (int)internalformat, (int)width, (int)height, (int)depth);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texSubImage3D(final int target, final int level, final int xoffset, final int yoffset, final int zoffset, final int width, final int height, final int depth, final int format, final int type, final int offset) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (int)offset);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texSubImage3D(final int target, final int level, final int xoffset, final int yoffset, final int zoffset, final int width, final int height, final int depth, final int format, final int type, final Bitmap srcData) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                ByteBuffer storage = WebGL2RenderingContext.this.bufferFromBitmap(srcData, WebGL2RenderingContext.this.bytesPerPixel(type, format) * srcData.getWidth(), WebGL2RenderingContext.this.flipYWebGL);
                GLES30.glTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (Buffer)storage);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texSubImage3D(final int target, final int level, final int xoffset, final int yoffset, final int zoffset, final int width, final int height, final int depth, final int format, final int type, final ImageAsset asset) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                WebGL2RenderingContext.this.nativeTexSubImage3DAsset(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, asset.nativeImageAsset, WebGL2RenderingContext.this.flipYWebGL);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texSubImage3D(final int target, final int level, final int xoffset, final int yoffset, final int zoffset, final int width, final int height, final int depth, final int format, final int type, final byte[] srcData) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                WebGL2RenderingContext.this.texSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, srcData, 0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texSubImage3D(final int target, final int level, final int xoffset, final int yoffset, final int zoffset, final int width, final int height, final int depth, final int format, final int type, final byte[] srcData, final int srcOffset) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                if (WebGL2RenderingContext.this.flipYWebGL) {
                    WebGL2RenderingContext.this.nativeFlipInPlace3D(srcData, WebGL2RenderingContext.this.bytesPerPixel(type, format) * width, height, depth);
                }
                ByteBuffer pixels = ByteBuffer.wrap(srcData);
                pixels.position(srcOffset);
                GLES30.glTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (Buffer)pixels);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void transformFeedbackVaryings(final int program, final String[] varyings, final int bufferMode) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glTransformFeedbackVaryings((int)program, (String[])varyings, (int)bufferMode);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform1ui(final int location, final int v0) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glUniform1ui((int)location, (int)v0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform2ui(final int location, final int v0, final int v1) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glUniform2ui((int)location, (int)v0, (int)v1);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform3ui(final int location, final int v0, final int v1, final int v2) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glUniform3ui((int)location, (int)v0, (int)v1, (int)v2);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform4ui(final int location, final int v0, final int v1, final int v2, final int v3) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glUniform4ui((int)location, (int)v0, (int)v1, (int)v2, (int)v3);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform1uiv(final int location, final int[] data) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glUniform1uiv((int)location, (int)data.length, (IntBuffer)IntBuffer.wrap(data));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform2uiv(final int location, final int[] data) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glUniform2uiv((int)location, (int)data.length, (IntBuffer)IntBuffer.wrap(data));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform3uiv(final int location, final int[] data) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glUniform3uiv((int)location, (int)data.length, (IntBuffer)IntBuffer.wrap(data));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform4uiv(final int location, final int[] data) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glUniform4uiv((int)location, (int)data.length, (IntBuffer)IntBuffer.wrap(data));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniformBlockBinding(final int program, final int uniformBlockIndex, final int uniformBlockBinding) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glUniformBlockBinding((int)program, (int)uniformBlockIndex, (int)uniformBlockBinding);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniformMatrix3x2fv(final int location, final boolean transpose, final float[] data) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glUniformMatrix3x2fv((int)location, (int)data.length, (boolean)transpose, (FloatBuffer)FloatBuffer.wrap(data));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniformMatrix4x2fv(final int location, final boolean transpose, final float[] data) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glUniformMatrix4x2fv((int)location, (int)data.length, (boolean)transpose, (FloatBuffer)FloatBuffer.wrap(data));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniformMatrix2x3fv(final int location, final boolean transpose, final float[] data) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glUniformMatrix2x3fv((int)location, (int)data.length, (boolean)transpose, (FloatBuffer)FloatBuffer.wrap(data));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniformMatrix4x3fv(final int location, final boolean transpose, final float[] data) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glUniformMatrix4x3fv((int)location, (int)data.length, (boolean)transpose, (FloatBuffer)FloatBuffer.wrap(data));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniformMatrix2x4fv(final int location, final boolean transpose, final float[] data) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glUniformMatrix2x4fv((int)location, (int)data.length, (boolean)transpose, (FloatBuffer)FloatBuffer.wrap(data));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniformMatrix3x4fv(final int location, final boolean transpose, final float[] data) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glUniformMatrix3x4fv((int)location, (int)data.length, (boolean)transpose, (FloatBuffer)FloatBuffer.wrap(data));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void vertexAttribDivisor(final int index, final int divisor) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glVertexAttribDivisor((int)index, (int)divisor);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void vertexAttribI4i(final int index, final int v0, final int v1, final int v2, final int v3) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glVertexAttribI4i((int)index, (int)v0, (int)v1, (int)v2, (int)v3);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void vertexAttribI4ui(final int index, final int v0, final int v1, final int v2, final int v3) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glVertexAttribI4ui((int)index, (int)v0, (int)v1, (int)v2, (int)v3);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void vertexAttribI4iv(final int index, final int[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glVertexAttribI4iv((int)index, (IntBuffer)IntBuffer.wrap(value));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void vertexAttribI4uiv(final int index, final int[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES30.glVertexAttribI4uiv((int)index, (IntBuffer)IntBuffer.wrap(value));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static enum ReturnType {
        EnumType,
        UnsignedIntType,
        IntType,
        BoolType;

    }
}

