/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.TextureView;
import com.github.triniwiz.canvas.CanvasView;
import com.github.triniwiz.canvas.GLContext;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class GLView
extends TextureView
implements TextureView.SurfaceTextureListener {
    private boolean isCreated = false;
    private boolean isCreatedWithZeroSized = false;
    private GLContext mGLContext;
    private CanvasView.Listener mListener;
    int drawingBufferWidth = 0;
    int drawingBufferHeight = 0;
    boolean starting = false;
    CountDownLatch startupLock;

    public GLView(Context context) {
        super(context);
        this.init();
    }

    void resize(int width, int height) {
        this.drawingBufferWidth = width;
        this.drawingBufferHeight = height;
        this.mGLContext.resize(width, height);
    }

    public GLView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    void init() {
        this.setOpaque(false);
        this.setSurfaceTextureListener(this);
        this.mGLContext = new GLContext();
        this.mGLContext.glView = new WeakReference<GLView>(this);
    }

    void setupContext() {
        if (this.mGLContext.mGLThread != null && this.mGLContext.mGLThread.isStarted) {
            return;
        }
        if (this.mGLContext.mGLThread == null) {
            this.mGLContext.init(null);
        }
        if (!this.starting) {
            this.starting = true;
            this.startupLock = new CountDownLatch(1);
            this.mGLContext.startGLThread();
            try {
                this.startupLock.await(1500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.starting = false;
                this.startupLock = null;
            }
        }
    }

    public void flush() {
        this.mGLContext.flush();
    }

    public GLContext getGLContext() {
        return this.mGLContext;
    }

    public void queueEvent(Runnable runnable) {
        this.mGLContext.queueEvent(runnable);
    }

    public void setListener(CanvasView.Listener listener) {
        this.mListener = listener;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.drawingBufferHeight = height;
        this.drawingBufferWidth = width;
        if (!this.isCreated) {
            if (width == 0 || height == 0) {
                this.isCreatedWithZeroSized = true;
            }
            if (!this.isCreatedWithZeroSized) {
                this.mGLContext.init(surface);
                if (this.mListener != null) {
                    this.mListener.contextReady();
                }
            }
            this.isCreated = true;
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        this.drawingBufferHeight = height;
        this.drawingBufferWidth = width;
        if (!this.isCreatedWithZeroSized) {
            // empty if block
        }
        if (this.isCreatedWithZeroSized && (width != 0 || height != 0)) {
            this.mGLContext.init(surface);
            this.isCreatedWithZeroSized = false;
            if (this.mListener != null) {
                this.mListener.contextReady();
            }
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.isCreated = false;
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }
}

