/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.graphics.Bitmap;
import android.util.Log;
import android.view.ViewGroup;
import com.github.triniwiz.canvas.CanvasCompositeOperationType;
import com.github.triniwiz.canvas.CanvasDOMMatrix;
import com.github.triniwiz.canvas.CanvasPath2D;
import com.github.triniwiz.canvas.CanvasRenderingContext;
import com.github.triniwiz.canvas.CanvasTextAlignment;
import com.github.triniwiz.canvas.CanvasTextMetrics;
import com.github.triniwiz.canvas.CanvasView;
import com.github.triniwiz.canvas.Color;
import com.github.triniwiz.canvas.Gradient;
import com.github.triniwiz.canvas.ICanvasColorStyle;
import com.github.triniwiz.canvas.ImageAsset;
import com.github.triniwiz.canvas.ImageData;
import com.github.triniwiz.canvas.LinearGradient;
import com.github.triniwiz.canvas.Pattern;
import com.github.triniwiz.canvas.RadialGradient;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;

public class CanvasRenderingContext2D
implements CanvasRenderingContext {
    private CanvasView canvasView;
    public static boolean isDebug = true;
    final Object lock = new Object();
    long state = 0L;
    long currentPath = 0L;
    private boolean imageSmoothingEnabled = false;
    private ImageSmoothingQuality imageSmoothingQuality = ImageSmoothingQuality.Low;
    private float lineWidth = 1.0f;
    private Object fillStyle = -16777216;
    private Object strokeStyle = -16777216;
    private CanvasCompositeOperationType globalCompositeOperation = CanvasCompositeOperationType.SourceOver;
    private CanvasTextAlignment textAlign = CanvasTextAlignment.Start;
    private float globalAlpha = 1.0f;
    private String font = "10px sans-serif";
    private LineCap lineCap = LineCap.Butt;
    private LineJoin lineJoin = LineJoin.Miter;
    private float lineDashOffset = 0.0f;
    private float miterLimit = 10.0f;
    private String direction = "ltr";
    private float shadowBlur = 0.0f;
    private int shadowColor = 0;
    private float shadowOffsetX = 0.0f;
    private float shadowOffsetY = 0.0f;
    private float[] lineDash = new float[0];
    public boolean block = false;
    static final String TAG = "CanvasRenderingContext";

    private static native long nativeRect(long var0, float var2, float var3, float var4, float var5);

    private static native long nativeStroke(long var0);

    private static native long nativeStrokePath(long var0, long var2);

    private static native long nativeFill(long var0);

    private static native long nativeFillRule(long var0, String var2);

    private static native long nativeFillPathRule(long var0, long var2, String var4);

    private static native long nativeFillRect(long var0, float var2, float var3, float var4, float var5);

    private static native long nativeStrokeRect(long var0, float var2, float var3, float var4, float var5);

    private static native long nativeFillText(long var0, String var2, float var3, float var4, float var5);

    private static native long nativeStrokeText(long var0, String var2, float var3, float var4, float var5);

    private static native long nativeBeginPath(long var0);

    private static native long nativeMoveTo(long var0, float var2, float var3);

    private static native long nativeLineTo(long var0, float var2, float var3);

    private static native long nativeClosePath(long var0);

    private static native long nativeArc(long var0, float var2, float var3, float var4, float var5, float var6, boolean var7);

    private static native long nativeArcTo(long var0, float var2, float var3, float var4, float var5, float var6);

    private static native long nativeBezierCurveTo(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    private static native long nativeEllipse(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, boolean var9);

    private static native long nativeClip(long var0);

    private static native long nativeClipRule(long var0, String var2);

    private static native long nativeClipPathRule(long var0, long var2, String var4);

    private static native long nativeSetLineWidth(long var0, float var2);

    private static native long nativeSetGlobalCompositeOperation(long var0, String var2);

    private static native long nativeSetGlobalAlpha(long var0, int var2);

    private static native long nativeSetTextAlignment(long var0, String var2);

    private static native long nativeSave(long var0);

    private static native long nativeRestore(long var0);

    private static native long nativeSetTransform(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    private static native long nativeTransform(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    private static native long nativeScale(long var0, float var2, float var3);

    private static native long nativeRotate(long var0, float var2);

    private static native long nativeTranslate(long var0, float var2, float var3);

    private static native long nativeQuadraticCurveTo(long var0, float var2, float var3, float var4, float var5);

    private static native long nativeDrawImageCanvas(long var0, byte[] var2, int var3, int var4, float var5, float var6);

    private static native long nativeDrawImage(long var0, Bitmap var2, float var3, float var4);

    private static native long nativeDrawImageRaw(long var0, byte[] var2, int var3, int var4, float var5, float var6);

    private static native long nativeDrawImageCanvasDw(long var0, byte[] var2, int var3, int var4, float var5, float var6, float var7, float var8);

    private static native long nativeDrawImageDw(long var0, Bitmap var2, float var3, float var4, float var5, float var6);

    private static native long nativeDrawImageDwRaw(long var0, byte[] var2, int var3, int var4, float var5, float var6, float var7, float var8);

    private static native long nativeDrawImageCanvasSw(long var0, byte[] var2, int var3, int var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12);

    private static native long nativeDrawImageSw(long var0, Bitmap var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10);

    private static native long nativeDrawImageSwRaw(long var0, byte[] var2, int var3, int var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12);

    private static native long nativeClearRect(long var0, float var2, float var3, float var4, float var5);

    private static native long nativeSetFillColorRgba(long var0, int var2, int var3, int var4, int var5);

    private static native long nativeSetFillColor(long var0, int var2);

    private static native long nativeSetStrokeColorRgba(long var0, int var2, int var3, int var4, int var5);

    private static native long nativeSetStrokeColor(long var0, int var2);

    private static native long nativeSetShadowBlur(long var0, float var2);

    private static native long nativeSetShadowColor(long var0, int var2);

    private static native long nativeSetShadowOffsetX(long var0, float var2);

    private static native long nativeSetShadowOffsetY(long var0, float var2);

    private static native long nativeSetFont(long var0, String var2);

    private static native ByteBuffer nativeCreateImageData(int var0, int var1);

    private static native long nativePutImageData(long var0, int var2, int var3, ByteBuffer var4, float var5, float var6, float var7, float var8, int var9, int var10);

    private static native long nativeSetImageSmoothingEnabled(long var0, boolean var2);

    private static native long nativeSetImageSmoothingQuality(long var0, String var2);

    private static native long nativeSetLineCap(long var0, String var2);

    private static native long nativeSetLineJoin(long var0, String var2);

    private static native long nativeSetFillGradientRadial(long var0, float var2, float var3, float var4, float var5, float var6, float var7, int[] var8, float[] var9);

    private static native long nativeSetFillGradientLinear(long var0, float var2, float var3, float var4, float var5, int[] var6, float[] var7);

    private static native long nativeSetStrokeGradientRadial(long var0, float var2, float var3, float var4, float var5, float var6, float var7, int[] var8, float[] var9);

    private static native long nativeSetStrokeGradientLinear(long var0, float var2, float var3, float var4, float var5, int[] var6, float[] var7);

    private static native long nativeSetLineDashOffset(long var0, float var2);

    private static native long nativeSetLineDash(long var0, float[] var2);

    private static native long nativeResetTransform(long var0);

    private static native long nativeSetMiterLimit(long var0, float var2);

    private static native CanvasTextMetrics nativeMeasureText(long var0, String var2);

    private static native long nativeSetCurrentTransform(long var0, long var2);

    private static native long nativeGetCurrentTransform(long var0);

    private static native boolean nativeIsPointInPath(long var0, float var2, float var3);

    private static native boolean nativeIsPointInPathWithRule(long var0, float var2, float var3, String var4);

    private static native boolean nativeIsPointInPathWithPathRule(long var0, long var2, float var4, float var5, String var6);

    private static native boolean nativeIsPointInStroke(long var0, float var2, float var3);

    private static native boolean nativeIsPointInStrokeWithPath(long var0, long var2, float var4, float var5);

    private static native ByteBuffer nativeGetImageData(long var0, float var2, float var3, int var4, int var5);

    private static native long nativeSetFillPattern(long var0, long var2);

    private static native long nativeSetStrokePattern(long var0, long var2);

    private static native String nativeGetDirection(long var0);

    private static native long nativeSetDirection(long var0, String var2);

    CanvasRenderingContext2D(CanvasView view) {
        this.canvasView = view;
    }

    public void setDirection(String direction) {
        if (direction.equals("ltr") || direction.equals("rtl")) {
            this.canvasView.canvas = CanvasRenderingContext2D.nativeSetDirection(this.canvasView.canvas, direction);
            this.direction = direction;
        }
    }

    private static void printLog(String msg) {
        if (isDebug) {
            Log.d((String)TAG, (String)msg);
        }
    }

    public String getDirection() {
        return this.direction;
    }

    public Object getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(final int fillStyle) {
        CanvasRenderingContext2D.printLog("setFillStyle int");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetFillColor(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, fillStyle);
            }
        });
        this.fillStyle = fillStyle;
    }

    public void setFillStyle(final Object fillStyle) {
        CanvasRenderingContext2D.printLog("setFillStyle obj");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (fillStyle instanceof ICanvasColorStyle) {
                    switch (((ICanvasColorStyle)fillStyle).getStyleType()) {
                        case Color: {
                            Color color = (Color)fillStyle;
                            ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetFillColorRgba(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, android.graphics.Color.red((int)color.color), android.graphics.Color.green((int)color.color), android.graphics.Color.blue((int)color.color), android.graphics.Color.alpha((int)color.color));
                            break;
                        }
                        case Pattern: {
                            Pattern pattern = (Pattern)fillStyle;
                            ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetFillPattern(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, pattern.nativePattern);
                            break;
                        }
                        case Gradient: {
                            Gradient gradient = (Gradient)fillStyle;
                            if (gradient instanceof LinearGradient) {
                                LinearGradient g = (LinearGradient)gradient;
                                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetFillGradientLinear(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, g.x0, g.y0, g.x1, g.y1, gradient.getColors(), gradient.getPositions());
                                break;
                            }
                            if (!(gradient instanceof RadialGradient)) break;
                            RadialGradient g = (RadialGradient)gradient;
                            ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetFillGradientRadial(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, g.x0, g.y0, g.r0, g.x1, g.y1, g.r1, gradient.getColors(), gradient.getPositions());
                        }
                    }
                } else if (fillStyle instanceof String) {
                    Color color = new Color((String)fillStyle);
                    ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetFillColorRgba(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, android.graphics.Color.red((int)color.color), android.graphics.Color.green((int)color.color), android.graphics.Color.blue((int)color.color), android.graphics.Color.alpha((int)color.color));
                } else if (fillStyle != null) {
                    ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetFillColor(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, (Integer)fillStyle);
                }
            }
        });
        if (fillStyle != null) {
            this.fillStyle = fillStyle;
        }
    }

    public Object getStrokeStyle() {
        return this.strokeStyle;
    }

    public void setStrokeStyle(final int strokeStyle) {
        CanvasRenderingContext2D.printLog("setStrokeStyle int");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetStrokeColor(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, strokeStyle);
            }
        });
        this.strokeStyle = strokeStyle;
    }

    public void setStrokeStyle(final Object strokeStyle) {
        CanvasRenderingContext2D.printLog("setStrokeStyle obj");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (strokeStyle instanceof ICanvasColorStyle) {
                    switch (((ICanvasColorStyle)strokeStyle).getStyleType()) {
                        case Color: {
                            Color color = (Color)strokeStyle;
                            ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetStrokeColorRgba(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, android.graphics.Color.red((int)color.color), android.graphics.Color.green((int)color.color), android.graphics.Color.blue((int)color.color), android.graphics.Color.alpha((int)color.color));
                            break;
                        }
                        case Pattern: {
                            Pattern pattern = (Pattern)strokeStyle;
                            ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetStrokePattern(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, pattern.nativePattern);
                            break;
                        }
                        case Gradient: {
                            Gradient gradient = (Gradient)strokeStyle;
                            if (gradient instanceof LinearGradient) {
                                LinearGradient g = (LinearGradient)gradient;
                                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetStrokeGradientLinear(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, g.x0, g.y0, g.x1, g.y1, gradient.getColors(), gradient.getPositions());
                                break;
                            }
                            if (!(gradient instanceof RadialGradient)) break;
                            RadialGradient g = (RadialGradient)gradient;
                            ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetStrokeGradientRadial(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, g.x0, g.y0, g.r0, g.x1, g.y1, g.r1, gradient.getColors(), gradient.getPositions());
                        }
                    }
                } else if (strokeStyle instanceof String) {
                    Color color = new Color((String)strokeStyle);
                    ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetStrokeColorRgba(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, android.graphics.Color.red((int)color.color), android.graphics.Color.green((int)color.color), android.graphics.Color.blue((int)color.color), android.graphics.Color.alpha((int)color.color));
                } else if (strokeStyle != null) {
                    ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetStrokeColor(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, (Integer)strokeStyle);
                }
            }
        });
        if (strokeStyle != null) {
            this.strokeStyle = strokeStyle;
        }
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(final float lineWidth) {
        CanvasRenderingContext2D.printLog("setLineWidth");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetLineWidth(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, lineWidth);
            }
        });
        this.lineWidth = lineWidth;
    }

    public void setLineCap(final LineCap lineCap) {
        CanvasRenderingContext2D.printLog("setLineCap");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetLineCap(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, lineCap.toString());
            }
        });
        this.lineCap = lineCap;
    }

    public LineCap getLineCap() {
        return this.lineCap;
    }

    public void setLineJoin(final LineJoin lineJoin) {
        CanvasRenderingContext2D.printLog("setLineJoin");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetLineJoin(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, lineJoin.toString());
            }
        });
        this.lineJoin = lineJoin;
    }

    public LineJoin getLineJoin() {
        return this.lineJoin;
    }

    public void setMiterLimit(final float limit) {
        CanvasRenderingContext2D.printLog("setMiterLimit");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetMiterLimit(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, limit);
            }
        });
        this.miterLimit = limit;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public void setLineDashOffset(final float offset) {
        CanvasRenderingContext2D.printLog("setLineDashOffset");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetLineDashOffset(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, offset);
            }
        });
        this.lineDashOffset = offset;
    }

    public float getLineDashOffset() {
        return this.lineDashOffset;
    }

    public float[] getLineDash() {
        return this.lineDash;
    }

    public void setLineDash(final float[] dash) {
        CanvasRenderingContext2D.printLog("setLineDash");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetLineDash(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, dash);
            }
        });
        this.lineDash = dash;
    }

    private void updateCanvas() {
        this.canvasView.pendingInvalidate = true;
    }

    public void clearRect(final float x, final float y, final float width, final float height) {
        CanvasRenderingContext2D.printLog("clearRect");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeClearRect(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, x, y, width, height);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void fillRect(final float x, final float y, final float width, final float height) {
        CanvasRenderingContext2D.printLog("fillRect");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeFillRect(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, x, y, width, height);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void strokeRect(final float x, final float y, final float width, final float height) {
        CanvasRenderingContext2D.printLog("strokeRect");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeStrokeRect(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, x, y, width, height);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void fillText(String text, float x, float y) {
        this.fillText(text, x, y, 0.0f);
    }

    public void fillText(final String text, final float x, final float y, final float width) {
        CanvasRenderingContext2D.printLog("fillText");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeFillText(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, text, x, y, width);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void strokeText(String text, float x, float y) {
        this.strokeText(text, x, y, 0.0f);
    }

    public void strokeText(final String text, final float x, final float y, final float width) {
        CanvasRenderingContext2D.printLog("strokeText");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeStrokeText(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, text, x, y, width);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    synchronized long getCanvasPointer() {
        return this.canvasView.canvas;
    }

    synchronized void setCanvasPointer(long canvas) {
        this.canvasView.canvas = canvas;
    }

    public void rect(final float x, final float y, final float width, final float height) {
        CanvasRenderingContext2D.printLog("rect");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeRect(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, x, y, width, height);
            }
        });
    }

    public void fill() {
        CanvasRenderingContext2D.printLog("fill");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeFill(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void fill(final String rule) {
        CanvasRenderingContext2D.printLog("fill: rule");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeFillRule(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, rule);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void fill(final CanvasPath2D path, final String rule) {
        CanvasRenderingContext2D.printLog("fill: path rule");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeFillPathRule(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, path.path, rule);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void fill(final CanvasPath2D path) {
        CanvasRenderingContext2D.printLog("fill: path");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeFillPathRule(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, path.path, "nonzero");
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void stroke() {
        CanvasRenderingContext2D.printLog("stroke");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeStroke(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void stroke(final CanvasPath2D path) {
        CanvasRenderingContext2D.printLog("stroke: path");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeStrokePath(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, path.path);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void beginPath() {
        CanvasRenderingContext2D.printLog("beginPath");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeBeginPath(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas);
            }
        });
    }

    public void moveTo(final float x, final float y) {
        CanvasRenderingContext2D.printLog("moveTo");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeMoveTo(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, x, y);
            }
        });
    }

    public void lineTo(final float x, final float y) {
        CanvasRenderingContext2D.printLog("lineTo");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeLineTo(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, x, y);
            }
        });
    }

    public void closePath() {
        CanvasRenderingContext2D.printLog("closePath");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeClosePath(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas);
            }
        });
    }

    public void arc(float x, float y, float radius, float startAngle, float endAngle) {
        this.arc(x, y, radius, startAngle, endAngle, false);
    }

    public void arc(final float x, final float y, final float radius, final float startAngle, final float endAngle, final boolean anticlockwise) {
        CanvasRenderingContext2D.printLog("arc");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeArc(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, x, y, radius, startAngle, endAngle, anticlockwise);
            }
        });
    }

    public void arcTo(final float x1, final float y1, final float x2, final float y2, final float radius) {
        CanvasRenderingContext2D.printLog("arcTo");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeArcTo(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, x1, y1, x2, y2, radius);
            }
        });
    }

    public void bezierCurveTo(final float cp1x, final float cp1y, final float cp2x, final float cp2y, final float x, final float y) {
        CanvasRenderingContext2D.printLog("bezierCurveTo");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeBezierCurveTo(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, cp1x, cp1y, cp2x, cp2y, x, y);
            }
        });
    }

    public void ellipse(float x, float y, float radiusX, float radiusY, float rotation, float startAngle, float endAngle) {
        this.ellipse(x, y, radiusX, radiusY, rotation, startAngle, endAngle, false);
    }

    public void ellipse(final float x, final float y, final float radiusX, final float radiusY, final float rotation, final float startAngle, final float endAngle, final boolean anticlockwise) {
        CanvasRenderingContext2D.printLog("ellipse");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeEllipse(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, x, y, radiusX, radiusY, rotation, startAngle, endAngle, anticlockwise);
            }
        });
    }

    public void clip() {
        CanvasRenderingContext2D.printLog("clip");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeClip(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas);
            }
        });
    }

    public void clip(final String rule) {
        CanvasRenderingContext2D.printLog("clip: rule");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeClipRule(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, rule);
            }
        });
    }

    public void clip(final CanvasPath2D path) {
        CanvasRenderingContext2D.printLog("clip: path");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeClipPathRule(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, path.path, "nonzero");
            }
        });
    }

    public void clip(final CanvasPath2D path, final String rule) {
        CanvasRenderingContext2D.printLog("clip: path rule");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeClipPathRule(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, path.path, rule);
            }
        });
    }

    public CanvasView getCanvas() {
        return this.canvasView;
    }

    public LinearGradient createLinearGradient(float x0, float y0, float x1, float y1) {
        CanvasRenderingContext2D.printLog("createLinearGradient");
        return new LinearGradient(x0, y0, x1, y1);
    }

    public RadialGradient createRadialGradient(float x0, float y0, float r0, float x1, float y1, float r1) {
        CanvasRenderingContext2D.printLog("createRadialGradient");
        return new RadialGradient(x0, y0, r0, x1, y1, r1);
    }

    public Pattern createPattern(CanvasView src, Pattern.PatternRepetition repetition) {
        CanvasRenderingContext2D.printLog("createPattern: canvas");
        return new Pattern(this.canvasView, src, repetition);
    }

    public Pattern createPattern(Bitmap src, Pattern.PatternRepetition repetition) {
        CanvasRenderingContext2D.printLog("createPattern: bitmap");
        return new Pattern(this.canvasView, src, repetition);
    }

    public Pattern createPattern(ImageAsset src, Pattern.PatternRepetition repetition) {
        CanvasRenderingContext2D.printLog("createPattern: asset");
        return new Pattern(this.canvasView, src, repetition);
    }

    public CanvasCompositeOperationType getGlobalCompositeOperation() {
        return this.globalCompositeOperation;
    }

    public void setGlobalCompositeOperation(final CanvasCompositeOperationType globalCompositeOperation) {
        CanvasRenderingContext2D.printLog("setGlobalCompositeOperation");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetGlobalCompositeOperation(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, globalCompositeOperation.type);
            }
        });
        this.globalCompositeOperation = globalCompositeOperation;
    }

    public float getGlobalAlpha() {
        return this.globalAlpha;
    }

    public void setGlobalAlpha(float alpha) {
        CanvasRenderingContext2D.printLog("setGlobalAlpha");
        if (alpha == 0.0f || alpha > 1.0f) {
            alpha = 1.0f;
        }
        final int globalAlpha = (int)(alpha * 255.0f);
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetGlobalAlpha(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, globalAlpha);
            }
        });
        this.globalAlpha = globalAlpha;
    }

    public CanvasTextAlignment getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(final CanvasTextAlignment textAlign) {
        CanvasRenderingContext2D.printLog("setTextAlign");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetTextAlignment(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, textAlign.toString());
            }
        });
    }

    public void save() {
        CanvasRenderingContext2D.printLog("save");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSave(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void restore() {
        CanvasRenderingContext2D.printLog("restore");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeRestore(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void setTransform(final float a, final float b, final float c, final float d, final float e, final float f) {
        CanvasRenderingContext2D.printLog("setTransform");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetTransform(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, a, b, c, d, e, f);
            }
        });
    }

    public void transform(final float a, final float b, final float c, final float d, final float e, final float f) {
        CanvasRenderingContext2D.printLog("transform");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeTransform(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, a, b, c, d, e, f);
            }
        });
    }

    public void scale(final float x, final float y) {
        CanvasRenderingContext2D.printLog("scale");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeScale(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, x, y);
            }
        });
    }

    public void rotate(final float angle) {
        CanvasRenderingContext2D.printLog("rotate");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeRotate(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, angle);
            }
        });
    }

    public void translate(final float x, final float y) {
        CanvasRenderingContext2D.printLog("translate");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeTranslate(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, x, y);
            }
        });
    }

    public void quadraticCurveTo(final float cpx, final float cpy, final float x, final float y) {
        CanvasRenderingContext2D.printLog("quadraticCurveTo");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeQuadraticCurveTo(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, cpx, cpy, x, y);
            }
        });
    }

    public void drawImage(CanvasView image, final float dx, final float dy) {
        ViewGroup.LayoutParams params;
        CanvasRenderingContext2D.printLog("drawImage: canvas");
        final byte[] ss = image.snapshot();
        int width = image.getWidth();
        int height = image.getHeight();
        if (width == 0 && (params = image.getLayoutParams()) != null) {
            width = params.width;
        }
        if (height == 0 && (params = image.getLayoutParams()) != null) {
            height = params.height;
        }
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        final int finalWidth = width;
        final int finalHeight = height;
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeDrawImageCanvas(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, ss, finalWidth, finalHeight, dx, dy);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void drawImage(final Bitmap image, final float dx, final float dy) {
        CanvasRenderingContext2D.printLog("drawImage: bitmap");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeDrawImage(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, image, dx, dy);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void drawImage(final ImageAsset asset, final float dx, final float dy) {
        CanvasRenderingContext2D.printLog("drawImage: asset");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeDrawImageRaw(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, asset.getBytes(), asset.getWidth(), asset.getHeight(), dx, dy);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void drawImage(CanvasView image, final float dx, final float dy, final float dWidth, final float dHeight) {
        ViewGroup.LayoutParams params;
        CanvasRenderingContext2D.printLog("drawImage: canvas");
        final byte[] ss = image.snapshot();
        int width = image.getWidth();
        int height = image.getHeight();
        if (width == 0 && (params = image.getLayoutParams()) != null) {
            width = params.width;
        }
        if (height == 0 && (params = image.getLayoutParams()) != null) {
            height = params.height;
        }
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        final int finalWidth = width;
        final int finalHeight = height;
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeDrawImageCanvasDw(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, ss, finalWidth, finalHeight, dx, dy, dWidth, dHeight);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void drawImage(final Bitmap image, final float dx, final float dy, final float dWidth, final float dHeight) {
        CanvasRenderingContext2D.printLog("drawImage: bitmap");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeDrawImageDw(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, image, dx, dy, dWidth, dHeight);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void drawImage(final ImageAsset asset, final float dx, final float dy, final float dWidth, final float dHeight) {
        CanvasRenderingContext2D.printLog("drawImage: asset");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeDrawImageDwRaw(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, asset.getBytes(), asset.getWidth(), asset.getHeight(), dx, dy, dWidth, dHeight);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void drawImage(CanvasView image, final float sx, final float sy, final float sWidth, final float sHeight, final float dx, final float dy, final float dWidth, final float dHeight) {
        ViewGroup.LayoutParams params;
        CanvasRenderingContext2D.printLog("drawImage: canvas");
        final byte[] ss = image.snapshot();
        int width = image.getWidth();
        int height = image.getHeight();
        if (image.getWidth() == 0 && (params = image.getLayoutParams()) != null) {
            width = params.width;
        }
        if (image.getHeight() == 0 && (params = image.getLayoutParams()) != null) {
            height = params.height;
        }
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        final int finalWidth = width;
        final int finalHeight = height;
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeDrawImageCanvasSw(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, ss, finalWidth, finalHeight, sx, sy, sWidth, sHeight, dx, dy, dWidth, dHeight);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void drawImage(final Bitmap image, final float sx, final float sy, final float sWidth, final float sHeight, final float dx, final float dy, final float dWidth, final float dHeight) {
        CanvasRenderingContext2D.printLog("drawImage: bitmap");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeDrawImageSw(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, image, sx, sy, sWidth, sHeight, dx, dy, dWidth, dHeight);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void drawImage(final ImageAsset asset, final float sx, final float sy, final float sWidth, final float sHeight, final float dx, final float dy, final float dWidth, final float dHeight) {
        CanvasRenderingContext2D.printLog("drawImage: asset");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeDrawImageSwRaw(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, asset.getBytes(), asset.getWidth(), asset.getHeight(), sx, sy, sWidth, sHeight, dx, dy, dWidth, dHeight);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public void setShadowBlur(final float blur) {
        CanvasRenderingContext2D.printLog("setShadowBlur");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetShadowBlur(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, blur);
            }
        });
        this.shadowBlur = blur;
    }

    public float getShadowBlur() {
        return this.shadowBlur;
    }

    public void setShadowColor(final int color) {
        CanvasRenderingContext2D.printLog("setShadowColor");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetShadowColor(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, color);
            }
        });
        this.shadowColor = color;
    }

    public int getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowOffsetX(final float x) {
        CanvasRenderingContext2D.printLog("setShadowOffsetX");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetShadowOffsetX(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, x);
            }
        });
        this.shadowOffsetX = x;
    }

    public float getShadowOffsetX() {
        return this.shadowOffsetX;
    }

    public void setShadowOffsetY(final float y) {
        CanvasRenderingContext2D.printLog("setShadowOffsetY");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetShadowOffsetY(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, y);
            }
        });
        this.shadowOffsetY = y;
    }

    public float getShadowOffsetY() {
        return this.shadowOffsetY;
    }

    public void setFont(final String font) {
        CanvasRenderingContext2D.printLog("setFont");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetFont(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, font);
            }
        });
    }

    public String getFont() {
        return this.font;
    }

    public CanvasTextMetrics measureText(String text) {
        CanvasRenderingContext2D.printLog("measureText");
        return CanvasRenderingContext2D.nativeMeasureText(this.canvasView.canvas, text);
    }

    public ImageData createImageData(int width, int height) {
        CanvasRenderingContext2D.printLog("createImageData");
        return new ImageData(width, height, CanvasRenderingContext2D.nativeCreateImageData(width, height));
    }

    public ImageData createImageData(ImageData imageData) {
        CanvasRenderingContext2D.printLog("createImageData");
        return new ImageData(imageData.getWidth(), imageData.getHeight(), CanvasRenderingContext2D.nativeCreateImageData(imageData.getWidth(), imageData.getHeight()));
    }

    public void putImageData(ImageData data) {
        this.putImageData(data, 0.0f, 0.0f);
    }

    public void putImageData(ImageData data, float x, float y) {
        this.putImageData(data, x, y, 0.0f, 0.0f, -1, -1);
    }

    public void putImageData(final ImageData data, final float x, final float y, final float dirtyX, final float dirtyY, final int dirtyWidth, final int dirtyHeight) {
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativePutImageData(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, data.getWidth(), data.getHeight(), data.getData(), x, y, dirtyX, dirtyY, dirtyWidth, dirtyHeight);
                CanvasRenderingContext2D.this.updateCanvas();
            }
        });
    }

    public ImageData getImageData(final float sx, final float sy, final int sw, final int sh) {
        CanvasRenderingContext2D.printLog("getImageData");
        final CountDownLatch lock = new CountDownLatch(1);
        final ByteBuffer[] data = new ByteBuffer[1];
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                data[0] = CanvasRenderingContext2D.nativeGetImageData(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, sx, sy, sw, sh);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new ImageData(sw, sh, data[0]);
    }

    public boolean getImageSmoothingEnabled() {
        return this.imageSmoothingEnabled;
    }

    public void setImageSmoothingEnabled(final boolean enabled) {
        CanvasRenderingContext2D.printLog("setImageSmoothingEnabled");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetImageSmoothingEnabled(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, enabled);
            }
        });
        this.imageSmoothingEnabled = enabled;
    }

    public ImageSmoothingQuality getImageSmoothingQuality() {
        return this.imageSmoothingQuality;
    }

    public void setImageSmoothingQuality(final ImageSmoothingQuality quality) {
        CanvasRenderingContext2D.printLog("setImageSmoothingQuality");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetImageSmoothingQuality(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, quality.quality);
            }
        });
    }

    public void resetTransform() {
        CanvasRenderingContext2D.printLog("resetTransform");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeResetTransform(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas);
            }
        });
    }

    public void setCurrentTransform(final CanvasDOMMatrix matrix) {
        CanvasRenderingContext2D.printLog("setCurrentTransform");
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                ((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas = CanvasRenderingContext2D.nativeSetCurrentTransform(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, matrix.matrix);
            }
        });
    }

    public CanvasDOMMatrix getCurrentTransform() {
        CanvasRenderingContext2D.printLog("getCurrentTransform");
        final CountDownLatch lock = new CountDownLatch(1);
        final long[] id = new long[1];
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                id[0] = CanvasRenderingContext2D.nativeGetCurrentTransform(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (id[0] == 0L) {
            return new CanvasDOMMatrix();
        }
        return new CanvasDOMMatrix(id[0]);
    }

    public boolean isPointInPath(final float x, final float y) {
        CanvasRenderingContext2D.printLog("isPointInPath");
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                value[0] = CanvasRenderingContext2D.nativeIsPointInPath(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, x, y);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public boolean isPointInPath(final float x, final float y, final String fillRule) {
        CanvasRenderingContext2D.printLog("isPointInPath");
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                value[0] = CanvasRenderingContext2D.nativeIsPointInPathWithRule(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, x, y, fillRule);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public boolean isPointInPath(final CanvasPath2D path, final float x, final float y, final String fillRule) {
        CanvasRenderingContext2D.printLog("isPointInPath");
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                value[0] = CanvasRenderingContext2D.nativeIsPointInPathWithPathRule(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, path.path, x, y, fillRule);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public boolean isPointInStroke(final float x, final float y) {
        CanvasRenderingContext2D.printLog("isPointInStroke");
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                value[0] = CanvasRenderingContext2D.nativeIsPointInStroke(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, x, y);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public boolean isPointInStroke(final CanvasPath2D path, final float x, final float y) {
        CanvasRenderingContext2D.printLog("isPointInStroke");
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.canvasView.queueEvent(new Runnable(){

            @Override
            public void run() {
                value[0] = CanvasRenderingContext2D.nativeIsPointInStrokeWithPath(((CanvasRenderingContext2D)CanvasRenderingContext2D.this).canvasView.canvas, path.path, x, y);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public static enum ImageSmoothingQuality {
        Low("low"),
        Medium("medium"),
        High("high");

        private String quality;

        private ImageSmoothingQuality(String quality) {
            this.quality = quality;
        }

        public String toString() {
            return this.quality;
        }
    }

    public static enum LineJoin {
        Bevel("bevel"),
        Round("round"),
        Miter("miter");

        private String lineJoin;

        private LineJoin(String lineJoin) {
            this.lineJoin = lineJoin;
        }

        public String toString() {
            return this.lineJoin;
        }
    }

    public static enum LineCap {
        Butt("butt"),
        Round("round"),
        Square("square");

        private String lineCap;

        private LineCap(String lineCap) {
            this.lineCap = lineCap;
        }

        public String toString() {
            return this.lineCap;
        }
    }
}

