/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

public class TextDecoder {
    private long nativeDecoder = 0L;

    private static native long nativeInit(String var0);

    private static native String nativeGetEncoding(long var0);

    private static native String nativeDecode(long var0, byte[] var2);

    private static native String nativeDecodeShort(long var0, short[] var2);

    private static native String nativeDecodeInt(long var0, int[] var2);

    public TextDecoder() {
        this.init("utf-8");
    }

    public TextDecoder(String encoding) {
        this.init(encoding);
    }

    private void init(String encoding) {
        this.nativeDecoder = TextDecoder.nativeInit(encoding);
    }

    public String decode(byte[] bytes) {
        return TextDecoder.nativeDecode(this.nativeDecoder, bytes);
    }

    public String decode(short[] bytes) {
        return TextDecoder.nativeDecodeShort(this.nativeDecoder, bytes);
    }

    public String decode(int[] bytes) {
        return TextDecoder.nativeDecodeInt(this.nativeDecoder, bytes);
    }

    public String getEncoding() {
        return TextDecoder.nativeGetEncoding(this.nativeDecoder);
    }
}

