/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.os.Handler;
import android.os.Looper;
import android.view.Choreographer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AnimationFrame
implements Choreographer.FrameCallback {
    private static HashMap<Long, Callback> callbacks;
    static long lastCall;
    static int count;
    static Timer timer;
    static AnimationFrame instance;
    static ExecutorService executorService;
    static final Object lock;
    static Choreographer choreographer;
    static Handler handler;
    static long animationId;
    static int _minFps;
    static int framesRendered;
    static long frameStartTime;
    static boolean inAnimationFrame;

    void reset() {
        _minFps = 1000;
        frameStartTime = 0L;
        framesRendered = 0;
    }

    void raf(final long fps) {
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                HashMap cbs = (HashMap)callbacks.clone();
                callbacks.clear();
                inAnimationFrame = true;
                Set set = cbs.entrySet();
                for (final Map.Entry cb : set) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            ((Callback)cb.getValue()).onFrame(fps);
                        }
                    });
                }
                inAnimationFrame = false;
                AnimationFrame.this.reset();
            }
        });
    }

    void fps(long currentTimeMillis) {
        if (frameStartTime > 0L) {
            long timeSpan = currentTimeMillis - frameStartTime;
            ++framesRendered;
            if (timeSpan > 1000L) {
                int fps = (int)((long)(framesRendered * 1000) / timeSpan);
                if (fps < _minFps) {
                    _minFps = fps;
                }
                this.raf(fps);
                frameStartTime = currentTimeMillis;
                framesRendered = 0;
            }
        } else {
            frameStartTime = currentTimeMillis;
        }
    }

    public void doFrame(long frameTimeNanos) {
        this.fps(frameTimeNanos / 1000000L);
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)instance);
    }

    private static long getTimeInFrameBase() {
        return System.nanoTime() / 1000000L;
    }

    private static long getNewId() {
        return ++animationId;
    }

    public static synchronized long requestAnimationFrame(Callback callback) {
        if (!inAnimationFrame) {
            inAnimationFrame = true;
            callback.onFrame(AnimationFrame.getTimeInFrameBase());
            inAnimationFrame = false;
            return AnimationFrame.getNewId();
        }
        long id = AnimationFrame.getNewId();
        callbacks.put(id, callback);
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)instance);
        return id;
    }

    public static void cancelAnimationFrame(long id) {
        callbacks.remove(id);
    }

    static {
        lastCall = 0L;
        count = 0;
        executorService = Executors.newCachedThreadPool();
        lock = new Object();
        animationId = 0L;
        callbacks = new HashMap();
        instance = new AnimationFrame();
        handler = new Handler(Looper.getMainLooper());
        _minFps = 1000;
        framesRendered = 0;
        frameStartTime = 0L;
        inAnimationFrame = false;
    }

    public static interface Callback {
        public void onFrame(long var1);
    }
}

