/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.opengl.EGL14;
import android.opengl.EGLDisplay;
import android.opengl.GLUtils;
import android.util.Log;
import com.github.triniwiz.canvas.CanvasView;
import java.lang.ref.WeakReference;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLSurface;

public class GLContext {
    private BlockingQueue<Runnable> mQueue = new LinkedBlockingQueue<Runnable>();
    private GLThread mGLThread;
    private javax.microedition.khronos.egl.EGLDisplay mEGLDisplay;
    private EGLSurface mEGLSurface;
    private EGLContext mEGLContext;
    private EGLConfig mEGLConfig;
    private EGL10 mEGL;
    WeakReference<CanvasView> reference;

    public boolean isHeadless() {
        if (this.mGLThread != null) {
            return this.mGLThread.mSurface == null;
        }
        return true;
    }

    public void queueEvent(Runnable runnable) {
        this.mQueue.add(runnable);
    }

    public void init(Object texture) {
        if (this.mGLThread != null) {
            return;
        }
        this.mGLThread = new GLThread(texture);
        this.mGLThread.setPriority(1);
        this.mGLThread.start();
    }

    public void flush() {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (GLContext.this.reference != null) {
                    CanvasView canvasView = (CanvasView)GLContext.this.reference.get();
                    if (canvasView != null && canvasView.canvas != 0L && canvasView.pendingInvalidate) {
                        CanvasView.nativeFlush(canvasView.canvas);
                        if (!GLContext.this.swapBuffers(GLContext.this.mEGLSurface)) {
                            Log.e((String)"GLContext", (String)"Cannot swap buffers!");
                        }
                        canvasView.pendingInvalidate = false;
                    } else if (!GLContext.this.swapBuffers(GLContext.this.mEGLSurface)) {
                        Log.e((String)"GLContext", (String)"Cannot swap buffers!");
                    }
                }
            }
        });
    }

    public EGLSurface createSurface(EGLConfig config, Object surface) {
        if (surface == null) {
            CanvasView view;
            int width = 1;
            int height = 1;
            if (this.reference != null && (view = (CanvasView)this.reference.get()) != null) {
                width = view.getWidth();
                height = view.getHeight();
            }
            int[] surfaceAttribs = new int[]{12375, width, 12374, height, 12344};
            return this.mEGL.eglCreatePbufferSurface(this.mEGLDisplay, config, surfaceAttribs);
        }
        return this.mEGL.eglCreateWindowSurface(this.mEGLDisplay, config, surface, null);
    }

    public void onPause() {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                GLContext.this.mEGL.eglMakeCurrent(GLContext.this.mEGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                GLContext.this.mGLThread.setPaused(true);
            }
        });
    }

    public void onResume() {
        this.mGLThread.setPaused(false);
    }

    public boolean makeCurrent(EGLSurface surface) {
        return this.mEGL.eglMakeCurrent(this.mEGLDisplay, surface, surface, this.mEGLContext);
    }

    public boolean destroySurface(EGLSurface surface) {
        return this.mEGL.eglDestroySurface(this.mEGLDisplay, surface);
    }

    public boolean swapBuffers(EGLSurface surface) {
        return this.mEGL.eglSwapBuffers(this.mEGLDisplay, surface);
    }

    public boolean isGLThreadStarted() {
        if (this.mGLThread == null) {
            return false;
        }
        return this.mGLThread.isStarted;
    }

    public void destroy() {
        if (this.mGLThread != null) {
            try {
                this.mGLThread.interrupt();
                this.mGLThread.join();
            }
            catch (InterruptedException e) {
                Log.e((String)"GLContext", (String)"Can't interrupt GL thread.", (Throwable)e);
            }
            this.mGLThread = null;
        }
    }

    private class GLThread
    extends Thread {
        private boolean isStarted = false;
        private boolean isPaused = false;
        private Object mSurface;
        private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
        private static final int EGL_CONTEXT_CLIENT_MINOR_VERSION = 12539;

        public synchronized void setPaused(boolean paused) {
            this.isPaused = paused;
        }

        @Override
        public synchronized void start() {
            super.start();
            this.isStarted = true;
        }

        @Override
        public void interrupt() {
            super.interrupt();
            this.isStarted = false;
        }

        public GLThread(Object texture) {
            this.mSurface = texture;
        }

        private void initEGL() {
            GLContext.this.mEGL = (EGL10)EGLContext.getEGL();
            GLContext.this.mEGLDisplay = GLContext.this.mEGL.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (GLContext.this.mEGLDisplay == EGL10.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetDisplay failed " + GLUtils.getEGLErrorString((int)GLContext.this.mEGL.eglGetError()));
            }
            int[] version = new int[2];
            if (!GLContext.this.mEGL.eglInitialize(GLContext.this.mEGLDisplay, version)) {
                throw new RuntimeException("eglInitialize failed " + GLUtils.getEGLErrorString((int)GLContext.this.mEGL.eglGetError()));
            }
            int[] configsCount = new int[1];
            EGLConfig[] configs = new EGLConfig[1];
            int[] configSpec = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 16, 12326, 0, 12344};
            if (!GLContext.this.mEGL.eglChooseConfig(GLContext.this.mEGLDisplay, configSpec, configs, 1, configsCount)) {
                throw new IllegalArgumentException("eglChooseConfig failed " + GLUtils.getEGLErrorString((int)GLContext.this.mEGL.eglGetError()));
            }
            if (configsCount[0] > 0) {
                GLContext.this.mEGLConfig = configs[0];
            }
            if (GLContext.this.mEGLConfig == null) {
                throw new RuntimeException("eglConfig not initialized");
            }
            GLContext.this.mEGLContext = this.createGLContext(3, 1, GLContext.this.mEGLConfig);
            if (GLContext.this.mEGLContext == null || GLContext.this.mEGLContext == EGL10.EGL_NO_CONTEXT) {
                GLContext.this.mEGLContext = this.createGLContext(3, 0, GLContext.this.mEGLConfig);
            }
            if (GLContext.this.mEGLContext == null || GLContext.this.mEGLContext == EGL10.EGL_NO_CONTEXT) {
                GLContext.this.mEGLContext = this.createGLContext(2, 0, GLContext.this.mEGLConfig);
            }
            GLContext.this.mEGLSurface = GLContext.this.createSurface(GLContext.this.mEGLConfig, this.mSurface);
            if (GLContext.this.mEGLSurface == null || GLContext.this.mEGLSurface == EGL10.EGL_NO_SURFACE) {
                int error = GLContext.this.mEGL.eglGetError();
                throw new RuntimeException("eglCreateWindowSurface failed " + GLUtils.getEGLErrorString((int)error));
            }
            this.makeEGLContextCurrent();
            EGL14.eglSwapInterval((EGLDisplay)EGL14.eglGetCurrentDisplay(), (int)0);
        }

        private void deInitEGL() {
            this.makeEGLContextCurrent();
            GLContext.this.destroySurface(GLContext.this.mEGLSurface);
            GLContext.this.mEGL.eglDestroyContext(GLContext.this.mEGLDisplay, GLContext.this.mEGLContext);
            GLContext.this.mEGL.eglTerminate(GLContext.this.mEGLDisplay);
        }

        private EGLContext createGLContext(int contextVersion, int minorVersion, EGLConfig eglConfig) {
            int[] attribs = new int[]{12440, contextVersion, 12539, minorVersion, 12344};
            return GLContext.this.mEGL.eglCreateContext(GLContext.this.mEGLDisplay, eglConfig, EGL10.EGL_NO_CONTEXT, attribs);
        }

        private void makeEGLContextCurrent() {
            if (!(GLContext.this.mEGLContext.equals(GLContext.this.mEGL.eglGetCurrentContext()) && GLContext.this.mEGLSurface.equals(GLContext.this.mEGL.eglGetCurrentSurface(12377)) || GLContext.this.makeCurrent(GLContext.this.mEGLSurface))) {
                throw new RuntimeException("eglMakeCurrent failed " + GLUtils.getEGLErrorString((int)GLContext.this.mEGL.eglGetError()));
            }
        }

        @Override
        public void run() {
            this.initEGL();
            try {
                while (true) {
                    if (this.isPaused) {
                        continue;
                    }
                    this.makeEGLContextCurrent();
                    ((Runnable)GLContext.this.mQueue.take()).run();
                }
            }
            catch (InterruptedException e) {
                this.deInitEGL();
                return;
            }
        }
    }
}

