/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Size;
import android.view.Choreographer;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import com.github.triniwiz.canvas.CanvasDOMMatrix;
import com.github.triniwiz.canvas.CanvasRenderingContext;
import com.github.triniwiz.canvas.CanvasRenderingContext2D;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class CanvasView
extends FrameLayout
implements GLSurfaceView.Renderer,
Choreographer.FrameCallback,
SurfaceHolder.Callback {
    private HandlerThread handlerThread = new HandlerThread("CanvasViewThread");
    private Handler handler;
    private GLSurfaceView glSurfaceView;
    private boolean handleInvalidationManually = false;
    long canvas = 0L;
    CanvasRenderingContext renderingContext2d = null;
    float scale = 0.0f;
    Context ctx;
    boolean pendingInvalidate;
    final Object lock = new Object();
    static final long ONE_MILLISECOND_NS = 1000000L;
    static final long ONE_S_IN_NS = 1000000000L;
    Handler mainHandler;
    boolean wasPendingDraw = false;
    static long lastCall = 0L;
    private static boolean isLibraryLoaded = false;
    int mWidth = -1;
    int mHeight = -1;
    int renderCount = 0;
    boolean wasDestroyed = false;
    Size lastSize;
    Size newSize;
    private static int rating = -1;

    private static native long nativeInit(long var0, int var2, int var3, int var4, float var5);

    private static native long nativeResize(long var0, int var2, int var3, int var4, float var5);

    private static native long nativeRecreate(long var0, int var2, int var3, int var4, float var5);

    private static native long nativeDeInit(long var0);

    private static native long nativeDestroy(long var0);

    private static native long nativeFlush(long var0);

    private static native String nativeToDataUrl(long var0, String var2, float var3);

    private static native byte[] nativeToData(long var0);

    void clear() {
        GLES20.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLES20.glClear((int)17664);
    }

    public void doFrame(long frameTimeNanos) {
        if (!this.handleInvalidationManually) {
            long dt = TimeUnit.NANOSECONDS.toMillis(frameTimeNanos - lastCall);
            this.handler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = CanvasView.this.lock;
                    synchronized (object) {
                        if (CanvasView.this.pendingInvalidate) {
                            CanvasView.this.flush();
                        }
                    }
                }
            });
            lastCall = frameTimeNanos;
        }
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
    }

    public CanvasView(Context context) {
        super(context, null);
    }

    public CanvasView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        if (this.isInEditMode()) {
            return;
        }
        if (!isLibraryLoaded) {
            System.loadLibrary("canvasnative");
            isLibraryLoaded = true;
        }
        this.glSurfaceView = new GLSurfaceView(context, attrs);
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper());
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.ctx = context;
        this.scale = context.getResources().getDisplayMetrics().density;
        this.glSurfaceView.setEGLConfigChooser(8, 8, 8, 8, 24, 8);
        if (this.detectOpenGLES30() && !CanvasView.isEmulator()) {
            this.glSurfaceView.setEGLContextClientVersion(3);
        } else {
            this.glSurfaceView.setEGLContextClientVersion(2);
        }
        this.glSurfaceView.setPreserveEGLContextOnPause(true);
        this.glSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.glSurfaceView.getHolder().setFormat(-3);
        this.glSurfaceView.setRenderer((GLSurfaceView.Renderer)this);
        this.glSurfaceView.setRenderMode(0);
        this.glSurfaceView.setZOrderOnTop(false);
        this.glSurfaceView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.setForeground((Drawable)new ColorDrawable(-1));
        this.addView((View)this.glSurfaceView);
    }

    private boolean detectOpenGLES30() {
        ActivityManager am = (ActivityManager)this.getContext().getSystemService("activity");
        ConfigurationInfo info = am.getDeviceConfigurationInfo();
        return info.reqGlEsVersion >= 196608;
    }

    public void onPause() {
        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
        this.wasDestroyed = true;
        if (this.pendingInvalidate) {
            this.wasPendingDraw = true;
        }
        this.pendingInvalidate = false;
        this.renderCount = 0;
        if (this.glSurfaceView != null) {
            this.glSurfaceView.onPause();
        }
    }

    public void onResume() {
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        if (this.wasPendingDraw) {
            this.pendingInvalidate = true;
            this.wasPendingDraw = false;
        }
        this.glSurfaceView.onResume();
    }

    public void destroy() {
        CanvasView.nativeDestroy(this.canvas);
        this.canvas = 0L;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.canvas != 0L) {
            this.destroy();
        }
    }

    public void setHandleInvalidationManually(boolean handleInvalidationManually) {
        this.handleInvalidationManually = handleInvalidationManually;
    }

    public boolean isHandleInvalidationManually() {
        return this.handleInvalidationManually;
    }

    public GLSurfaceView getSurface() {
        return this.glSurfaceView;
    }

    public void queueEvent(Runnable runnable) {
        if (this.glSurfaceView != null) {
            this.glSurfaceView.queueEvent(runnable);
        }
    }

    public byte[] toData() {
        return CanvasView.nativeToData(this.canvas);
    }

    public String toDataURL() {
        return this.toDataURL("image/png");
    }

    public void toDataURLAsync(DataURLListener listener) {
        this.toDataURLAsync("image/png", listener);
    }

    public void toDataURLAsync(String type, DataURLListener listener) {
        this.toDataURLAsync(type, 0.92f, listener);
    }

    public void toDataURLAsync(final String type, final float quality, final DataURLListener listener) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                listener.onResult(CanvasView.nativeToDataUrl(CanvasView.this.canvas, type, quality));
            }
        });
    }

    public String toDataURL(String type) {
        return this.toDataURL(type, 0.92f);
    }

    public String toDataURL(String type, float quality) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return CanvasView.nativeToDataUrl(this.canvas, type, quality);
    }

    public static CanvasDOMMatrix createSVGMatrix() {
        return new CanvasDOMMatrix();
    }

    @Nullable
    public CanvasRenderingContext getContext(String type) {
        if (type.equals("2d")) {
            if (this.renderingContext2d == null) {
                this.renderingContext2d = new CanvasRenderingContext2D(this);
            }
            return this.renderingContext2d;
        }
        return null;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        this.newSize = new Size(width, height);
    }

    public void flush() {
        this.glSurfaceView.requestRender();
    }

    void showForeground() {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                CanvasView.this.setForeground((Drawable)new ColorDrawable(-1));
            }
        });
    }

    void hideForeground() {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                CanvasView.this.setForeground(null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 gl) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.wasDestroyed) {
                this.clear();
            }
            if (this.canvas == 0L) {
                this.lastSize = this.newSize;
                int[] frameBuffers = new int[1];
                GLES20.glGetIntegerv((int)36006, (int[])frameBuffers, (int)0);
                this.canvas = CanvasView.nativeInit(this.canvas, frameBuffers[0], this.lastSize.getWidth(), this.lastSize.getHeight(), this.scale);
            }
            if (this.lastSize != this.newSize) {
                this.lastSize = this.newSize;
            }
            if (this.renderCount < 3) {
                ++this.renderCount;
            }
            if (!this.wasDestroyed || !this.pendingInvalidate) {
                this.canvas = CanvasView.nativeFlush(this.canvas);
            }
            this.pendingInvalidate = false;
            if (this.renderCount == 1 && this.wasDestroyed) {
                this.wasDestroyed = false;
                this.hideForeground();
            }
            if (this.renderCount == 3) {
                this.hideForeground();
            }
            this.wasDestroyed = false;
        }
    }

    public static boolean isEmulator() {
        int newRating = 0;
        if (rating < 0) {
            if (Build.PRODUCT.contains("sdk") || Build.PRODUCT.contains("Andy") || Build.PRODUCT.contains("ttVM_Hdragon") || Build.PRODUCT.contains("google_sdk") || Build.PRODUCT.contains("Droid4X") || Build.PRODUCT.contains("nox") || Build.PRODUCT.contains("sdk_x86") || Build.PRODUCT.contains("sdk_google") || Build.PRODUCT.contains("vbox86p")) {
                ++newRating;
            }
            if (Build.MANUFACTURER.equals("unknown") || Build.MANUFACTURER.equals("Genymotion") || Build.MANUFACTURER.contains("Andy") || Build.MANUFACTURER.contains("MIT") || Build.MANUFACTURER.contains("nox") || Build.MANUFACTURER.contains("TiantianVM") || Build.MANUFACTURER.contains("vmos")) {
                ++newRating;
            }
            if (Build.BRAND.equals("generic") || Build.BRAND.equals("generic_x86") || Build.BRAND.equals("TTVM") || Build.BRAND.contains("Andy")) {
                ++newRating;
            }
            if (Build.DEVICE.contains("generic") || Build.DEVICE.contains("generic_x86") || Build.DEVICE.contains("Andy") || Build.DEVICE.contains("ttVM_Hdragon") || Build.DEVICE.contains("Droid4X") || Build.DEVICE.contains("nox") || Build.DEVICE.contains("generic_x86_64") || Build.DEVICE.contains("vbox86p")) {
                ++newRating;
            }
            if (Build.MODEL.equals("sdk") || Build.MODEL.equals("google_sdk") || Build.MODEL.contains("Droid4X") || Build.MODEL.contains("TiantianVM") || Build.MODEL.contains("Andy") || Build.MODEL.equals("Android SDK built for x86_64") || Build.MODEL.equals("Android SDK built for x86") || Build.MODEL.equals("vmos")) {
                ++newRating;
            }
            if (Build.HARDWARE.equals("goldfish") || Build.HARDWARE.equals("vbox86") || Build.HARDWARE.contains("nox") || Build.HARDWARE.contains("ttVM_x86")) {
                ++newRating;
            }
            if (Build.FINGERPRINT.contains("generic/sdk/generic") || Build.FINGERPRINT.contains("generic_x86/sdk_x86/generic_x86") || Build.FINGERPRINT.contains("Andy") || Build.FINGERPRINT.contains("ttVM_Hdragon") || Build.FINGERPRINT.contains("generic_x86_64") || Build.FINGERPRINT.contains("generic/google_sdk/generic") || Build.FINGERPRINT.contains("vbox86p") || Build.FINGERPRINT.contains("generic/vbox86p/vbox86p") || Build.FINGERPRINT.contains("test-keys")) {
                ++newRating;
            }
            try {
                String opengl = GLES20.glGetString((int)7937);
                if (opengl != null && (opengl.contains("Bluestacks") || opengl.contains("Translator"))) {
                    newRating += 10;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                File sharedFolder = new File(Environment.getExternalStorageDirectory().toString() + File.separatorChar + "windows" + File.separatorChar + "BstSharedFolder");
                if (sharedFolder.exists()) {
                    newRating += 10;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            rating = newRating;
        }
        return rating > 3;
    }

    public static interface DataURLListener {
        public void onResult(String var1);
    }
}

