/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.os.Handler;
import android.os.HandlerThread;
import android.view.Choreographer;
import java.util.Map;
import java.util.Timer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class AnimationFrame
implements Choreographer.FrameCallback {
    private static ConcurrentHashMap<String, Callback> callbacks;
    static long lastCall;
    static int count;
    static Timer timer;
    static AnimationFrame instance;
    static HandlerThread handlerThread;
    static Handler handler;

    public void doFrame(long frameTimeNanos) {
        final long dt = frameTimeNanos - lastCall;
        handler.post(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry callback : callbacks.entrySet()) {
                    ((Callback)callback.getValue()).onFrame(dt / 1000L);
                    if (((String)callback.getKey()).equals("main")) continue;
                    callbacks.remove(callback.getKey());
                }
            }
        });
        lastCall = frameTimeNanos;
        Choreographer.getInstance().postFrameCallbackDelayed((Choreographer.FrameCallback)instance, dt);
    }

    public static String requestAnimationFrame(Callback callback) {
        String id = UUID.randomUUID().toString();
        callbacks.put(id, callback);
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)instance);
        return id;
    }

    static void requestAnimationFrame(String id, Callback callback) {
        callbacks.put(id, callback);
    }

    public static void cancelAnimationFrame(String id) {
        callbacks.remove(id);
        if (callbacks.isEmpty()) {
            Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)instance);
        }
    }

    static {
        lastCall = 0L;
        count = 0;
        callbacks = new ConcurrentHashMap();
        instance = new AnimationFrame();
        handlerThread = new HandlerThread("AnimationFrame");
        handlerThread.start();
        handler = new Handler(handlerThread.getLooper());
    }

    public static interface Callback {
        public void onFrame(long var1);
    }
}

