/*
 * Decompiled with CFR 0.152.
 */
package com.amazonservices.mws.client;

import java.io.Closeable;
import java.io.StringWriter;
import java.net.URI;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class MwsUtl {
    private static final Log log = LogFactory.getLog(MwsUtl.class);
    private static final Pattern asteriskPtn = Pattern.compile("*", 16);
    private static final Pattern BackSlashPtn = Pattern.compile("\\", 16);
    private static final AtomicReference<DateFormat> dateFormatPool = new AtomicReference();
    private static final Pattern EqualPtn = Pattern.compile("=", 16);
    private static final String EscBackSlash = "\\\\";
    private static final String EscEqual = "\\=";
    private static final String EscForwardSlash = "\\/";
    private static final String EscLParen = "\\(";
    private static final String EscRParen = "\\)";
    private static final String EscSemicolon = "\\;";
    private static final Pattern ForwardSlashPtn = Pattern.compile("/", 16);
    private static final Pattern LParenPtn = Pattern.compile("(", 16);
    private static final Pattern OuterWhiteSpacesPtn = Pattern.compile("\\A\\s+|\\s+\\z");
    private static final Pattern pct2FPtn = Pattern.compile("%2F", 16);
    private static final Pattern pct7EPtn = Pattern.compile("%7E", 16);
    private static final Pattern plusPtn = Pattern.compile("+", 16);
    private static final Pattern RParenPtn = Pattern.compile(")", 16);
    private static final Pattern SemicolonPtn = Pattern.compile(";", 16);
    private static final Pattern WhiteSpacesPtn = Pattern.compile("\\s+");
    static final String DEFAULT_ENCODING = "UTF-8";
    private static final ThreadLocal<DatatypeFactory> threadDTF = new ThreadLocal();
    private static final ThreadLocal<DocumentBuilderFactory> threadDBF = new ThreadLocal();
    private static final ThreadLocal<TransformerFactory> threadTF = new ThreadLocal();
    private static final ConcurrentHashMap<Object, HashMap<String, Object>> enumMaps = new ConcurrentHashMap();

    private static String calculateStringToSignV0(Map<String, String> parameters) {
        StringBuilder data = new StringBuilder();
        data.append(parameters.get("Action")).append(parameters.get("Timestamp"));
        return data.toString();
    }

    private static String calculateStringToSignV1(Map<String, String> parameters) {
        StringBuilder data = new StringBuilder();
        TreeMap<String, String> sorted = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        sorted.putAll(parameters);
        for (Map.Entry pair : sorted.entrySet()) {
            data.append((String)pair.getKey());
            data.append((String)pair.getValue());
        }
        return data.toString();
    }

    static String calculateStringToSignV2(URI serviceUri, Map<String, String> parameters) {
        StringBuilder data = new StringBuilder();
        data.append("POST");
        data.append("\n");
        data.append(serviceUri.getHost().toLowerCase());
        if (!MwsUtl.usesStandardPort(serviceUri)) {
            data.append(":");
            data.append(serviceUri.getPort());
        }
        data.append("\n");
        String uri = serviceUri.getPath();
        data.append(MwsUtl.urlEncode(uri, true));
        data.append("\n");
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        sorted.putAll(parameters);
        Iterator pairs = sorted.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry pair = pairs.next();
            String key = (String)pair.getKey();
            data.append(MwsUtl.urlEncode(key, false));
            data.append("=");
            String value = (String)pair.getValue();
            data.append(MwsUtl.urlEncode(value, false));
            if (!pairs.hasNext()) continue;
            data.append("&");
        }
        return data.toString();
    }

    private static String cleanWS(String s) {
        s = MwsUtl.replaceAll(s, OuterWhiteSpacesPtn, "");
        s = MwsUtl.replaceAll(s, WhiteSpacesPtn, " ");
        return s;
    }

    static String replaceAll(String s, Pattern p, String r) {
        int n;
        int n2 = n = s == null ? 0 : s.length();
        if (n == 0) {
            return s;
        }
        Matcher m = p.matcher(s);
        if (!m.find()) {
            return s;
        }
        StringBuilder buf = new StringBuilder(n + 12);
        int k = 0;
        do {
            buf.append(s, k, m.start());
            buf.append(r);
            k = m.end();
        } while (m.find());
        if (k < n) {
            buf.append(s, k, n);
        }
        return buf.toString();
    }

    static String sign(String data, String key, String algorithm) {
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key.getBytes(DEFAULT_ENCODING), algorithm));
            byte[] signature = Base64.encodeBase64((byte[])mac.doFinal(data.getBytes(DEFAULT_ENCODING)));
            String encoded = new String(signature, DEFAULT_ENCODING);
            return encoded;
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
    }

    protected static String urlEncode(String value, boolean path) {
        try {
            value = URLEncoder.encode(value, DEFAULT_ENCODING);
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
        value = MwsUtl.replaceAll(value, plusPtn, "%20");
        value = MwsUtl.replaceAll(value, asteriskPtn, "%2A");
        value = MwsUtl.replaceAll(value, pct7EPtn, "~");
        if (path) {
            value = MwsUtl.replaceAll(value, pct2FPtn, "/");
        }
        return value;
    }

    static DocumentBuilderFactory getDBF() {
        DocumentBuilderFactory dbf = threadDBF.get();
        if (dbf == null) {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            threadDBF.set(dbf);
        }
        return dbf;
    }

    static <T> T getEnumValue(Class<T> cls, String name) {
        Object v;
        HashMap<String, Object> enumMap = enumMaps.get(cls);
        if (enumMap == null) {
            T[] consts = cls.getEnumConstants();
            enumMap = new HashMap(consts.length);
            for (T e : consts) {
                enumMap.put(((Enum)e).toString(), e);
            }
            enumMaps.put(cls, enumMap);
        }
        if ((v = enumMap.get(name)) == null) {
            v = enumMap.get("Other");
        }
        return (T)v;
    }

    static String getFormattedTimestamp() {
        DateFormat df = dateFormatPool.getAndSet(null);
        if (df == null) {
            df = MwsUtl.createISODateFormat();
        }
        String timestamp = df.format(new Date());
        dateFormatPool.set(df);
        return timestamp;
    }

    static Date parseTimestamp(String timestamp) throws ParseException {
        DateFormat df = dateFormatPool.getAndSet(null);
        if (df == null) {
            df = MwsUtl.createISODateFormat();
        }
        Date date = df.parse(timestamp);
        dateFormatPool.set(df);
        return date;
    }

    static DateFormat createISODateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df;
    }

    static <T> T newInstance(Class<T> cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
    }

    static String signParameters(URI serviceUri, String signatureVersion, String signatureMethod, Map<String, String> parameters, String aswSecretKey) {
        parameters.put("SignatureVersion", signatureVersion);
        String algorithm = "HmacSHA1";
        String stringToSign = null;
        if ("0".equals(signatureVersion)) {
            stringToSign = MwsUtl.calculateStringToSignV0(parameters);
        } else if ("1".equals(signatureVersion)) {
            stringToSign = MwsUtl.calculateStringToSignV1(parameters);
        } else if ("2".equals(signatureVersion)) {
            algorithm = signatureMethod;
            parameters.put("SignatureMethod", algorithm);
            stringToSign = MwsUtl.calculateStringToSignV2(serviceUri, parameters);
        } else {
            throw new IllegalArgumentException("Invalid Signature Version specified");
        }
        return MwsUtl.sign(stringToSign, aswSecretKey, algorithm);
    }

    static String toXmlString(Node node) {
        try {
            Transformer transformer = MwsUtl.getTF().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", DEFAULT_ENCODING);
            transformer.setOutputProperty("indent", "no");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(node);
            transformer.transform(source, result);
            return sw.toString();
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
    }

    static boolean usesHttps(URI uri) {
        return uri.getScheme().equals("https");
    }

    static boolean usesStandardPort(URI uri) {
        int portNumber = uri.getPort();
        if (portNumber == -1) {
            return true;
        }
        String schema = uri.getScheme();
        int standardPort = schema.equals("https") ? 443 : 80;
        return portNumber == standardPort;
    }

    public static void close(Closeable a) {
        try {
            if (a != null) {
                a.close();
            }
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
    }

    public static String escapeAppName(String s) {
        s = MwsUtl.cleanWS(s);
        s = MwsUtl.replaceAll(s, BackSlashPtn, EscBackSlash);
        s = MwsUtl.replaceAll(s, ForwardSlashPtn, EscForwardSlash);
        return s;
    }

    public static String escapeAppVersion(String s) {
        s = MwsUtl.cleanWS(s);
        s = MwsUtl.replaceAll(s, BackSlashPtn, EscBackSlash);
        s = MwsUtl.replaceAll(s, LParenPtn, EscLParen);
        return s;
    }

    public static String escapeAttributeName(String s) {
        s = MwsUtl.cleanWS(s);
        s = MwsUtl.replaceAll(s, BackSlashPtn, EscBackSlash);
        s = MwsUtl.replaceAll(s, EqualPtn, EscEqual);
        return s;
    }

    public static String escapeAttributeValue(String s) {
        s = MwsUtl.cleanWS(s);
        s = MwsUtl.replaceAll(s, BackSlashPtn, EscBackSlash);
        s = MwsUtl.replaceAll(s, SemicolonPtn, EscSemicolon);
        s = MwsUtl.replaceAll(s, RParenPtn, EscRParen);
        return s;
    }

    public static DatatypeFactory getDTF() {
        DatatypeFactory dtf = threadDTF.get();
        if (dtf == null) {
            try {
                dtf = DatatypeFactory.newInstance();
            }
            catch (Exception e) {
                throw MwsUtl.wrap(e);
            }
            threadDTF.set(dtf);
        }
        return dtf;
    }

    public static TransformerFactory getTF() {
        TransformerFactory tf = threadTF.get();
        if (tf == null) {
            tf = TransformerFactory.newInstance();
            threadTF.set(tf);
        }
        return tf;
    }

    public static RuntimeException wrap(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    private MwsUtl() {
    }
}

