/*
 * Decompiled with CFR 0.152.
 */
package com.amazonservices.mws.client;

import com.amazonservices.mws.client.AbstractMwsObject;
import com.amazonservices.mws.client.MwsReader;
import com.amazonservices.mws.client.MwsResponseHeaderMetadata;
import com.amazonservices.mws.client.MwsWriter;
import com.amazonservices.mws.client.MwsXmlReader;

public class MwsException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int statusCode;
    private String message;
    private String xml;
    private String errorCode;
    private String errorType;
    private String detail;
    private MwsResponseHeaderMetadata rhmd;

    protected void setResponseHeaderMetadata(MwsResponseHeaderMetadata rhmd) {
        this.rhmd = rhmd;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorType() {
        return this.errorType;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getRequestId() {
        return this.rhmd == null ? null : this.rhmd.getRequestId();
    }

    public MwsResponseHeaderMetadata getResponseHeaderMetadata() {
        return this.rhmd;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getTimestamp() {
        return this.rhmd == null ? null : this.rhmd.getTimestamp();
    }

    public String getXML() {
        return this.xml;
    }

    public MwsException(int statusCode, String message, String errorCode, String errorType, String xml, MwsResponseHeaderMetadata rhmd) {
        this.statusCode = statusCode;
        this.rhmd = rhmd;
        this.xml = xml;
        this.message = message;
        this.errorCode = errorCode;
        this.errorType = errorType;
        if (xml != null) {
            try {
                MwsXmlReader r = new MwsXmlReader(xml);
                XmlMwsException parsed = r.read("Error", XmlMwsException.class);
                this.errorType = parsed.getErrorType();
                this.errorCode = parsed.getErrorCode();
                this.message = parsed.getMessage();
                this.detail = parsed.getDetail();
                r.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public MwsException(int statusCode, String message, Throwable cause) {
        super(cause);
        if (cause instanceof MwsException) {
            MwsException e = (MwsException)cause;
            this.statusCode = e.getStatusCode();
            this.message = e.getMessage();
            this.errorCode = e.getErrorCode();
            this.errorType = e.getErrorType();
            this.rhmd = e.getResponseHeaderMetadata();
            this.detail = e.getDetail();
            this.xml = e.getXML();
        } else {
            this.statusCode = statusCode;
            this.message = message;
        }
    }

    public MwsException(Throwable cause) {
        this(0, cause.getMessage(), cause);
    }

    protected static class XmlMwsException
    extends AbstractMwsObject {
        private String errorCode;
        private String errorType;
        private String message;
        private String detail;

        protected XmlMwsException() {
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorType() {
            return this.errorType;
        }

        public String getMessage() {
            return this.message;
        }

        public String getDetail() {
            return this.detail;
        }

        @Override
        public void readFragmentFrom(MwsReader r) {
            this.errorType = r.read("Type", String.class);
            this.errorCode = r.read("Code", String.class);
            this.message = r.read("Message", String.class);
            this.detail = r.read("Detail", String.class);
        }

        @Override
        public void writeFragmentTo(MwsWriter w) {
            w.write("Code", this.errorCode);
            w.write("Type", this.errorType);
            w.write("Message", this.message);
            w.write("Detail", this.detail);
        }

        @Override
        public void writeTo(MwsWriter w) {
            w.write("Error", this);
        }
    }
}

