/*
 * Decompiled with CFR 0.152.
 */
package com.amazonservices.mws.client;

import com.amazonservices.mws.client.MwsAQCall;
import com.amazonservices.mws.client.MwsCall;
import com.amazonservices.mws.client.MwsObject;
import com.amazonservices.mws.client.MwsReader;
import com.amazonservices.mws.client.MwsRequestType;
import com.amazonservices.mws.client.MwsResponseHeaderMetadata;
import com.amazonservices.mws.client.MwsUtl;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class MwsConnection
implements Cloneable,
Closeable {
    private static final Log log = LogFactory.getLog(MwsConnection.class);
    private static ClientConnectionManager sharedCM;
    private static ExecutorService sharedES;
    private String applicationName;
    private String applicationVersion;
    private String awsAccessKeyId;
    private String awsSecretKeyId;
    private ClientConnectionManager connectionManager;
    private int connectionTimeout = 50000;
    private int socketTimeout = 50000;
    private int maxAsyncThreads = 30;
    private int maxAsyncQueueSize = 300;
    private URI endpoint = null;
    private ExecutorService executorService;
    private volatile boolean frozen;
    private HttpClient httpClient;
    private HttpContext httpContext;
    private int maxConnections = 100;
    private int maxErrorRetry = 3;
    private String libraryVersion = "1.0.0";
    private String proxyHost = null;
    private String proxyPassword = null;
    private int proxyPort = -1;
    private String proxyUsername = null;
    private Map<String, ServiceEndpoint> serviceMap;
    private String signatureMethod = "HmacSHA256";
    private String signatureVersion = "2";
    private String userAgent = null;
    private Map<String, String> headers = new HashMap<String, String>();

    private void checkUpdatable() {
        if (this.frozen) {
            throw new IllegalStateException("Cannot change MwsConnection properties after connected.");
        }
    }

    synchronized void freeze() {
        if (this.frozen) {
            return;
        }
        if (this.userAgent == null) {
            this.setDefaultUserAgent();
        }
        this.serviceMap = new HashMap<String, ServiceEndpoint>();
        if (log.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Creating MwsConnection {");
            buf.append("applicationName:");
            buf.append(this.applicationName);
            buf.append(",applicationVersion:");
            buf.append(this.applicationVersion);
            buf.append(",awsAccessKeyId:");
            buf.append(this.awsAccessKeyId);
            buf.append(",uri:");
            buf.append(this.endpoint.toString());
            buf.append(",userAgent:");
            buf.append(this.userAgent);
            buf.append(",connectionTimeout:");
            buf.append(this.connectionTimeout);
            if (this.proxyHost != null && this.proxyPort != 0) {
                buf.append(",proxyUsername:");
                buf.append(this.proxyUsername);
                buf.append(",proxyHost:");
                buf.append(this.proxyHost);
                buf.append(",proxyPort:");
                buf.append(this.proxyPort);
            }
            buf.append("}");
            log.debug((Object)buf);
        }
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setParameter("http.useragent", (Object)this.userAgent);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)this.connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)this.socketTimeout);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)httpParams, (boolean)true);
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpParams, (boolean)true);
        this.connectionManager = this.getConnectionManager();
        this.httpClient = new DefaultHttpClient(this.connectionManager, (HttpParams)httpParams);
        this.httpContext = new BasicHttpContext();
        if (this.proxyHost != null && this.proxyPort != 0) {
            String scheme = MwsUtl.usesHttps(this.endpoint) ? "https" : "http";
            HttpHost hostConfiguration = new HttpHost(this.proxyHost, this.proxyPort, scheme);
            this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)hostConfiguration);
            if (this.proxyUsername != null && this.proxyPassword != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword);
                BasicCredentialsProvider cprovider = new BasicCredentialsProvider();
                cprovider.setCredentials(new AuthScope(this.proxyHost, this.proxyPort), (Credentials)credentials);
                this.httpContext.setAttribute("http.auth.credentials-provider", (Object)cprovider);
            }
        }
        this.headers = Collections.unmodifiableMap(this.headers);
        this.frozen = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConnectionManager getConnectionManager() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (sharedCM == null) {
                PoolingClientConnectionManager cm = new PoolingClientConnectionManager();
                cm.setMaxTotal(this.maxConnections);
                cm.setDefaultMaxPerRoute(this.maxConnections);
                sharedCM = cm;
            }
            return sharedCM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getSharedES() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (sharedES != null) {
                return sharedES;
            }
            sharedES = new ThreadPoolExecutor(this.maxAsyncThreads / 10, this.maxAsyncThreads, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.maxAsyncQueueSize), new ThreadFactory(){
                private final AtomicInteger threadNumber = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable task) {
                    Thread thread = new Thread(task, "MWSClient-" + this.threadNumber.getAndIncrement());
                    thread.setDaemon(true);
                    thread.setPriority(5);
                    return thread;
                }
            }, new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
                    if (executor.isShutdown()) {
                        throw new RejectedExecutionException();
                    }
                    log.warn((Object)"MWSClient async queue full, running on calling thread.");
                    task.run();
                }
            });
            return sharedES;
        }
    }

    private void setDefaultUserAgent() {
        this.setUserAgent(MwsUtl.escapeAppName(this.applicationName), MwsUtl.escapeAppVersion(this.applicationVersion), MwsUtl.escapeAttributeValue("Java/" + System.getProperty("java.version") + "/" + System.getProperty("java.class.version") + "/" + System.getProperty("java.vendor")), MwsUtl.escapeAttributeName("Platform"), MwsUtl.escapeAttributeValue("" + System.getProperty("os.name") + "/" + System.getProperty("os.arch") + "/" + System.getProperty("os.version")), MwsUtl.escapeAttributeName("MWSClientVersion"), MwsUtl.escapeAttributeValue(this.libraryVersion));
    }

    String getAwsSecretKeyId() {
        return this.awsSecretKeyId;
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    HttpContext getHttpContext() {
        return this.httpContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceEndpoint getServiceEndpoint(String servicePath) {
        Map<String, ServiceEndpoint> map = this.serviceMap;
        synchronized (map) {
            ServiceEndpoint sep = this.serviceMap.get(servicePath);
            if (sep == null) {
                sep = new ServiceEndpoint(this.endpoint, servicePath);
                this.serviceMap.put(servicePath, sep);
            }
            return sep;
        }
    }

    public <T extends MwsObject> T call(MwsRequestType type, MwsObject requestData) {
        MwsObject mwsObject;
        MwsReader responseReader = null;
        try {
            String servicePath = type.getServicePath();
            String operationName = type.getOperationName();
            MwsCall mc = this.newCall(servicePath, operationName);
            requestData.writeFragmentTo(mc);
            responseReader = mc.invoke();
            MwsResponseHeaderMetadata rhmd = mc.getResponseHeaderMetadata();
            MwsObject response = MwsUtl.newInstance(type.getResponseClass());
            type.setRHMD(response, rhmd);
            response.readFragmentFrom(responseReader);
            mwsObject = response;
        }
        catch (Exception e) {
            try {
                throw type.wrapException(e);
            }
            catch (Throwable throwable) {
                MwsUtl.close(responseReader);
                throw throwable;
            }
        }
        MwsUtl.close(responseReader);
        return (T)mwsObject;
    }

    public <T extends MwsObject> Future<T> callAsync(final MwsRequestType type, final MwsObject requestData) {
        return this.getExecutorService().submit(new Callable<T>(){

            @Override
            public T call() {
                return MwsConnection.this.call(type, requestData);
            }
        });
    }

    public synchronized MwsConnection clone() {
        try {
            MwsConnection a = (MwsConnection)super.clone();
            a.serviceMap = null;
            a.connectionManager = null;
            a.httpClient = null;
            a.httpContext = null;
            a.frozen = false;
            return a;
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
    }

    @Override
    public void close() {
        if (this.connectionManager != null) {
            this.connectionManager.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public synchronized ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = this.getSharedES();
        }
        return this.executorService;
    }

    public String getLibraryVersion() {
        return this.libraryVersion;
    }

    public int getMaxAsyncQueueSize() {
        return this.maxAsyncQueueSize;
    }

    public int getMaxAsyncThreads() {
        return this.maxAsyncThreads;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public String getSignatureVersion() {
        return this.signatureVersion;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    protected Map<String, String> getRequestHeaders() {
        return this.headers;
    }

    public String getRequestHeader(String name) {
        return this.headers.get(name);
    }

    public MwsCall newCall(String servicePath, String operationName) {
        if (!this.frozen) {
            this.freeze();
        }
        ServiceEndpoint sep = this.getServiceEndpoint(servicePath);
        return new MwsAQCall(this, sep, operationName);
    }

    public synchronized void setApplicationName(String name) {
        this.checkUpdatable();
        this.applicationName = name;
    }

    public synchronized void setApplicationVersion(String version) {
        this.checkUpdatable();
        this.applicationVersion = version;
    }

    public synchronized void setAwsAccessKeyId(String awsAccessKeyId) {
        this.checkUpdatable();
        this.awsAccessKeyId = awsAccessKeyId;
    }

    public synchronized void setAwsSecretKeyId(String awsSecretKeyId) {
        this.checkUpdatable();
        this.awsSecretKeyId = awsSecretKeyId;
    }

    public synchronized void setConnectionTimeout(int timeout) {
        this.checkUpdatable();
        this.connectionTimeout = timeout;
    }

    public synchronized void setEndpoint(URI endpoint) {
        this.checkUpdatable();
        int port = endpoint.getPort();
        if ((port == 80 || port == 443) && MwsUtl.usesStandardPort(endpoint)) {
            try {
                endpoint = new URI(endpoint.getScheme(), endpoint.getHost(), endpoint.getPath(), endpoint.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.endpoint = endpoint;
    }

    public synchronized void setExecutorService(ExecutorService executor) {
        this.checkUpdatable();
        this.executorService = executor;
    }

    public synchronized void setLibraryVersion(String libraryVersion) {
        this.checkUpdatable();
        this.libraryVersion = libraryVersion;
    }

    public synchronized void setMaxAsyncQueueSize(int maxAsyncQueueSize) {
        this.checkUpdatable();
        this.maxAsyncQueueSize = maxAsyncQueueSize;
    }

    public synchronized void setMaxAsyncThreads(int maxAsyncThreads) {
        this.checkUpdatable();
        this.maxAsyncThreads = maxAsyncThreads;
    }

    public synchronized void setMaxConnections(int maxConnections) {
        this.checkUpdatable();
        this.maxConnections = maxConnections;
    }

    public synchronized void setMaxErrorRetry(int maxErrorRetry) {
        this.checkUpdatable();
        this.maxErrorRetry = maxErrorRetry;
    }

    public synchronized void setProxyHost(String proxyHost) {
        this.checkUpdatable();
        this.proxyHost = proxyHost;
    }

    public synchronized void setProxyPassword(String proxyPassword) {
        this.checkUpdatable();
        this.proxyPassword = proxyPassword;
    }

    public synchronized void setProxyPort(int proxyPort) {
        this.checkUpdatable();
        this.proxyPort = proxyPort;
    }

    public synchronized void setProxyUsername(String proxyUsername) {
        this.checkUpdatable();
        this.proxyUsername = proxyUsername;
    }

    public synchronized void setSignatureMethod(String signatureMethod) {
        this.checkUpdatable();
        this.signatureMethod = signatureMethod;
    }

    public synchronized void setSignatureVersion(String signatureVersion) {
        this.checkUpdatable();
        this.signatureVersion = signatureVersion;
    }

    public synchronized void setSocketTimeout(int socketTimeout) {
        this.checkUpdatable();
        this.socketTimeout = socketTimeout;
    }

    public synchronized void setUserAgent(String applicationName, String applicationVersion, String programmingLanguage, String ... additionalNameValuePairs) {
        this.checkUpdatable();
        StringBuilder b = new StringBuilder();
        b.append(applicationName);
        b.append("/");
        b.append(applicationVersion);
        b.append(" (Language=");
        b.append(programmingLanguage);
        for (int i = 0; i < additionalNameValuePairs.length; i += 2) {
            String name = additionalNameValuePairs[i];
            String value = additionalNameValuePairs[i + 1];
            b.append("; ");
            b.append(name);
            b.append("=");
            b.append(value);
        }
        b.append(")");
        this.userAgent = b.toString();
    }

    public void includeRequestHeader(String name, String value) {
        this.checkUpdatable();
        this.headers.put(name, value);
    }

    public MwsConnection() {
    }

    public MwsConnection(URI endpoint, String applicationName, String applicationVersion, String awsAccessKeyId, String awsSecretKeyId) {
        this();
        this.setEndpoint(endpoint);
        this.applicationName = applicationName;
        this.applicationVersion = applicationVersion;
        this.awsAccessKeyId = awsAccessKeyId;
        this.awsSecretKeyId = awsSecretKeyId;
    }

    static class ServiceEndpoint {
        final String service;
        final String servicePath;
        final URI uri;
        final String version;

        ServiceEndpoint(URI baseUri, String servicePath) {
            this.servicePath = servicePath;
            int j = servicePath.lastIndexOf(47);
            this.service = servicePath.substring(0, j);
            this.version = servicePath.substring(j + 1);
            this.uri = baseUri.resolve("/" + servicePath);
        }
    }
}

