/*
 * Decompiled with CFR 0.152.
 */
package cl.transbank.webpay.transaccioncompleta.responses;

import java.util.List;

public class MallFullTransactionStatusResponse {
    private String buyOrder;
    private String sessionId;
    private String cardNumber;
    private String expirationDate;
    private String accountingDate;
    private String transactionDate;
    private List<Detail> details;
    private Double prepaidBalance;

    public MallFullTransactionStatusResponse() {
    }

    public MallFullTransactionStatusResponse(String buyOrder, String sessionId, String cardNumber, String expirationDate, String accountingDate, String transactionDate, List<Detail> details, Double prepaidBalance) {
        this.buyOrder = buyOrder;
        this.sessionId = sessionId;
        this.cardNumber = cardNumber;
        this.expirationDate = expirationDate;
        this.accountingDate = accountingDate;
        this.transactionDate = transactionDate;
        this.details = details;
        this.prepaidBalance = prepaidBalance;
    }

    public String getBuyOrder() {
        return this.buyOrder;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public String getAccountingDate() {
        return this.accountingDate;
    }

    public String getTransactionDate() {
        return this.transactionDate;
    }

    public List<Detail> getDetails() {
        return this.details;
    }

    public Double getPrepaidBalance() {
        return this.prepaidBalance;
    }

    public void setBuyOrder(String buyOrder) {
        this.buyOrder = buyOrder;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setAccountingDate(String accountingDate) {
        this.accountingDate = accountingDate;
    }

    public void setTransactionDate(String transactionDate) {
        this.transactionDate = transactionDate;
    }

    public void setDetails(List<Detail> details) {
        this.details = details;
    }

    public void setPrepaidBalance(Double prepaidBalance) {
        this.prepaidBalance = prepaidBalance;
    }

    public String toString() {
        return "MallFullTransactionStatusResponse(buyOrder=" + this.getBuyOrder() + ", sessionId=" + this.getSessionId() + ", cardNumber=" + this.getCardNumber() + ", expirationDate=" + this.getExpirationDate() + ", accountingDate=" + this.getAccountingDate() + ", transactionDate=" + this.getTransactionDate() + ", details=" + this.getDetails() + ", prepaidBalance=" + this.getPrepaidBalance() + ")";
    }

    public class Detail {
        private String authorizationCode;
        private String paymentTypeCode;
        private byte responseCode;
        private double installmentsAmount;
        private byte installmentsNumber;
        private double amount;
        private String commerceCode;
        private String buyOrder;
        private String status;
        private double balance;

        public Detail() {
        }

        public Detail(String authorizationCode, String paymentTypeCode, byte responseCode, double installmentsAmount, byte installmentsNumber, double amount, String commerceCode, String buyOrder, String status, double balance) {
            this.authorizationCode = authorizationCode;
            this.paymentTypeCode = paymentTypeCode;
            this.responseCode = responseCode;
            this.installmentsAmount = installmentsAmount;
            this.installmentsNumber = installmentsNumber;
            this.amount = amount;
            this.commerceCode = commerceCode;
            this.buyOrder = buyOrder;
            this.status = status;
            this.balance = balance;
        }

        public String getAuthorizationCode() {
            return this.authorizationCode;
        }

        public String getPaymentTypeCode() {
            return this.paymentTypeCode;
        }

        public byte getResponseCode() {
            return this.responseCode;
        }

        public double getInstallmentsAmount() {
            return this.installmentsAmount;
        }

        public byte getInstallmentsNumber() {
            return this.installmentsNumber;
        }

        public double getAmount() {
            return this.amount;
        }

        public String getCommerceCode() {
            return this.commerceCode;
        }

        public String getBuyOrder() {
            return this.buyOrder;
        }

        public String getStatus() {
            return this.status;
        }

        public double getBalance() {
            return this.balance;
        }

        public void setAuthorizationCode(String authorizationCode) {
            this.authorizationCode = authorizationCode;
        }

        public void setPaymentTypeCode(String paymentTypeCode) {
            this.paymentTypeCode = paymentTypeCode;
        }

        public void setResponseCode(byte responseCode) {
            this.responseCode = responseCode;
        }

        public void setInstallmentsAmount(double installmentsAmount) {
            this.installmentsAmount = installmentsAmount;
        }

        public void setInstallmentsNumber(byte installmentsNumber) {
            this.installmentsNumber = installmentsNumber;
        }

        public void setAmount(double amount) {
            this.amount = amount;
        }

        public void setCommerceCode(String commerceCode) {
            this.commerceCode = commerceCode;
        }

        public void setBuyOrder(String buyOrder) {
            this.buyOrder = buyOrder;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setBalance(double balance) {
            this.balance = balance;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Detail)) {
                return false;
            }
            Detail other = (Detail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$authorizationCode = this.getAuthorizationCode();
            String other$authorizationCode = other.getAuthorizationCode();
            if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) {
                return false;
            }
            String this$paymentTypeCode = this.getPaymentTypeCode();
            String other$paymentTypeCode = other.getPaymentTypeCode();
            if (this$paymentTypeCode == null ? other$paymentTypeCode != null : !this$paymentTypeCode.equals(other$paymentTypeCode)) {
                return false;
            }
            if (this.getResponseCode() != other.getResponseCode()) {
                return false;
            }
            if (Double.compare(this.getInstallmentsAmount(), other.getInstallmentsAmount()) != 0) {
                return false;
            }
            if (this.getInstallmentsNumber() != other.getInstallmentsNumber()) {
                return false;
            }
            if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
                return false;
            }
            String this$commerceCode = this.getCommerceCode();
            String other$commerceCode = other.getCommerceCode();
            if (this$commerceCode == null ? other$commerceCode != null : !this$commerceCode.equals(other$commerceCode)) {
                return false;
            }
            String this$buyOrder = this.getBuyOrder();
            String other$buyOrder = other.getBuyOrder();
            if (this$buyOrder == null ? other$buyOrder != null : !this$buyOrder.equals(other$buyOrder)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            return Double.compare(this.getBalance(), other.getBalance()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof Detail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $authorizationCode = this.getAuthorizationCode();
            result = result * 59 + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
            String $paymentTypeCode = this.getPaymentTypeCode();
            result = result * 59 + ($paymentTypeCode == null ? 43 : $paymentTypeCode.hashCode());
            result = result * 59 + this.getResponseCode();
            long $installmentsAmount = Double.doubleToLongBits(this.getInstallmentsAmount());
            result = result * 59 + (int)($installmentsAmount >>> 32 ^ $installmentsAmount);
            result = result * 59 + this.getInstallmentsNumber();
            long $amount = Double.doubleToLongBits(this.getAmount());
            result = result * 59 + (int)($amount >>> 32 ^ $amount);
            String $commerceCode = this.getCommerceCode();
            result = result * 59 + ($commerceCode == null ? 43 : $commerceCode.hashCode());
            String $buyOrder = this.getBuyOrder();
            result = result * 59 + ($buyOrder == null ? 43 : $buyOrder.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            long $balance = Double.doubleToLongBits(this.getBalance());
            result = result * 59 + (int)($balance >>> 32 ^ $balance);
            return result;
        }

        public String toString() {
            return "MallFullTransactionStatusResponse.Detail(authorizationCode=" + this.getAuthorizationCode() + ", paymentTypeCode=" + this.getPaymentTypeCode() + ", responseCode=" + this.getResponseCode() + ", installmentsAmount=" + this.getInstallmentsAmount() + ", installmentsNumber=" + this.getInstallmentsNumber() + ", amount=" + this.getAmount() + ", commerceCode=" + this.getCommerceCode() + ", buyOrder=" + this.getBuyOrder() + ", status=" + this.getStatus() + ", balance=" + this.getBalance() + ")";
        }
    }
}

