/*
 * Decompiled with CFR 0.152.
 */
package cl.transbank.webpay.transaccioncompleta;

import cl.transbank.common.ApiConstants;
import cl.transbank.common.BaseTransaction;
import cl.transbank.common.IntegrationApiKeys;
import cl.transbank.common.IntegrationCommerceCodes;
import cl.transbank.common.IntegrationType;
import cl.transbank.exception.TransbankException;
import cl.transbank.model.MallTransactionCreateDetails;
import cl.transbank.model.Options;
import cl.transbank.util.HttpUtil;
import cl.transbank.util.ValidationUtil;
import cl.transbank.util.WebpayApiResource;
import cl.transbank.webpay.common.MallTransactionCaptureRequest;
import cl.transbank.webpay.common.MallTransactionRefundRequest;
import cl.transbank.webpay.common.WebpayOptions;
import cl.transbank.webpay.exception.TransactionCaptureException;
import cl.transbank.webpay.exception.TransactionCommitException;
import cl.transbank.webpay.exception.TransactionCreateException;
import cl.transbank.webpay.exception.TransactionInstallmentException;
import cl.transbank.webpay.exception.TransactionRefundException;
import cl.transbank.webpay.exception.TransactionStatusException;
import cl.transbank.webpay.transaccioncompleta.model.MallTransactionCommitDetails;
import cl.transbank.webpay.transaccioncompleta.requests.MallFullTransactionCommitRequest;
import cl.transbank.webpay.transaccioncompleta.requests.MallFullTransactionCreateRequest;
import cl.transbank.webpay.transaccioncompleta.requests.MallFullTransactionInstallmentsRequest;
import cl.transbank.webpay.transaccioncompleta.responses.MallFullTransactionCaptureResponse;
import cl.transbank.webpay.transaccioncompleta.responses.MallFullTransactionCommitResponse;
import cl.transbank.webpay.transaccioncompleta.responses.MallFullTransactionCreateResponse;
import cl.transbank.webpay.transaccioncompleta.responses.MallFullTransactionInstallmentResponse;
import cl.transbank.webpay.transaccioncompleta.responses.MallFullTransactionInstallmentsDetails;
import cl.transbank.webpay.transaccioncompleta.responses.MallFullTransactionInstallmentsResponse;
import cl.transbank.webpay.transaccioncompleta.responses.MallFullTransactionRefundResponse;
import cl.transbank.webpay.transaccioncompleta.responses.MallFullTransactionStatusResponse;
import java.io.IOException;

public class MallFullTransaction
extends BaseTransaction {
    private static Options defaultOptions = null;

    public MallFullTransaction() {
        this.options = defaultOptions != null ? defaultOptions : new WebpayOptions(IntegrationCommerceCodes.TRANSACCION_COMPLETA_MALL, IntegrationApiKeys.WEBPAY, IntegrationType.TEST);
    }

    public MallFullTransaction(Options options) {
        this.options = options;
    }

    public MallFullTransactionCreateResponse create(String buyOrder, String sessionId, String cardNumber, String cardExpirationDate, MallTransactionCreateDetails details) throws IOException, TransactionCreateException {
        return this.create(buyOrder, sessionId, cardNumber, cardExpirationDate, details, null);
    }

    public MallFullTransactionCreateResponse create(String buyOrder, String sessionId, String cardNumber, String cardExpirationDate, MallTransactionCreateDetails details, Short cvv) throws IOException, TransactionCreateException {
        ValidationUtil.hasTextWithMaxLength(buyOrder, ApiConstants.BUY_ORDER_LENGTH, "buyOrder");
        ValidationUtil.hasTextWithMaxLength(sessionId, ApiConstants.SESSION_ID_LENGTH, "sessionId");
        ValidationUtil.hasTextWithMaxLength(cardNumber, ApiConstants.CARD_NUMBER_LENGTH, "cardNumber");
        ValidationUtil.hasTextWithMaxLength(cardExpirationDate, ApiConstants.CARD_EXPIRATION_DATE_LENGTH, "cardExpirationDate");
        ValidationUtil.hasElements(details.getDetails(), "details");
        for (int i = 0; i < details.getDetails().size(); ++i) {
            MallTransactionCreateDetails.Detail item = details.getDetails().get(i);
            ValidationUtil.hasTextWithMaxLength(item.getCommerceCode(), ApiConstants.COMMERCE_CODE_LENGTH, "details.commerceCode");
            ValidationUtil.hasTextWithMaxLength(item.getBuyOrder(), ApiConstants.BUY_ORDER_LENGTH, "details.buyOrder");
        }
        String endpoint = String.format("%s/transactions", ApiConstants.WEBPAY_ENDPOINT);
        MallFullTransactionCreateRequest request = new MallFullTransactionCreateRequest(buyOrder, sessionId, cardNumber, cardExpirationDate, details.getDetails(), cvv);
        try {
            return WebpayApiResource.execute(endpoint, HttpUtil.RequestMethod.POST, request, this.options, MallFullTransactionCreateResponse.class);
        }
        catch (TransbankException e) {
            throw new TransactionCreateException(e);
        }
    }

    public MallFullTransactionInstallmentsResponse installments(String token, MallFullTransactionInstallmentsDetails details) throws IOException, TransactionInstallmentException {
        ValidationUtil.hasTextWithMaxLength(token, ApiConstants.TOKEN_LENGTH, "token");
        String endpoint = String.format("%s/transactions/%s/installments", ApiConstants.WEBPAY_ENDPOINT, token);
        MallFullTransactionInstallmentsResponse response = MallFullTransactionInstallmentsResponse.build();
        for (MallFullTransactionInstallmentsDetails.Detail detail : details.getDetails()) {
            MallFullTransactionInstallmentsRequest request = new MallFullTransactionInstallmentsRequest(detail.getCommerceCode(), detail.getBuyOrder(), detail.getInstallmentsNumber());
            try {
                response.add(WebpayApiResource.execute(endpoint, HttpUtil.RequestMethod.POST, request, this.options, MallFullTransactionInstallmentResponse.class));
            }
            catch (TransbankException e) {
                throw new TransactionInstallmentException(e);
            }
        }
        return response;
    }

    public MallFullTransactionCommitResponse commit(String token, MallTransactionCommitDetails details) throws IOException, TransactionCommitException {
        ValidationUtil.hasTextWithMaxLength(token, ApiConstants.TOKEN_LENGTH, "token");
        String endpoint = String.format("%s/transactions/%s", ApiConstants.WEBPAY_ENDPOINT, token);
        MallFullTransactionCommitRequest request = new MallFullTransactionCommitRequest(details.getDetails());
        try {
            return WebpayApiResource.execute(endpoint, HttpUtil.RequestMethod.PUT, request, this.options, MallFullTransactionCommitResponse.class);
        }
        catch (TransbankException e) {
            throw new TransactionCommitException(e);
        }
    }

    public MallFullTransactionStatusResponse status(String token) throws IOException, TransactionStatusException {
        ValidationUtil.hasTextWithMaxLength(token, ApiConstants.TOKEN_LENGTH, "token");
        String endpoint = String.format("%s/transactions/%s", ApiConstants.WEBPAY_ENDPOINT, token);
        try {
            return WebpayApiResource.execute(endpoint, HttpUtil.RequestMethod.GET, this.options, MallFullTransactionStatusResponse.class);
        }
        catch (TransbankException e) {
            throw new TransactionStatusException(e);
        }
    }

    public MallFullTransactionRefundResponse refund(String token, String buyOrder, String childCommerceCode, double amount) throws IOException, TransactionRefundException {
        ValidationUtil.hasTextWithMaxLength(token, ApiConstants.TOKEN_LENGTH, "token");
        ValidationUtil.hasTextWithMaxLength(childCommerceCode, ApiConstants.COMMERCE_CODE_LENGTH, "childCommerceCode");
        ValidationUtil.hasTextWithMaxLength(buyOrder, ApiConstants.BUY_ORDER_LENGTH, "buyOrder");
        String endpoint = String.format("%s/transactions/%s/refunds", ApiConstants.WEBPAY_ENDPOINT, token);
        MallTransactionRefundRequest request = new MallTransactionRefundRequest(buyOrder, childCommerceCode, amount);
        try {
            return WebpayApiResource.execute(endpoint, HttpUtil.RequestMethod.POST, request, this.options, MallFullTransactionRefundResponse.class);
        }
        catch (TransbankException e) {
            throw new TransactionRefundException(e);
        }
    }

    public MallFullTransactionCaptureResponse capture(String token, String commerceCode, String buyOrder, String authorizationCode, double captureAmount) throws IOException, TransactionCaptureException {
        ValidationUtil.hasTextWithMaxLength(token, ApiConstants.TOKEN_LENGTH, "token");
        ValidationUtil.hasTextWithMaxLength(commerceCode, ApiConstants.COMMERCE_CODE_LENGTH, "commerceCode");
        ValidationUtil.hasTextWithMaxLength(buyOrder, ApiConstants.BUY_ORDER_LENGTH, "buyOrder");
        ValidationUtil.hasTextWithMaxLength(authorizationCode, ApiConstants.AUTHORIZATION_CODE_LENGTH, "authorizationCode");
        String endpoint = String.format("%s/transactions/%s/capture", ApiConstants.WEBPAY_ENDPOINT, token);
        MallTransactionCaptureRequest request = new MallTransactionCaptureRequest(commerceCode, buyOrder, authorizationCode, captureAmount);
        try {
            return WebpayApiResource.execute(endpoint, HttpUtil.RequestMethod.PUT, request, this.options, MallFullTransactionCaptureResponse.class);
        }
        catch (TransbankException e) {
            throw new TransactionCaptureException(e);
        }
    }

    public static void configureForIntegration(String commerceCode, String apiKey) {
        defaultOptions = new WebpayOptions(commerceCode, apiKey, IntegrationType.TEST);
    }

    public static void configureForProduction(String commerceCode, String apiKey) {
        defaultOptions = new WebpayOptions(commerceCode, apiKey, IntegrationType.LIVE);
    }

    public static void configureForTesting() {
        MallFullTransaction.configureForIntegration(IntegrationCommerceCodes.TRANSACCION_COMPLETA_MALL, IntegrationApiKeys.WEBPAY);
    }

    public static void configureForTestingDeferred() {
        MallFullTransaction.configureForIntegration(IntegrationCommerceCodes.TRANSACCION_COMPLETA_MALL_DEFERRED, IntegrationApiKeys.WEBPAY);
    }
}

