/*
 * Decompiled with CFR 0.152.
 */
package cl.transbank.patpass;

import cl.transbank.common.IntegrationApiKeys;
import cl.transbank.common.IntegrationCommerceCodes;
import cl.transbank.common.IntegrationType;
import cl.transbank.model.Options;
import cl.transbank.patpass.PatpassByWebpayTransaction;
import cl.transbank.patpass.model.PatpassOptions;
import cl.transbank.webpay.common.WebpayOptions;

public class PatpassByWebpay {
    private static Options options;

    public static void configureForIntegration(String commerceCode, String apiKey) {
        options = new PatpassOptions(commerceCode, apiKey, IntegrationType.TEST);
    }

    public static void configureForProduction(String commerceCode, String apiKey) {
        options = new PatpassOptions(commerceCode, apiKey, IntegrationType.LIVE);
    }

    public static void configureForTesting() {
        PatpassByWebpay.configureForIntegration(IntegrationCommerceCodes.PATPASS_BY_WEBPAY, IntegrationApiKeys.WEBPAY);
    }

    public static void configureForTestingDeferred() {
        PatpassByWebpay.configureForIntegration(IntegrationCommerceCodes.PATPASS_BY_WEBPAY, IntegrationApiKeys.WEBPAY);
    }

    public static void configureForMock() {
        options = new PatpassOptions(IntegrationCommerceCodes.PATPASS_BY_WEBPAY, IntegrationApiKeys.WEBPAY, IntegrationType.SERVER_MOCK);
    }

    public static class Transaction
    extends PatpassByWebpayTransaction {
        public Transaction() {
            this.options = options != null ? options : new WebpayOptions(IntegrationCommerceCodes.PATPASS_BY_WEBPAY, IntegrationApiKeys.WEBPAY, IntegrationType.TEST);
        }

        public Transaction(Options options) {
            this.options = options;
        }
    }
}

