/*
 * Decompiled with CFR 0.152.
 */
package com.srx.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.Transformation;
import android.widget.RelativeLayout;
import com.srx.widget.R;

public class TabMainView
extends View {
    private RectF rectF = new RectF();
    private Paint paint;
    private PaintFlagsDrawFilter paintFlagsDrawFilter;
    private DecelerateInterpolator decelerateInterpolator;
    private OvershootInterpolator overshootInterpolator;
    private Bitmap[] centerBtnsBitmap = new Bitmap[4];
    private Bitmap mainBtnBitmap;
    private Bitmap leftBtnBitmap;
    private Bitmap rightBtnBitmap;
    private float[] centerXs = new float[5];
    private float leftBtnCenterX;
    private float rightBtnCenterX;
    private float maxOvalR = 0.0f;
    private float minOvalR = 0.0f;
    private float dotR = 0.0f;
    private float dotY = 0.0f;
    private float maxMoveLength = 0.0f;
    private float leftCenterX = 0.0f;
    private float rightCenterX = 0.0f;
    private float secondlyFirstX = 0.0f;
    private float mainBtnDegrees;
    private float leftBtnDegrees;
    private float rightBtnDegrees;
    private float centerBtnsDegrees;
    private long durationMillis = 300L;
    private boolean isOpened = true;
    private boolean drawIcons = false;
    private boolean drawDot = false;
    private int position = 0;
    private int sizePosition = -1;
    private int width = 0;
    private int height = 0;
    private int centerX = 0;
    private int centerY = 0;
    private int heightDip = 66;
    private int[] colors = new int[3];
    private OnAnimationEndListener animationEndListener;
    private Animation animation = new Animation(){

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            if (TabMainView.this.isOpened) {
                TabMainView.this.leftCenterX = (float)TabMainView.this.centerX - TabMainView.this.maxMoveLength * (1.0f - TabMainView.this.decelerateInterpolator.getInterpolation(interpolatedTime));
                TabMainView.this.rightCenterX = (float)TabMainView.this.width - TabMainView.this.leftCenterX;
                TabMainView.this.leftBtnCenterX = TabMainView.this.secondlyFirstX - TabMainView.this.secondlyFirstX * 3.0f * (1.0f - TabMainView.this.overshootInterpolator.getInterpolation(interpolatedTime));
                TabMainView.this.rightBtnCenterX = (float)TabMainView.this.width - TabMainView.this.leftBtnCenterX;
                TabMainView.this.leftBtnDegrees = TabMainView.this.overshootInterpolator.getInterpolation(interpolatedTime) * 360.0f;
                TabMainView.this.rightBtnDegrees = 360.0f - TabMainView.this.leftBtnDegrees;
                TabMainView.this.mainBtnDegrees = TabMainView.this.rightBtnDegrees;
            } else {
                TabMainView.this.leftCenterX = (float)TabMainView.this.centerX - TabMainView.this.maxMoveLength * TabMainView.this.decelerateInterpolator.getInterpolation(interpolatedTime);
                TabMainView.this.rightCenterX = (float)TabMainView.this.width - TabMainView.this.leftCenterX;
                TabMainView.this.leftBtnCenterX = TabMainView.this.secondlyFirstX - TabMainView.this.secondlyFirstX * 3.0f * TabMainView.this.overshootInterpolator.getInterpolation(interpolatedTime);
                TabMainView.this.rightBtnCenterX = (float)TabMainView.this.width - TabMainView.this.leftBtnCenterX;
                TabMainView.this.leftBtnDegrees = (1.0f - TabMainView.this.overshootInterpolator.getInterpolation(interpolatedTime)) * 360.0f;
                TabMainView.this.rightBtnDegrees = 360.0f - TabMainView.this.leftBtnDegrees;
                TabMainView.this.mainBtnDegrees = TabMainView.this.rightBtnDegrees;
            }
            TabMainView.this.invalidate();
        }
    };
    private Animation rotateAnimation = new Animation(){

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            TabMainView.this.centerBtnsDegrees = TabMainView.this.overshootInterpolator.getInterpolation(interpolatedTime) * 360.0f;
            TabMainView.this.invalidate();
        }
    };
    private Animation.AnimationListener animListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
            TabMainView.this.drawDot = false;
            TabMainView.this.drawIcons = false;
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            if (!TabMainView.this.isOpened) {
                TabMainView.this.clearAnimation();
                TabMainView.this.startAnimation(TabMainView.this.rotateAnimation);
            } else if (TabMainView.this.animationEndListener != null) {
                TabMainView.this.animationEndListener.onAnimationEnd();
            }
        }
    };
    private Animation.AnimationListener rotateAnimListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
            TabMainView.this.drawIcons = true;
            TabMainView.this.drawDot = true;
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            if (TabMainView.this.animationEndListener != null) {
                TabMainView.this.animationEndListener.onAnimationEnd();
            }
        }
    };

    public void setMenuBitmaps(int position, int resId) {
        this.centerBtnsBitmap[position] = resId == 0 ? null : BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
        this.invalidate();
    }

    public void setRightBtnBitmap(int resId) {
        this.rightBtnBitmap = resId == 0 ? null : BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
        this.invalidate();
    }

    public void setLeftBtnBitmap(int resId) {
        this.leftBtnBitmap = resId == 0 ? null : BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
        this.invalidate();
    }

    public void setMainBtnBitmap(int resId) {
        this.mainBtnBitmap = resId == 0 ? null : BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
        this.invalidate();
    }

    public long getDuration() {
        return this.durationMillis;
    }

    public TabMainView(Context context) {
        this(context, null);
    }

    public TabMainView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initPaint();
        this.initLength();
        this.initAnimation();
    }

    private void initPaint() {
        this.colors[0] = this.getResources().getColor(R.color.tabbar_main);
        this.colors[1] = this.getResources().getColor(R.color.tabbar_secondly);
        this.colors[2] = this.getResources().getColor(R.color.background_color);
        this.paint = new Paint();
        this.paint.setColor(this.colors[0]);
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL);
        this.paintFlagsDrawFilter = new PaintFlagsDrawFilter(0, 3);
    }

    private void initLength() {
        DisplayMetrics dm = new DisplayMetrics();
        ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(dm);
        this.width = dm.widthPixels;
        this.height = (int)(dm.density * (float)this.heightDip + 0.5f);
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        this.maxOvalR = this.height / 2;
        this.minOvalR = this.maxOvalR * 2.0f / 3.0f;
        this.rightCenterX = this.leftCenterX = (float)(this.width / 2);
        this.leftBtnCenterX = this.minOvalR + this.maxOvalR / 2.0f;
        this.rightBtnCenterX = (float)this.width - this.leftBtnCenterX;
        this.secondlyFirstX = this.leftBtnCenterX;
        this.centerXs[0] = this.maxOvalR * 3.0f / 2.0f;
        this.centerXs[2] = this.centerX;
        this.maxMoveLength = (float)(this.width / 2) - this.centerXs[0];
        this.centerXs[1] = ((float)this.centerX - this.centerXs[0]) / 2.0f + this.centerXs[0];
        this.centerXs[3] = (float)this.width - this.centerXs[1];
        this.centerXs[4] = (float)this.width - this.centerXs[0];
        this.dotR = dm.density * 2.0f + 0.5f;
        this.dotY = (float)this.height - this.maxOvalR / 3.0f * 2.0f + 4.0f * this.dotR;
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(this.width, this.height));
    }

    private void initAnimation() {
        this.decelerateInterpolator = new DecelerateInterpolator(2.0f);
        this.overshootInterpolator = new OvershootInterpolator(1.0f);
        this.animation.setDuration(this.durationMillis);
        this.animation.setAnimationListener(this.animListener);
        this.rotateAnimation.setDuration(this.durationMillis);
        this.rotateAnimation.setAnimationListener(this.rotateAnimListener);
    }

    protected void onDraw(Canvas canvas) {
        canvas.setDrawFilter((DrawFilter)this.paintFlagsDrawFilter);
        this.paint.setColor(this.colors[0]);
        this.rectF.set(this.leftCenterX - this.maxOvalR, (float)this.centerY - this.maxOvalR, this.leftCenterX + this.maxOvalR, (float)this.centerY + this.maxOvalR);
        canvas.drawArc(this.rectF, 90.0f, 180.0f, false, this.paint);
        this.rectF.set(this.rightCenterX - this.maxOvalR, (float)this.centerY - this.maxOvalR, this.rightCenterX + this.maxOvalR, (float)this.centerY + this.maxOvalR);
        canvas.drawArc(this.rectF, -90.0f, 180.0f, false, this.paint);
        if (this.leftCenterX != this.rightCenterX) {
            canvas.drawRect(this.leftCenterX - 0.5f, 0.0f, this.rightCenterX + 0.5f, this.maxOvalR * 2.0f, this.paint);
        }
        if (this.drawDot) {
            this.paint.setColor(this.colors[2]);
            float centerX = this.centerXs[this.position];
            this.rectF.set(centerX - this.dotR, this.dotY - this.dotR, centerX + this.dotR, this.dotY + this.dotR);
            canvas.drawArc(this.rectF, 0.0f, 360.0f, false, this.paint);
        }
        if (this.mainBtnBitmap != null) {
            this.drawIcon(this.mainBtnBitmap, canvas, this.maxOvalR, this.centerXs[2], this.mainBtnDegrees, 2);
        }
        for (int i = 0; i < this.centerBtnsBitmap.length; ++i) {
            if (this.centerBtnsBitmap[i] == null) continue;
            int btn = i;
            if (i > 1) {
                ++btn;
            }
            if (!this.drawIcons) continue;
            this.drawIcon(this.centerBtnsBitmap[i], canvas, this.maxOvalR, this.centerXs[btn], this.centerBtnsDegrees, btn);
        }
        if (this.leftBtnBitmap != null) {
            this.rectF.set(this.leftBtnCenterX - this.minOvalR, (float)this.centerY - this.minOvalR, this.leftBtnCenterX + this.minOvalR, (float)this.centerY + this.minOvalR);
            canvas.drawArc(this.rectF, 0.0f, 360.0f, false, this.paint);
            this.drawIcon(this.leftBtnBitmap, canvas, this.maxOvalR, this.leftBtnCenterX, this.leftBtnDegrees, 10);
        }
        if (this.rightBtnBitmap != null) {
            this.rectF.set(this.rightBtnCenterX - this.minOvalR, (float)this.centerY - this.minOvalR, this.rightBtnCenterX + this.minOvalR, (float)this.centerY + this.minOvalR);
            canvas.drawArc(this.rectF, 0.0f, 360.0f, false, this.paint);
            this.drawIcon(this.rightBtnBitmap, canvas, this.maxOvalR, this.rightBtnCenterX, this.rightBtnDegrees, 11);
        }
        super.onDraw(canvas);
    }

    private void drawIcon(Bitmap bitmap, Canvas canvas, float radius, float pointX, float degrees, int position) {
        canvas.save();
        if (position == this.sizePosition) {
            canvas.scale(0.8f, 0.8f, pointX, (float)this.centerY);
        }
        canvas.rotate(degrees, pointX, (float)this.centerY);
        this.rectF.set(pointX - radius / 3.0f, (float)this.centerY - radius / 3.0f, pointX + radius / 3.0f, (float)this.centerY + radius / 3.0f);
        canvas.drawBitmap(bitmap, null, this.rectF, this.paint);
        canvas.restore();
    }

    public void onClick(int position) {
        if (position < 10) {
            if (position != 2) {
                this.position = position;
            }
            this.isOpened = !this.isOpened;
            this.startAnimation(this.animation);
        }
    }

    public void initPosition(int position) {
        if (position < 10 && position != 2) {
            this.position = position;
        }
    }

    public void onDown(int position) {
        this.sizePosition = position;
        this.invalidate();
    }

    public void onUp(int position) {
        this.sizePosition = -1;
        this.invalidate();
    }

    public void setOnAnimationEndListener(OnAnimationEndListener animationEndListener) {
        this.animationEndListener = animationEndListener;
    }

    public static interface OnAnimationEndListener {
        public void onAnimationEnd();
    }
}

