/*
 * Decompiled with CFR 0.152.
 */
package com.srx.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.srx.widget.R;
import com.srx.widget.TabMainView;
import java.util.HashMap;

public class TabBarView
extends RelativeLayout
implements View.OnClickListener,
View.OnTouchListener {
    private TabMainView tabBackView;
    private View secondlyFirstIV;
    private View secondlySecondIV;
    private View[] views = new View[5];
    private boolean clickable = true;
    private boolean btnsClickable = false;
    private int page = 0;
    private HashMap<String, Integer> btnsMap = new HashMap();
    private OnTabBarClickListener onTabBarClickListener;
    private TabMainView.OnAnimationEndListener onAnimationEndListener = new TabMainView.OnAnimationEndListener(){

        @Override
        public void onAnimationEnd() {
            TabBarView.this.clickable = true;
        }
    };

    public TabBarView(Context context) {
        this(context, null);
    }

    public TabBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(R.layout.widget_tabbar, (ViewGroup)this, true);
        this.initView();
        this.initListener();
        this.btnsClickable = false;
        this.initClickable(false);
    }

    private void initView() {
        this.tabBackView = (TabMainView)this.findViewById(R.id.tabBackView);
        this.views[0] = this.findViewById(R.id.firstIV);
        this.views[1] = this.findViewById(R.id.secondIV);
        this.views[2] = this.findViewById(R.id.centerIV);
        this.views[3] = this.findViewById(R.id.fourIV);
        this.views[4] = this.findViewById(R.id.fiveIV);
        this.secondlyFirstIV = this.findViewById(R.id.secondlyFirstIV);
        this.secondlySecondIV = this.findViewById(R.id.secondlySecondIV);
        for (int i = 0; i < this.views.length; ++i) {
            this.views[i].setTag((Object)i);
        }
        this.secondlyFirstIV.setTag((Object)10);
        this.secondlySecondIV.setTag((Object)11);
    }

    private void initListener() {
        for (View view : this.views) {
            view.setOnClickListener((View.OnClickListener)this);
            view.setOnTouchListener((View.OnTouchListener)this);
        }
        this.secondlyFirstIV.setOnTouchListener((View.OnTouchListener)this);
        this.secondlySecondIV.setOnTouchListener((View.OnTouchListener)this);
        this.secondlyFirstIV.setOnClickListener((View.OnClickListener)this);
        this.secondlySecondIV.setOnClickListener((View.OnClickListener)this);
        this.tabBackView.setOnAnimationEndListener(this.onAnimationEndListener);
    }

    private void initClickable(boolean clickable) {
        this.views[0].setClickable(clickable);
        this.views[1].setClickable(clickable);
        this.views[3].setClickable(clickable);
        this.views[4].setClickable(clickable);
        this.secondlyFirstIV.setClickable(!clickable);
        this.secondlySecondIV.setClickable(!clickable);
    }

    public boolean onTouch(View v, MotionEvent event) {
        int position = (Integer)v.getTag();
        if (event.getAction() == 0) {
            this.tabBackView.onDown(position);
        } else if (event.getAction() == 1) {
            this.tabBackView.onUp(position);
        }
        return false;
    }

    public void onClick(View v) {
        if (!this.clickable) {
            return;
        }
        this.clickable = false;
        int[] clickLocation = new int[2];
        v.getLocationOnScreen(clickLocation);
        clickLocation[0] = clickLocation[0] + v.getWidth() / 2;
        clickLocation[1] = clickLocation[1] + v.getHeight() / 2;
        int position = (Integer)v.getTag();
        if (position < 10) {
            if (position == 2) {
                this.btnsClickable = !this.btnsClickable;
                this.initClickable(this.btnsClickable);
            } else {
                this.btnsClickable = false;
                this.initClickable(false);
                int n = this.page = position > 1 ? position - 1 : position;
                if (this.onTabBarClickListener != null) {
                    this.onTabBarClickListener.onMainBtnsClick(position, clickLocation);
                }
                this.changeLeftRightIcon(this.page);
            }
            this.tabBackView.onClick(position);
        } else {
            this.clickable = true;
            if (this.onTabBarClickListener != null) {
                if (position == 10) {
                    this.onTabBarClickListener.onLeftBtnClick(this.page);
                } else {
                    this.onTabBarClickListener.onRightBtnClick(this.page);
                }
            }
        }
    }

    public void initializePage(int page) {
        this.page = page;
        this.tabBackView.initPosition(page);
        this.changeLeftRightIcon(page);
    }

    private void changeLeftRightIcon(int position) {
        this.setSecondlyFirstBitmap(this.btnsMap.get(position + "left"));
        this.setSecondlySecondBitmap(this.btnsMap.get(position + "right"));
    }

    public void bindBtnsForPage(int page, int menuBitmapId, int leftBitmapId, int rightBitmapId) {
        this.tabBackView.setMenuBitmaps(page, menuBitmapId);
        this.btnsMap.put(page + "left", leftBitmapId);
        this.btnsMap.put(page + "right", rightBitmapId);
        if (this.page != page) {
            this.initializePage(page);
        }
    }

    public void setMainBitmap(int mainBitmap) {
        this.tabBackView.setMainBtnBitmap(mainBitmap);
    }

    public void setSecondlyFirstBitmap(int secondlyFirstBitmap) {
        this.tabBackView.setLeftBtnBitmap(secondlyFirstBitmap);
        this.secondlyFirstIV.setVisibility(secondlyFirstBitmap != 0 ? 0 : 8);
    }

    public void setSecondlySecondBitmap(int secondlySecondBitmap) {
        this.tabBackView.setRightBtnBitmap(secondlySecondBitmap);
        this.secondlySecondIV.setVisibility(secondlySecondBitmap != 0 ? 0 : 8);
    }

    public void setOnTabBarClickListener(OnTabBarClickListener onTabBarClickListener) {
        this.onTabBarClickListener = onTabBarClickListener;
    }

    public static interface OnTabBarClickListener {
        public void onMainBtnsClick(int var1, int[] var2);

        public void onMainBtnsClick(int var1);

        public void onLeftBtnClick(int var1);

        public void onRightBtnClick(int var1);
    }
}

