/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import com.topjohnwu.superuser.internal.IRootServiceManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;

class RootServerMain
extends ContextWrapper
implements Callable<Object[]> {
    static final String CMDLINE_START_SERVICE = "start";
    static final String CMDLINE_START_DAEMON = "daemon";
    static final String CMDLINE_STOP_SERVICE = "stop";
    private static final Method getService;
    private static final Method attachBaseContext;
    private final int uid;
    private final boolean isDaemon;

    @SuppressLint(value={"PrivateApi"})
    static Context getSystemContext() {
        try {
            Class<?> atClazz = Class.forName("android.app.ActivityThread");
            Method systemMain = atClazz.getMethod("systemMain", new Class[0]);
            Object activityThread = systemMain.invoke(null, new Object[0]);
            Method getSystemContext = atClazz.getMethod("getSystemContext", new Class[0]);
            return (Context)getSystemContext.invoke(activityThread, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String getServiceName(String pkg) {
        return "libsu-" + pkg;
    }

    public static void main(String[] args) {
        System.out.close();
        System.err.close();
        if (args.length < 3) {
            System.exit(1);
        }
        Looper.prepareMainLooper();
        try {
            new RootServerMain(args);
        }
        catch (Exception e) {
            Log.e((String)"IPC", (String)"Error in IPCMain", (Throwable)e);
            System.exit(1);
        }
        Looper.loop();
        System.exit(1);
    }

    @Override
    public Object[] call() {
        Object[] objs = new Object[]{this.uid, this.isDaemon};
        return objs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DiscouragedPrivateApi"})
    public RootServerMain(String[] args) throws Exception {
        super(null);
        Context context;
        ComponentName name = ComponentName.unflattenFromString((String)args[0]);
        this.uid = Integer.parseInt(args[1]);
        String action = args[2];
        boolean stop = false;
        switch (action) {
            case "stop": {
                stop = true;
            }
            case "daemon": {
                this.isDaemon = true;
                break;
            }
            case "start": {
                this.isDaemon = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown action");
            }
        }
        if (this.isDaemon) {
            try {
                Object binder = getService.invoke(null, RootServerMain.getServiceName(name.getPackageName()));
                IRootServiceManager m = IRootServiceManager.Stub.asInterface((IBinder)binder);
                if (m != null) {
                    if (stop) {
                        m.stop(name, this.uid);
                    } else {
                        m.broadcast(this.uid);
                        System.exit(0);
                    }
                }
            }
            catch (RemoteException binder) {
            }
            finally {
                if (stop) {
                    System.exit(0);
                }
            }
        }
        Resources systemRes = Resources.getSystem();
        Field systemResField = null;
        try {
            Class.forName("com.lge.systemservice.core.integrity.IntegrityManager");
            ResourcesWrapper wrapper = new ResourcesWrapper(systemRes);
            systemResField = Resources.class.getDeclaredField("mSystem");
            systemResField.setAccessible(true);
            systemResField.set(null, (Object)wrapper);
        }
        catch (ReflectiveOperationException wrapper) {
            // empty catch block
        }
        Context systemContext = RootServerMain.getSystemContext();
        int userId = this.uid / 100000;
        int flags = 3;
        try {
            UserHandle userHandle = (UserHandle)UserHandle.class.getDeclaredMethod("of", Integer.TYPE).invoke(null, userId);
            context = (Context)systemContext.getClass().getDeclaredMethod("createPackageContextAsUser", String.class, Integer.TYPE, UserHandle.class).invoke((Object)systemContext, name.getPackageName(), flags, userHandle);
        }
        catch (Throwable e) {
            Log.w((String)"IPC", (String)("Failed to create package context as user: " + userId), (Throwable)e);
            context = systemContext.createPackageContext(name.getPackageName(), flags);
        }
        this.attachBaseContext(context);
        ClassLoader cl = context.getClassLoader();
        if (systemResField != null) {
            try {
                systemResField.set(null, systemRes);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        Class<?> clz = cl.loadClass(name.getClassName());
        Constructor<?> ctor = clz.getDeclaredConstructor(new Class[0]);
        ctor.setAccessible(true);
        attachBaseContext.invoke(ctor.newInstance(new Object[0]), this);
    }

    static {
        try {
            Class<?> sm = Class.forName("android.os.ServiceManager");
            getService = sm.getDeclaredMethod("getService", String.class);
            attachBaseContext = ContextWrapper.class.getDeclaredMethod("attachBaseContext", Context.class);
            attachBaseContext.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class ResourcesWrapper
    extends Resources {
        @SuppressLint(value={"DiscouragedPrivateApi"})
        public ResourcesWrapper(Resources res) throws ReflectiveOperationException {
            super(res.getAssets(), res.getDisplayMetrics(), res.getConfiguration());
            Method getImpl = Resources.class.getDeclaredMethod("getImpl", new Class[0]);
            getImpl.setAccessible(true);
            Method setImpl = Resources.class.getDeclaredMethod("setImpl", getImpl.getReturnType());
            setImpl.setAccessible(true);
            Object impl = getImpl.invoke((Object)res, new Object[0]);
            setImpl.invoke((Object)this, impl);
        }

        public boolean getBoolean(int id) {
            try {
                return super.getBoolean(id);
            }
            catch (Resources.NotFoundException e) {
                return false;
            }
        }
    }
}

