/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.nio;

import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.topjohnwu.superuser.internal.NIOFactory;
import com.topjohnwu.superuser.nio.ExtendedFile;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.FileChannel;

public abstract class FileSystemManager {
    public static final int MODE_READ_ONLY = 0x10000000;
    public static final int MODE_WRITE_ONLY = 0x20000000;
    public static final int MODE_READ_WRITE = 0x30000000;
    public static final int MODE_CREATE = 0x8000000;
    public static final int MODE_TRUNCATE = 0x4000000;
    public static final int MODE_APPEND = 0x2000000;
    private static final FileSystemManager LOCAL = NIOFactory.createLocal();
    private static Binder fsService;

    @NonNull
    public static synchronized Binder getService() {
        if (fsService == null) {
            fsService = NIOFactory.createFsService();
        }
        return fsService;
    }

    @NonNull
    public static FileSystemManager getLocal() {
        return LOCAL;
    }

    @NonNull
    public static FileSystemManager getRemote(@NonNull IBinder binder) throws RemoteException {
        return NIOFactory.createRemote(binder);
    }

    @NonNull
    public abstract ExtendedFile getFile(@NonNull String var1);

    @NonNull
    public abstract ExtendedFile getFile(@Nullable String var1, @NonNull String var2);

    @NonNull
    public final ExtendedFile getFile(@Nullable File parent, @NonNull String child) {
        return this.getFile(parent == null ? null : parent.getPath(), child);
    }

    @NonNull
    public final ExtendedFile getFile(@NonNull URI uri) {
        return this.getFile(new File(uri).getPath());
    }

    @NonNull
    public final FileChannel openChannel(@NonNull String pathname, int mode) throws IOException {
        return this.openChannel(new File(pathname), mode);
    }

    @NonNull
    public abstract FileChannel openChannel(@NonNull File var1, int var2) throws IOException;
}

