/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.os.Build;
import android.system.ErrnoException;
import android.system.Int64Ref;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.util.MutableLong;
import com.topjohnwu.superuser.internal.FileUtils;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

class OpenFile
implements Closeable {
    private static final boolean FORCE_NO_SPLICE = false;
    FileDescriptor fd;
    FileDescriptor read;
    FileDescriptor write;
    private ByteBuffer buf;
    private StructStat st;

    OpenFile() {
    }

    private ByteBuffer getBuf() {
        if (this.buf == null) {
            this.buf = ByteBuffer.allocateDirect(65536);
        }
        this.buf.clear();
        return this.buf;
    }

    private StructStat getStat() throws ErrnoException {
        if (this.st == null) {
            this.st = Os.fstat((FileDescriptor)this.fd);
        }
        return this.st;
    }

    private void ensureOpen() throws ClosedChannelException {
        if (this.fd == null) {
            throw new ClosedChannelException();
        }
    }

    @Override
    public synchronized void close() {
        if (this.fd != null) {
            try {
                Os.close((FileDescriptor)this.fd);
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
            this.fd = null;
        }
        if (this.read != null) {
            try {
                Os.close((FileDescriptor)this.read);
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
            this.read = null;
        }
        if (this.write != null) {
            try {
                Os.close((FileDescriptor)this.write);
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
            this.write = null;
        }
    }

    synchronized long lseek(long offset, int whence) throws ErrnoException, IOException {
        this.ensureOpen();
        return Os.lseek((FileDescriptor)this.fd, (long)offset, (int)whence);
    }

    synchronized long size() throws ErrnoException, IOException {
        this.ensureOpen();
        long cur = Os.lseek((FileDescriptor)this.fd, (long)0L, (int)OsConstants.SEEK_CUR);
        Os.lseek((FileDescriptor)this.fd, (long)0L, (int)OsConstants.SEEK_END);
        long sz = Os.lseek((FileDescriptor)this.fd, (long)0L, (int)OsConstants.SEEK_CUR);
        Os.lseek((FileDescriptor)this.fd, (long)cur, (int)OsConstants.SEEK_SET);
        return sz;
    }

    synchronized void ftruncate(long length) throws ErrnoException, IOException {
        this.ensureOpen();
        Os.ftruncate((FileDescriptor)this.fd, (long)length);
    }

    synchronized void sync(boolean metadata) throws ErrnoException, IOException {
        this.ensureOpen();
        if (metadata) {
            Os.fsync((FileDescriptor)this.fd);
        } else {
            Os.fdatasync((FileDescriptor)this.fd);
        }
    }

    synchronized int pread(int len, long offset) throws ErrnoException, IOException {
        long result;
        if (this.fd == null || this.write == null) {
            throw new ClosedChannelException();
        }
        if (Build.VERSION.SDK_INT >= 28) {
            Int64Ref inOff = offset < 0L ? null : new Int64Ref(offset);
            result = FileUtils.splice(this.fd, inOff, this.write, null, len, 0);
        } else {
            StructStat st = this.getStat();
            if (OsConstants.S_ISREG((int)st.st_mode) || OsConstants.S_ISBLK((int)st.st_mode)) {
                MutableLong inOff = offset < 0L ? null : new MutableLong(offset);
                result = FileUtils.sendfile(this.write, this.fd, inOff, len);
            } else {
                ByteBuffer buf = this.getBuf();
                buf.limit(Math.min(len, buf.capacity()));
                if (offset < 0L) {
                    Os.read((FileDescriptor)this.fd, (ByteBuffer)buf);
                } else {
                    Os.pread((FileDescriptor)this.fd, (ByteBuffer)buf, (long)offset);
                }
                buf.flip();
                result = buf.remaining();
                for (int sz = (int)result; sz > 0; sz -= Os.write((FileDescriptor)this.write, (ByteBuffer)buf)) {
                }
            }
        }
        return (int)result;
    }

    synchronized int pwrite(int len, long offset, boolean exact) throws ErrnoException, IOException {
        int sz;
        if (this.fd == null || this.read == null) {
            throw new ClosedChannelException();
        }
        if (Build.VERSION.SDK_INT >= 28) {
            Int64Ref outOff;
            Int64Ref int64Ref = outOff = offset < 0L ? null : new Int64Ref(offset);
            if (exact) {
                int sz2 = len;
                while (sz2 > 0) {
                    sz2 = (int)((long)sz2 - FileUtils.splice(this.read, null, this.fd, outOff, sz2, 0));
                }
                return len;
            }
            return (int)FileUtils.splice(this.read, null, this.fd, outOff, len, 0);
        }
        ByteBuffer buf = this.getBuf();
        buf.limit(len);
        if (exact) {
            for (sz = 0; len > sz; sz += Os.read((FileDescriptor)this.read, (ByteBuffer)buf)) {
            }
        } else {
            sz = Os.read((FileDescriptor)this.read, (ByteBuffer)buf);
        }
        len = sz;
        buf.flip();
        while (sz > 0) {
            if (offset < 0L) {
                sz -= Os.write((FileDescriptor)this.fd, (ByteBuffer)buf);
                continue;
            }
            int w = Os.pwrite((FileDescriptor)this.fd, (ByteBuffer)buf, (long)offset);
            sz -= w;
            offset += (long)w;
        }
        return len;
    }
}

