/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import androidx.annotation.NonNull;
import com.topjohnwu.superuser.internal.FileImpl;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class LocalFile
extends FileImpl<LocalFile> {
    LocalFile(String pathname) {
        super(pathname);
    }

    LocalFile(String parent, String child) {
        super(parent, child);
    }

    @Override
    protected LocalFile create(String path) {
        return new LocalFile(path);
    }

    @Override
    @NonNull
    public LocalFile getChildFile(String name) {
        return new LocalFile(this.getPath(), name);
    }

    protected LocalFile[] createArray(int n) {
        return new LocalFile[n];
    }

    @Override
    public boolean isBlock() {
        try {
            StructStat st = Os.lstat((String)this.getPath());
            return OsConstants.S_ISBLK((int)st.st_mode);
        }
        catch (ErrnoException e) {
            return false;
        }
    }

    @Override
    public boolean isCharacter() {
        try {
            StructStat st = Os.lstat((String)this.getPath());
            return OsConstants.S_ISCHR((int)st.st_mode);
        }
        catch (ErrnoException e) {
            return false;
        }
    }

    @Override
    public boolean isSymlink() {
        try {
            StructStat st = Os.lstat((String)this.getPath());
            return OsConstants.S_ISLNK((int)st.st_mode);
        }
        catch (ErrnoException e) {
            return false;
        }
    }

    @Override
    public boolean isNamedPipe() {
        try {
            StructStat st = Os.lstat((String)this.getPath());
            return OsConstants.S_ISFIFO((int)st.st_mode);
        }
        catch (ErrnoException e) {
            return false;
        }
    }

    @Override
    public boolean isSocket() {
        try {
            StructStat st = Os.lstat((String)this.getPath());
            return OsConstants.S_ISSOCK((int)st.st_mode);
        }
        catch (ErrnoException e) {
            return false;
        }
    }

    @Override
    @NonNull
    public InputStream newInputStream() throws IOException {
        return new FileInputStream(this);
    }

    @Override
    @NonNull
    public OutputStream newOutputStream(boolean append) throws IOException {
        return new FileOutputStream(this, append);
    }

    @Override
    public boolean createNewLink(String existing) throws IOException {
        return this.createLink(existing, false);
    }

    @Override
    public boolean createNewSymlink(String target) throws IOException {
        return this.createLink(target, true);
    }

    private boolean createLink(String target, boolean soft) throws IOException {
        try {
            if (soft) {
                Os.symlink((String)target, (String)this.getPath());
            } else {
                Os.link((String)target, (String)this.getPath());
            }
            return true;
        }
        catch (ErrnoException e) {
            if (e.errno != OsConstants.EEXIST) {
                throw new IOException(e);
            }
            return false;
        }
    }
}

