/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import com.topjohnwu.superuser.internal.IOResult;

public interface IFileSystemService
extends IInterface {
    public static final String DESCRIPTOR = "com.topjohnwu.superuser.internal.IFileSystemService";

    public IOResult getCanonicalPath(String var1) throws RemoteException;

    public boolean isDirectory(String var1) throws RemoteException;

    public boolean isFile(String var1) throws RemoteException;

    public boolean isHidden(String var1) throws RemoteException;

    public long lastModified(String var1) throws RemoteException;

    public long length(String var1) throws RemoteException;

    public IOResult createNewFile(String var1) throws RemoteException;

    public boolean delete(String var1) throws RemoteException;

    public String[] list(String var1) throws RemoteException;

    public boolean mkdir(String var1) throws RemoteException;

    public boolean mkdirs(String var1) throws RemoteException;

    public boolean renameTo(String var1, String var2) throws RemoteException;

    public boolean setLastModified(String var1, long var2) throws RemoteException;

    public boolean setReadOnly(String var1) throws RemoteException;

    public boolean setWritable(String var1, boolean var2, boolean var3) throws RemoteException;

    public boolean setReadable(String var1, boolean var2, boolean var3) throws RemoteException;

    public boolean setExecutable(String var1, boolean var2, boolean var3) throws RemoteException;

    public boolean checkAccess(String var1, int var2) throws RemoteException;

    public long getTotalSpace(String var1) throws RemoteException;

    public long getFreeSpace(String var1) throws RemoteException;

    public long getUsableSpace(String var1) throws RemoteException;

    public int getMode(String var1) throws RemoteException;

    public IOResult createLink(String var1, String var2, boolean var3) throws RemoteException;

    public void register(IBinder var1) throws RemoteException;

    public IOResult openChannel(String var1, int var2, String var3) throws RemoteException;

    public IOResult openReadStream(String var1, ParcelFileDescriptor var2) throws RemoteException;

    public IOResult openWriteStream(String var1, ParcelFileDescriptor var2, boolean var3) throws RemoteException;

    public void close(int var1) throws RemoteException;

    public IOResult pread(int var1, int var2, long var3) throws RemoteException;

    public IOResult pwrite(int var1, int var2, long var3) throws RemoteException;

    public IOResult lseek(int var1, long var2, int var4) throws RemoteException;

    public IOResult size(int var1) throws RemoteException;

    public IOResult ftruncate(int var1, long var2) throws RemoteException;

    public IOResult sync(int var1, boolean var2) throws RemoteException;

    public static class _Parcel {
        private static <T> T readTypedObject(Parcel parcel, Parcelable.Creator<T> c) {
            if (parcel.readInt() != 0) {
                return (T)c.createFromParcel(parcel);
            }
            return null;
        }

        private static <T extends Parcelable> void writeTypedObject(Parcel parcel, T value, int parcelableFlags) {
            if (value != null) {
                parcel.writeInt(1);
                value.writeToParcel(parcel, parcelableFlags);
            } else {
                parcel.writeInt(0);
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements IFileSystemService {
        static final int TRANSACTION_getCanonicalPath = 1;
        static final int TRANSACTION_isDirectory = 2;
        static final int TRANSACTION_isFile = 3;
        static final int TRANSACTION_isHidden = 4;
        static final int TRANSACTION_lastModified = 5;
        static final int TRANSACTION_length = 6;
        static final int TRANSACTION_createNewFile = 7;
        static final int TRANSACTION_delete = 8;
        static final int TRANSACTION_list = 9;
        static final int TRANSACTION_mkdir = 10;
        static final int TRANSACTION_mkdirs = 11;
        static final int TRANSACTION_renameTo = 12;
        static final int TRANSACTION_setLastModified = 13;
        static final int TRANSACTION_setReadOnly = 14;
        static final int TRANSACTION_setWritable = 15;
        static final int TRANSACTION_setReadable = 16;
        static final int TRANSACTION_setExecutable = 17;
        static final int TRANSACTION_checkAccess = 18;
        static final int TRANSACTION_getTotalSpace = 19;
        static final int TRANSACTION_getFreeSpace = 20;
        static final int TRANSACTION_getUsableSpace = 21;
        static final int TRANSACTION_getMode = 22;
        static final int TRANSACTION_createLink = 23;
        static final int TRANSACTION_register = 24;
        static final int TRANSACTION_openChannel = 25;
        static final int TRANSACTION_openReadStream = 26;
        static final int TRANSACTION_openWriteStream = 27;
        static final int TRANSACTION_close = 28;
        static final int TRANSACTION_pread = 29;
        static final int TRANSACTION_pwrite = 30;
        static final int TRANSACTION_lseek = 31;
        static final int TRANSACTION_size = 32;
        static final int TRANSACTION_ftruncate = 33;
        static final int TRANSACTION_sync = 34;

        public Stub() {
            this.attachInterface(this, IFileSystemService.DESCRIPTOR);
        }

        public static IFileSystemService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IFileSystemService.DESCRIPTOR);
            if (iin != null && iin instanceof IFileSystemService) {
                return (IFileSystemService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IFileSystemService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    IOResult _result = this.getCanonicalPath(_arg0);
                    reply.writeNoException();
                    _Parcel.writeTypedObject(reply, _result, 1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    boolean _result = this.isDirectory(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    boolean _result = this.isFile(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    boolean _result = this.isHidden(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    long _result = this.lastModified(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    long _result = this.length(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    IOResult _result = this.createNewFile(_arg0);
                    reply.writeNoException();
                    _Parcel.writeTypedObject(reply, _result, 1);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    boolean _result = this.delete(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    String[] _result = this.list(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    boolean _result = this.mkdir(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    boolean _result = this.mkdirs(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.renameTo(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    boolean _result = this.setLastModified(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    boolean _result = this.setReadOnly(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    boolean _result = this.setWritable(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    boolean _result = this.setReadable(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    boolean _result = this.setExecutable(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.checkAccess(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    long _result = this.getTotalSpace(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 20: {
                    String _arg0 = data.readString();
                    long _result = this.getFreeSpace(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 21: {
                    String _arg0 = data.readString();
                    long _result = this.getUsableSpace(_arg0);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 22: {
                    String _arg0 = data.readString();
                    int _result = this.getMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _arg2 = 0 != data.readInt();
                    IOResult _result = this.createLink(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    _Parcel.writeTypedObject(reply, _result, 1);
                    break;
                }
                case 24: {
                    IBinder _arg0 = data.readStrongBinder();
                    this.register(_arg0);
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    IOResult _result = this.openChannel(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    _Parcel.writeTypedObject(reply, _result, 1);
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    ParcelFileDescriptor _arg1 = (ParcelFileDescriptor)_Parcel.readTypedObject(data, ParcelFileDescriptor.CREATOR);
                    IOResult _result = this.openReadStream(_arg0, _arg1);
                    reply.writeNoException();
                    _Parcel.writeTypedObject(reply, _result, 1);
                    break;
                }
                case 27: {
                    String _arg0 = data.readString();
                    ParcelFileDescriptor _arg1 = (ParcelFileDescriptor)_Parcel.readTypedObject(data, ParcelFileDescriptor.CREATOR);
                    boolean _arg2 = 0 != data.readInt();
                    IOResult _result = this.openWriteStream(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    _Parcel.writeTypedObject(reply, _result, 1);
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    this.close(_arg0);
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    long _arg2 = data.readLong();
                    IOResult _result = this.pread(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    _Parcel.writeTypedObject(reply, _result, 1);
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    long _arg2 = data.readLong();
                    IOResult _result = this.pwrite(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    _Parcel.writeTypedObject(reply, _result, 1);
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    IOResult _result = this.lseek(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    _Parcel.writeTypedObject(reply, _result, 1);
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    IOResult _result = this.size(_arg0);
                    reply.writeNoException();
                    _Parcel.writeTypedObject(reply, _result, 1);
                    break;
                }
                case 33: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    IOResult _result = this.ftruncate(_arg0, _arg1);
                    reply.writeNoException();
                    _Parcel.writeTypedObject(reply, _result, 1);
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    IOResult _result = this.sync(_arg0, _arg1);
                    reply.writeNoException();
                    _Parcel.writeTypedObject(reply, _result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IFileSystemService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IFileSystemService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IOResult getCanonicalPath(String path) throws RemoteException {
                IOResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = (IOResult)_Parcel.readTypedObject(_reply, IOResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDirectory(String path) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isFile(String path) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHidden(String path) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long lastModified(String path) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long length(String path) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IOResult createNewFile(String path) throws RemoteException {
                IOResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = (IOResult)_Parcel.readTypedObject(_reply, IOResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean delete(String path) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] list(String path) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean mkdir(String path) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean mkdirs(String path) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean renameTo(String path, String dest) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    _data.writeString(dest);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setLastModified(String path, long time) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    _data.writeLong(time);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setReadOnly(String path) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWritable(String path, boolean writable, boolean ownerOnly) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    _data.writeInt(writable ? 1 : 0);
                    _data.writeInt(ownerOnly ? 1 : 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setReadable(String path, boolean readable, boolean ownerOnly) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    _data.writeInt(readable ? 1 : 0);
                    _data.writeInt(ownerOnly ? 1 : 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setExecutable(String path, boolean executable, boolean ownerOnly) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    _data.writeInt(executable ? 1 : 0);
                    _data.writeInt(ownerOnly ? 1 : 0);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean checkAccess(String path, int access) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    _data.writeInt(access);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getTotalSpace(String path) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getFreeSpace(String path) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getUsableSpace(String path) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMode(String path) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IOResult createLink(String link, String target, boolean soft) throws RemoteException {
                IOResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(link);
                    _data.writeString(target);
                    _data.writeInt(soft ? 1 : 0);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = (IOResult)_Parcel.readTypedObject(_reply, IOResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void register(IBinder client) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeStrongBinder(client);
                    boolean bl = this.mRemote.transact(24, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IOResult openChannel(String path, int mode, String fifo) throws RemoteException {
                IOResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    _data.writeInt(mode);
                    _data.writeString(fifo);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = (IOResult)_Parcel.readTypedObject(_reply, IOResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IOResult openReadStream(String path, ParcelFileDescriptor fd) throws RemoteException {
                IOResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    _Parcel.writeTypedObject(_data, (Parcelable)fd, 0);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = (IOResult)_Parcel.readTypedObject(_reply, IOResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IOResult openWriteStream(String path, ParcelFileDescriptor fd, boolean append) throws RemoteException {
                IOResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeString(path);
                    _Parcel.writeTypedObject(_data, (Parcelable)fd, 0);
                    _data.writeInt(append ? 1 : 0);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = (IOResult)_Parcel.readTypedObject(_reply, IOResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close(int handle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeInt(handle);
                    boolean bl = this.mRemote.transact(28, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IOResult pread(int handle, int len, long offset) throws RemoteException {
                IOResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeInt(handle);
                    _data.writeInt(len);
                    _data.writeLong(offset);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = (IOResult)_Parcel.readTypedObject(_reply, IOResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IOResult pwrite(int handle, int len, long offset) throws RemoteException {
                IOResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeInt(handle);
                    _data.writeInt(len);
                    _data.writeLong(offset);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = (IOResult)_Parcel.readTypedObject(_reply, IOResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IOResult lseek(int handle, long offset, int whence) throws RemoteException {
                IOResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeInt(handle);
                    _data.writeLong(offset);
                    _data.writeInt(whence);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = (IOResult)_Parcel.readTypedObject(_reply, IOResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IOResult size(int handle) throws RemoteException {
                IOResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeInt(handle);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = (IOResult)_Parcel.readTypedObject(_reply, IOResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IOResult ftruncate(int handle, long length) throws RemoteException {
                IOResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeInt(handle);
                    _data.writeLong(length);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = (IOResult)_Parcel.readTypedObject(_reply, IOResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IOResult sync(int handle, boolean metadata) throws RemoteException {
                IOResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileSystemService.DESCRIPTOR);
                    _data.writeInt(handle);
                    _data.writeInt(metadata ? 1 : 0);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = (IOResult)_Parcel.readTypedObject(_reply, IOResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IFileSystemService {
        @Override
        public IOResult getCanonicalPath(String path) throws RemoteException {
            return null;
        }

        @Override
        public boolean isDirectory(String path) throws RemoteException {
            return false;
        }

        @Override
        public boolean isFile(String path) throws RemoteException {
            return false;
        }

        @Override
        public boolean isHidden(String path) throws RemoteException {
            return false;
        }

        @Override
        public long lastModified(String path) throws RemoteException {
            return 0L;
        }

        @Override
        public long length(String path) throws RemoteException {
            return 0L;
        }

        @Override
        public IOResult createNewFile(String path) throws RemoteException {
            return null;
        }

        @Override
        public boolean delete(String path) throws RemoteException {
            return false;
        }

        @Override
        public String[] list(String path) throws RemoteException {
            return null;
        }

        @Override
        public boolean mkdir(String path) throws RemoteException {
            return false;
        }

        @Override
        public boolean mkdirs(String path) throws RemoteException {
            return false;
        }

        @Override
        public boolean renameTo(String path, String dest) throws RemoteException {
            return false;
        }

        @Override
        public boolean setLastModified(String path, long time) throws RemoteException {
            return false;
        }

        @Override
        public boolean setReadOnly(String path) throws RemoteException {
            return false;
        }

        @Override
        public boolean setWritable(String path, boolean writable, boolean ownerOnly) throws RemoteException {
            return false;
        }

        @Override
        public boolean setReadable(String path, boolean readable, boolean ownerOnly) throws RemoteException {
            return false;
        }

        @Override
        public boolean setExecutable(String path, boolean executable, boolean ownerOnly) throws RemoteException {
            return false;
        }

        @Override
        public boolean checkAccess(String path, int access) throws RemoteException {
            return false;
        }

        @Override
        public long getTotalSpace(String path) throws RemoteException {
            return 0L;
        }

        @Override
        public long getFreeSpace(String path) throws RemoteException {
            return 0L;
        }

        @Override
        public long getUsableSpace(String path) throws RemoteException {
            return 0L;
        }

        @Override
        public int getMode(String path) throws RemoteException {
            return 0;
        }

        @Override
        public IOResult createLink(String link, String target, boolean soft) throws RemoteException {
            return null;
        }

        @Override
        public void register(IBinder client) throws RemoteException {
        }

        @Override
        public IOResult openChannel(String path, int mode, String fifo) throws RemoteException {
            return null;
        }

        @Override
        public IOResult openReadStream(String path, ParcelFileDescriptor fd) throws RemoteException {
            return null;
        }

        @Override
        public IOResult openWriteStream(String path, ParcelFileDescriptor fd, boolean append) throws RemoteException {
            return null;
        }

        @Override
        public void close(int handle) throws RemoteException {
        }

        @Override
        public IOResult pread(int handle, int len, long offset) throws RemoteException {
            return null;
        }

        @Override
        public IOResult pwrite(int handle, int len, long offset) throws RemoteException {
            return null;
        }

        @Override
        public IOResult lseek(int handle, long offset, int whence) throws RemoteException {
            return null;
        }

        @Override
        public IOResult size(int handle) throws RemoteException {
            return null;
        }

        @Override
        public IOResult ftruncate(int handle, long length) throws RemoteException {
            return null;
        }

        @Override
        public IOResult sync(int handle, boolean metadata) throws RemoteException {
            return null;
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

