/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.topjohnwu.superuser.nio.ExtendedFile;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;

abstract class FileImpl<T extends ExtendedFile>
extends ExtendedFile {
    protected FileImpl(String pathname) {
        super(pathname);
    }

    protected FileImpl(String parent, String child) {
        super(parent, child);
    }

    protected abstract T create(String var1);

    protected abstract T[] createArray(int var1);

    @NonNull
    public abstract T getChildFile(String var1);

    @NonNull
    public T getAbsoluteFile() {
        return this.create(this.getAbsolutePath());
    }

    @NonNull
    public T getCanonicalFile() throws IOException {
        return this.create(this.getCanonicalPath());
    }

    @Nullable
    public T getParentFile() {
        return this.create(this.getParent());
    }

    @Nullable
    public T[] listFiles() {
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        ExtendedFile[] fs = this.createArray(n);
        for (int i = 0; i < n; ++i) {
            fs[i] = this.getChildFile(ss[i]);
        }
        return fs;
    }

    @Nullable
    public T[] listFiles(@Nullable FilenameFilter filter) {
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        ArrayList<T> files = new ArrayList<T>();
        for (String s : ss) {
            if (filter != null && !filter.accept(this, s)) continue;
            files.add(this.getChildFile(s));
        }
        return files.toArray(this.createArray(0));
    }

    @Nullable
    public T[] listFiles(@Nullable FileFilter filter) {
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        ArrayList<T> files = new ArrayList<T>();
        for (String s : ss) {
            T f = this.getChildFile(s);
            if (filter != null && !filter.accept((File)f)) continue;
            files.add(f);
        }
        return files.toArray(this.createArray(0));
    }
}

