/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.io;

import androidx.annotation.NonNull;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.internal.Utils;
import com.topjohnwu.superuser.io.SuFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

public final class SuFileOutputStream {
    @NonNull
    public static OutputStream open(@NonNull String path) throws FileNotFoundException {
        return SuFileOutputStream.open(new File(path), false);
    }

    @NonNull
    public static OutputStream open(@NonNull String path, boolean append) throws FileNotFoundException {
        return SuFileOutputStream.open(new File(path), append);
    }

    @NonNull
    public static OutputStream open(@NonNull File file) throws FileNotFoundException {
        return SuFileOutputStream.open(file, false);
    }

    @NonNull
    public static OutputStream open(@NonNull File file, boolean append) throws FileNotFoundException {
        if (file instanceof SuFile) {
            return IOFactory.fifoOut((SuFile)((Object)file), append);
        }
        try {
            return new FileOutputStream(file, append);
        }
        catch (FileNotFoundException e) {
            if (!Utils.isMainShellRoot()) {
                throw e;
            }
            return IOFactory.fifoOut(new SuFile(file), append);
        }
    }

    private SuFileOutputStream() {
    }
}

