/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.io;

import androidx.annotation.NonNull;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.internal.Utils;
import com.topjohnwu.superuser.io.SuFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public final class SuFileInputStream {
    @NonNull
    public static InputStream open(@NonNull String path) throws FileNotFoundException {
        return SuFileInputStream.open(new File(path));
    }

    @NonNull
    public static InputStream open(@NonNull File file) throws FileNotFoundException {
        if (file instanceof SuFile) {
            return IOFactory.fifoIn((SuFile)((Object)file));
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            if (!Utils.isMainShellRoot()) {
                throw e;
            }
            return IOFactory.fifoIn(new SuFile(file));
        }
    }

    private SuFileInputStream() {
    }
}

