/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import androidx.annotation.RestrictTo;
import com.topjohnwu.superuser.internal.RAFWrapper;
import com.topjohnwu.superuser.internal.ShellIO;
import com.topjohnwu.superuser.internal.ShellPipeStream;
import com.topjohnwu.superuser.io.SuFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class IOFactory {
    static final byte[] JUNK = new byte[1];

    private IOFactory() {
    }

    public static ShellIO shellIO(SuFile file, String mode) throws FileNotFoundException {
        switch (mode) {
            case "r": {
                break;
            }
            case "rw": 
            case "rws": 
            case "rwd": {
                mode = "rw";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
        }
        return ShellIO.get(file, mode);
    }

    public static RAFWrapper raf(File file, String mode) throws FileNotFoundException {
        return new RAFWrapper(file, mode);
    }

    public static InputStream fifoIn(SuFile file) throws FileNotFoundException {
        return ShellPipeStream.openReadStream(file);
    }

    public static OutputStream fifoOut(SuFile file, boolean append) throws FileNotFoundException {
        return ShellPipeStream.openWriteStream(file, append);
    }
}

