/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.io;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.ShellUtils;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.internal.Utils;
import com.topjohnwu.superuser.nio.ExtendedFile;
import com.topjohnwu.superuser.nio.FileSystemManager;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;

public class SuFile
extends ExtendedFile {
    private final String escapedPath = ShellUtils.escapedString((String)this.getPath());
    private Shell mShell;

    public static ExtendedFile open(String pathname) {
        return Utils.isMainShellRoot() ? new SuFile(pathname) : FileSystemManager.getLocal().getFile(pathname);
    }

    public static ExtendedFile open(String parent, String child) {
        return Utils.isMainShellRoot() ? new SuFile(parent, child) : FileSystemManager.getLocal().getFile(parent, child);
    }

    public static ExtendedFile open(File parent, String child) {
        return Utils.isMainShellRoot() ? new SuFile(parent, child) : FileSystemManager.getLocal().getFile(parent.getPath(), child);
    }

    public static ExtendedFile open(URI uri) {
        return Utils.isMainShellRoot() ? new SuFile(uri) : FileSystemManager.getLocal().getFile(new File(uri).getPath());
    }

    SuFile(@NonNull File file) {
        super(file.getAbsolutePath());
    }

    public SuFile(String pathname) {
        this(new File(pathname));
    }

    public SuFile(String parent, String child) {
        this(new File(parent, child));
    }

    public SuFile(File parent, String child) {
        this(parent.getAbsolutePath(), child);
    }

    public SuFile(URI uri) {
        this(new File(uri));
    }

    private SuFile create(String path) {
        SuFile s = new SuFile(path);
        s.mShell = this.mShell;
        return s;
    }

    @NonNull
    public SuFile getChildFile(String name) {
        SuFile s = new SuFile((File)((Object)this), name);
        s.mShell = this.mShell;
        return s;
    }

    private String cmd(String c) {
        return ShellUtils.fastCmd((Shell)this.getShell(), (String[])new String[]{c.replace("@@", this.escapedPath)});
    }

    private boolean cmdBool(String c) {
        return ShellUtils.fastCmdResult((Shell)this.getShell(), (String[])new String[]{c.replace("@@", this.escapedPath)});
    }

    public void setShell(Shell shell) {
        this.mShell = shell;
    }

    public Shell getShell() {
        return this.mShell == null ? Shell.getShell() : this.mShell;
    }

    @NonNull
    public String getEscapedPath() {
        return this.escapedPath;
    }

    public boolean canExecute() {
        return this.cmdBool("[ -x @@ ]");
    }

    public boolean canRead() {
        return this.cmdBool("[ -r @@ ]");
    }

    public boolean canWrite() {
        return this.cmdBool("[ -w @@ ]");
    }

    public boolean createNewFile() {
        return this.cmdBool("[ ! -e @@ ] && echo -n > @@");
    }

    public boolean createNewLink(String existing) {
        existing = ShellUtils.escapedString((String)existing);
        return this.cmdBool("[ ! -d " + existing + " ] && ln @@ " + existing);
    }

    public boolean createNewSymlink(String target) {
        target = ShellUtils.escapedString((String)target);
        return this.cmdBool("[ ! -d " + target + " ] && ln -s @@ " + target);
    }

    public boolean delete() {
        return this.cmdBool("rm -f @@ || rmdir -f @@");
    }

    public boolean deleteRecursive() {
        return this.cmdBool("rm -rf @@");
    }

    public boolean clear() {
        return this.cmdBool("echo -n > @@");
    }

    public void deleteOnExit() {
        throw new UnsupportedOperationException("Unsupported SuFile operation");
    }

    public boolean exists() {
        return this.cmdBool("[ -e @@ ]");
    }

    @NonNull
    public String getAbsolutePath() {
        return this.getPath();
    }

    @NonNull
    public SuFile getAbsoluteFile() {
        return this;
    }

    @NonNull
    public String getCanonicalPath() {
        String path = this.cmd("readlink -f @@");
        return path.isEmpty() ? this.getPath() : path;
    }

    @NonNull
    public SuFile getCanonicalFile() {
        return this.create(this.getCanonicalPath());
    }

    public SuFile getParentFile() {
        String parent = this.getParent();
        return parent == null ? null : this.create(parent);
    }

    private long statFS(String fmt) {
        String[] res = this.cmd("stat -fc '%S " + fmt + "' @@").split(" ");
        if (res.length != 2) {
            return Long.MAX_VALUE;
        }
        try {
            return Long.parseLong(res[0]) * Long.parseLong(res[1]);
        }
        catch (NumberFormatException e) {
            return Long.MAX_VALUE;
        }
    }

    public long getFreeSpace() {
        return this.statFS("%f");
    }

    public long getTotalSpace() {
        return this.statFS("%b");
    }

    public long getUsableSpace() {
        return this.statFS("%a");
    }

    public boolean isDirectory() {
        return this.cmdBool("[ -d @@ ]");
    }

    public boolean isFile() {
        return this.cmdBool("[ -f @@ ]");
    }

    public boolean isBlock() {
        return this.cmdBool("[ -b @@ ]");
    }

    public boolean isCharacter() {
        return this.cmdBool("[ -c @@ ]");
    }

    public boolean isSymlink() {
        return this.cmdBool("[ -L @@ ]");
    }

    public boolean isNamedPipe() {
        return this.cmdBool("[ -p @@ ]");
    }

    public boolean isSocket() {
        return this.cmdBool("[ -S @@ ]");
    }

    public long lastModified() {
        try {
            return Long.parseLong(this.cmd("stat -c '%Y' @@")) * 1000L;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public long length() {
        try {
            return Long.parseLong(this.cmd("stat -c '%s' @@"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public boolean mkdir() {
        return this.cmdBool("mkdir @@");
    }

    public boolean mkdirs() {
        return this.cmdBool("mkdir -p @@");
    }

    public boolean renameTo(File dest) {
        String cmd = "mv -f " + this.escapedPath + " " + ShellUtils.escapedString((String)dest.getAbsolutePath());
        return ShellUtils.fastCmdResult((Shell)this.getShell(), (String[])new String[]{cmd});
    }

    private boolean setPerms(boolean set, boolean ownerOnly, int b) {
        char[] perms = this.cmd("stat -c '%a' @@").toCharArray();
        if (perms.length != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            int perm = perms[i] - 48;
            perm = set && (!ownerOnly || i == 0) ? (perm |= b) : (perm &= ~b);
            perms[i] = (char)(perm + 48);
        }
        return this.cmdBool("chmod " + new String(perms) + " @@");
    }

    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        return this.setPerms(executable, ownerOnly, 1);
    }

    public boolean setReadable(boolean readable, boolean ownerOnly) {
        return this.setPerms(readable, ownerOnly, 4);
    }

    public boolean setWritable(boolean writable, boolean ownerOnly) {
        return this.setPerms(writable, ownerOnly, 2);
    }

    public boolean setReadOnly() {
        return this.setWritable(false, false) && this.setExecutable(false, false);
    }

    public boolean setLastModified(long time) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm", Locale.US);
        String date = df.format(new Date(time));
        return this.cmdBool("[ -e @@ ] && touch -t " + date + " @@");
    }

    public String[] list() {
        return this.list(null);
    }

    public String[] list(FilenameFilter filter) {
        if (!this.isDirectory()) {
            return null;
        }
        String cmd = "ls -a " + this.escapedPath;
        List out = this.getShell().newJob().add(new String[]{cmd}).to(new LinkedList(), null).exec().getOut();
        ListIterator it = out.listIterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!name.equals(".") && !name.equals("..") && (filter == null || filter.accept((File)((Object)this), name))) continue;
            it.remove();
        }
        return out.toArray(new String[0]);
    }

    @Nullable
    public SuFile[] listFiles() {
        if (!this.isDirectory()) {
            return null;
        }
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        SuFile[] fs = new SuFile[n];
        for (int i = 0; i < n; ++i) {
            fs[i] = this.getChildFile(ss[i]);
        }
        return fs;
    }

    @Nullable
    public SuFile[] listFiles(FilenameFilter filter) {
        if (!this.isDirectory()) {
            return null;
        }
        String[] ss = this.list(filter);
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        SuFile[] fs = new SuFile[n];
        for (int i = 0; i < n; ++i) {
            fs[i] = this.getChildFile(ss[i]);
        }
        return fs;
    }

    @Nullable
    public SuFile[] listFiles(FileFilter filter) {
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        ArrayList<SuFile> files = new ArrayList<SuFile>();
        for (String s : ss) {
            SuFile f = this.getChildFile(s);
            if (filter != null && !filter.accept((File)((Object)f))) continue;
            files.add(f);
        }
        return files.toArray(new SuFile[0]);
    }

    @NonNull
    public InputStream newInputStream() throws IOException {
        return IOFactory.fifoIn(this);
    }

    @NonNull
    public OutputStream newOutputStream(boolean append) throws IOException {
        return IOFactory.fifoOut(this, append);
    }
}

