/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import com.topjohnwu.superuser.io.SuFile;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;

abstract class BaseSuOutputStream
extends FilterOutputStream {
    protected boolean append;

    BaseSuOutputStream(SuFile file, boolean append) throws FileNotFoundException {
        super(null);
        this.append = append;
        if (!this.checkFile(file)) {
            throw new FileNotFoundException("No such file or directory");
        }
    }

    private boolean checkFile(SuFile file) {
        if (file.isDirectory()) {
            return false;
        }
        if (file.isBlock() || file.isCharacter()) {
            this.append = false;
            return true;
        }
        if (this.append) {
            return file.canWrite() || file.createNewFile();
        }
        return file.clear();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    protected final String op() {
        return this.append ? " >> " : " > ";
    }
}

