/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import androidx.annotation.NonNull;
import com.topjohnwu.superuser.ShellUtils;
import com.topjohnwu.superuser.internal.ShellIO;
import com.topjohnwu.superuser.io.SuFile;
import java.io.FileNotFoundException;
import java.io.IOException;

class ShellBlockIO
extends ShellIO {
    private final long blockSize;

    ShellBlockIO(SuFile file, String mode) throws FileNotFoundException {
        super(file, mode);
        long bs;
        try {
            bs = Long.parseLong(ShellUtils.fastCmd((String[])new String[]{"blockdev --getsize64 " + file.getEscapedPath()}));
        }
        catch (NumberFormatException e) {
            bs = Long.MAX_VALUE;
        }
        this.blockSize = bs;
    }

    @Override
    protected String getConv() {
        return "";
    }

    @Override
    protected int alignedRead(byte[] b, int _off, int count, int skip, int bs) throws IOException {
        if ((long)(skip * bs) >= this.blockSize) {
            this.eof = true;
            return -1;
        }
        return super.alignedRead(b, _off, count, skip, bs);
    }

    @Override
    public void write(@NonNull byte[] b, int off, int len) throws IOException {
        if (this.fileOff + (long)len > this.blockSize) {
            throw new IOException("Cannot write pass block size");
        }
        super.write(b, off, len);
    }

    @Override
    void streamWrite(byte[] b, int off, int len) throws IOException {
        this.write(b, off, len);
    }

    @Override
    public long length() {
        return this.blockSize;
    }

    @Override
    public void setLength(long newLength) {
        throw new UnsupportedOperationException("Block devices have fixed sizes");
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos > this.blockSize) {
            throw new IOException("Cannot seek pass block size");
        }
        this.fileOff = pos;
    }
}

