/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.content.Context;
import android.system.ErrnoException;
import android.system.Os;
import androidx.annotation.RequiresApi;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.internal.BaseSuOutputStream;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.internal.Utils;
import com.topjohnwu.superuser.io.SuFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@RequiresApi(value=21)
class FifoOutputStream
extends BaseSuOutputStream {
    static final int FIFO_TIMEOUT = 250;
    static final String TAG = "FIFOIO";
    static final byte[] END_CMD = "echo\n".getBytes(Utils.UTF_8);
    private final File fifo;

    FifoOutputStream(SuFile file, boolean append) throws FileNotFoundException {
        super(file, append);
        Context c = Utils.getDeContext((Context)Utils.getContext());
        this.fifo = new File(c.getCacheDir(), UUID.randomUUID().toString());
        try {
            Os.mkfifo((String)this.fifo.getPath(), (int)384);
        }
        catch (ErrnoException e) {
            throw (FileNotFoundException)new FileNotFoundException("Failed to mkfifo").initCause(e);
        }
        this.fifo.deleteOnExit();
        try {
            this.openStream(file);
        }
        catch (Exception e) {
            this.fifo.delete();
            throw e;
        }
    }

    private void openStream(SuFile file) throws FileNotFoundException {
        try {
            Shell.getShell().execTask((in, out, err) -> {
                String cmd = "cat " + this.fifo + this.op() + file + " 2>/dev/null &\n";
                Utils.log((String)TAG, (Object)cmd);
                in.write(cmd.getBytes(Utils.UTF_8));
                in.flush();
                in.write(END_CMD);
                in.flush();
                out.read(IOFactory.JUNK);
            });
        }
        catch (IOException e) {
            throw (FileNotFoundException)new FileNotFoundException("Error running root command").initCause(e);
        }
        Future<OutputStream> stream = Shell.EXECUTOR.submit(() -> new FileOutputStream(this.fifo));
        try {
            this.out = stream.get(250L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            throw (FileNotFoundException)new FileNotFoundException("Cannot open fifo").initCause(e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.fifo.delete();
    }
}

