/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.io;

import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.io.SuFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class SuFileOutputStream
extends BufferedOutputStream {
    public SuFileOutputStream(String path) throws FileNotFoundException {
        this(path, false);
    }

    public SuFileOutputStream(String path, boolean append) throws FileNotFoundException {
        this(new File(path), append);
    }

    public SuFileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    private static OutputStream getOut(File file, boolean append) throws FileNotFoundException {
        if (file instanceof SuFile) {
            return IOFactory.createShellOutputStream((SuFile)file, append);
        }
        try {
            return new FileOutputStream(file, append);
        }
        catch (FileNotFoundException e) {
            if (!Shell.rootAccess()) {
                throw e;
            }
            return IOFactory.createShellOutputStream(new SuFile(file), append);
        }
    }

    public SuFileOutputStream(File file, boolean append) throws FileNotFoundException {
        super(SuFileOutputStream.getOut(file, append), 0x400000);
    }
}

