/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import androidx.annotation.NonNull;
import com.topjohnwu.superuser.internal.ShellIO;
import com.topjohnwu.superuser.io.SuFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class ShellInputStream
extends InputStream {
    private ShellIO io;
    private byte[] buf;
    private int count = 0;
    private int pos = 0;
    private int markPos = -1;
    private int markBufCount = 0;
    private int markBufSize;
    private byte[] markBuf;

    ShellInputStream(SuFile file) throws FileNotFoundException {
        this.io = ShellIO.get(file, "r");
        this.buf = new byte[0x400000];
    }

    @Override
    public int read() throws IOException {
        byte[] BYTE = new byte[1];
        if (this.read(BYTE) != 1) {
            return -1;
        }
        return BYTE[0] & 0xFF;
    }

    @Override
    public int read(@NonNull byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NonNull byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.count < 0) {
            return -1;
        }
        return this.read0(len, b, off);
    }

    private synchronized int read0(int len, byte[] b, int off) throws IOException {
        int n = 0;
        while (n < len) {
            int size;
            if (this.pos < 0) {
                int pos = ~this.pos;
                int size2 = Math.min(this.markBufCount - pos, len - n);
                if (b != null) {
                    System.arraycopy(this.markBuf, pos, b, off + n, size2);
                }
                n += size2;
                if ((pos += size2) == this.markBufCount) {
                    this.pos = 0;
                    continue;
                }
                this.pos = ~pos;
                continue;
            }
            if (this.pos >= this.count) {
                if (this.markPos >= 0) {
                    size = this.count - this.markPos;
                    if (this.markBufSize - this.markBufCount < size) {
                        this.markBuf = null;
                        this.markBufCount = 0;
                        this.markPos = -1;
                    } else if (this.markBuf == null) {
                        this.markBuf = new byte[this.markBufSize];
                        this.markBufCount = 0;
                    }
                    if (this.markBuf != null) {
                        System.arraycopy(this.buf, this.markPos, this.markBuf, this.markBufCount, size);
                        this.markBufCount += size;
                        this.markPos = 0;
                    }
                }
                this.pos = 0;
                this.count = this.io.streamRead(this.buf);
                if (this.count < 0) {
                    return n == 0 ? -1 : n;
                }
            }
            size = Math.min(this.count - this.pos, len - n);
            if (b != null) {
                System.arraycopy(this.buf, this.pos, b, off + n, size);
            }
            n += size;
            this.pos += size;
        }
        return n;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markPos = this.pos;
        this.markBufCount = 0;
        this.markBuf = null;
        int remain = this.count - this.pos;
        this.markBufSize = readlimit <= remain ? 0 : remain + (readlimit - remain) / this.buf.length * this.buf.length;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markPos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markBuf == null ? this.markPos : -1;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.count < 0) {
            return 0;
        }
        if (this.pos >= this.count) {
            this.read0(1, null, 0);
            if (this.count < 0) {
                return 0;
            }
            --this.pos;
        }
        if (this.pos < 0) {
            return this.markBufCount - ~this.pos + this.count;
        }
        return this.count - this.pos;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        return Math.max(this.read0((int)n, null, 0), 0);
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

