/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import androidx.annotation.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

interface DataOutputImpl
extends DataOutput {
    @Override
    default public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)(b & 0xFF)};
        this.write(buf);
    }

    @Override
    default public void write(@NonNull byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    default public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    default public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    default public void writeShort(int v) throws IOException {
        byte[] b = new byte[]{(byte)(v >>> 8), (byte)(v >>> 0)};
        this.write(b);
    }

    @Override
    default public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    default public void writeInt(int v) throws IOException {
        byte[] b = new byte[]{(byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        this.write(b);
    }

    @Override
    default public void writeLong(long v) throws IOException {
        byte[] b = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        this.write(b);
    }

    @Override
    default public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    default public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    default public void writeBytes(@NonNull String s) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buf);
        out.writeBytes(s);
        this.write(buf.toByteArray());
    }

    @Override
    default public void writeChars(@NonNull String s) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buf);
        out.writeChars(s);
        this.write(buf.toByteArray());
    }

    @Override
    default public void writeUTF(@NonNull String s) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buf);
        out.writeUTF(s);
        this.write(buf.toByteArray());
    }
}

