/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import androidx.annotation.NonNull;
import com.topjohnwu.superuser.internal.ShellFile;
import com.topjohnwu.superuser.internal.ShellFileIO;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

class ShellOutputStream
extends OutputStream {
    private ShellFileIO io;

    ShellOutputStream(ShellFile file, boolean append) throws FileNotFoundException {
        this.io = new ShellFileIO(file, append ? "rw" : "w");
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)(b & 0xFF)};
        this.write(buf);
    }

    @Override
    public void write(@NonNull byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(@NonNull byte[] b, int off, int len) throws IOException {
        this.io.append(b, off, len);
    }
}

