/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.database;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.tonyodev.fetch2.PrioritySort;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DownloadDatabase;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.database.FetchDatabaseManager;
import com.tonyodev.fetch2.database.FetchDatabaseManagerImpl$WhenMappings;
import com.tonyodev.fetch2.database.migration.Migration;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.LiveSettings;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2core.DefaultStorageResolver;
import com.tonyodev.fetch2core.Extras;
import com.tonyodev.fetch2core.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u0002H\u0016J\u0016\u0010(\u001a\u00020'2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020+H\u0016J\b\u0010,\u001a\u00020'H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020+H\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010\u00022\u0006\u0010.\u001a\u00020/H\u0016J\u001e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020+2\f\u00100\u001a\b\u0012\u0004\u0012\u00020/0+H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020/0+H\u0016J\u0012\u00102\u001a\u0004\u0018\u00010\u00022\u0006\u00103\u001a\u00020\u0006H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u00020+2\u0006\u00105\u001a\u00020/H\u0016J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020+2\u0006\u00107\u001a\u000208H\u0016J\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020+2\f\u00109\u001a\b\u0012\u0004\u0012\u0002080+H\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00020+2\u0006\u0010;\u001a\u00020<H\u0016J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00020+2\u0006\u0010>\u001a\u00020\u0006H\u0016J$\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00020+2\u0006\u0010@\u001a\u00020/2\f\u00109\u001a\b\u0012\u0004\u0012\u0002080+H\u0016J\b\u0010A\u001a\u00020\u0002H\u0016J\u0010\u0010B\u001a\u00020<2\u0006\u0010C\u001a\u00020\u000fH\u0016J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00020+2\u0006\u0010E\u001a\u00020FH\u0016J\u001c\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000f0H2\u0006\u0010)\u001a\u00020\u0002H\u0016J(\u0010G\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000f0H0+2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020+H\u0016J\u0010\u0010I\u001a\u00020'2\u0006\u0010)\u001a\u00020\u0002H\u0002J\u0018\u0010J\u001a\u00020'2\u0006\u0010)\u001a\u00020\u00022\u0006\u0010K\u001a\u00020\u000fH\u0002J\u0010\u0010L\u001a\u00020'2\u0006\u0010)\u001a\u00020\u0002H\u0002J\u001c\u0010M\u001a\u00020\u000f2\b\u0010)\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010N\u001a\u00020\u000fH\u0002J \u0010M\u001a\u00020\u000f2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00020+2\b\b\u0002\u0010K\u001a\u00020\u000fH\u0002J\b\u0010P\u001a\u00020'H\u0016J\b\u0010Q\u001a\u00020'H\u0002J\u0010\u0010R\u001a\u00020'2\u0006\u0010)\u001a\u00020\u0002H\u0016J\u0016\u0010R\u001a\u00020'2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020+H\u0016J\u001a\u0010S\u001a\u0004\u0018\u00010\u00022\u0006\u0010.\u001a\u00020/2\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020'2\u0006\u0010)\u001a\u00020\u0002H\u0016R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/tonyodev/fetch2/database/FetchDatabaseManagerImpl;", "Lcom/tonyodev/fetch2/database/FetchDatabaseManager;", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "context", "Landroid/content/Context;", "namespace", "", "logger", "Lcom/tonyodev/fetch2core/Logger;", "migrations", "", "Lcom/tonyodev/fetch2/database/migration/Migration;", "liveSettings", "Lcom/tonyodev/fetch2/fetch/LiveSettings;", "fileExistChecksEnabled", "", "defaultStorageResolver", "Lcom/tonyodev/fetch2core/DefaultStorageResolver;", "(Landroid/content/Context;Ljava/lang/String;Lcom/tonyodev/fetch2core/Logger;[Lcom/tonyodev/fetch2/database/migration/Migration;Lcom/tonyodev/fetch2/fetch/LiveSettings;ZLcom/tonyodev/fetch2core/DefaultStorageResolver;)V", "closed", "database", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "delegate", "Lcom/tonyodev/fetch2/database/FetchDatabaseManager$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/database/FetchDatabaseManager$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/database/FetchDatabaseManager$Delegate;)V", "isClosed", "()Z", "getLogger", "()Lcom/tonyodev/fetch2core/Logger;", "pendingCountIncludeAddedQuery", "pendingCountQuery", "requestDatabase", "Lcom/tonyodev/fetch2/database/DownloadDatabase;", "updatedDownloadsList", "", "close", "", "delete", "downloadInfo", "downloadInfoList", "", "deleteAll", "get", "id", "", "ids", "getAllGroupIds", "getByFile", "file", "getByGroup", "group", "getByStatus", "status", "Lcom/tonyodev/fetch2/Status;", "statuses", "getDownloadsByRequestIdentifier", "identifier", "", "getDownloadsByTag", "tag", "getDownloadsInGroupWithStatus", "groupId", "getNewDownloadInfoInstance", "getPendingCount", "includeAddedDownloads", "getPendingDownloadsSorted", "prioritySort", "Lcom/tonyodev/fetch2/PrioritySort;", "insert", "Lkotlin/Pair;", "onCompleted", "onDownloading", "firstEntry", "onPaused", "sanitize", "initializing", "downloads", "sanitizeOnFirstEntry", "throwExceptionIfClosed", "update", "updateExtras", "extras", "Lcom/tonyodev/fetch2core/Extras;", "updateFileBytesInfoAndStatusOnly", "fetch2_release"})
public final class FetchDatabaseManagerImpl
implements FetchDatabaseManager<DownloadInfo> {
    private volatile boolean closed;
    @Nullable
    private FetchDatabaseManager.Delegate<DownloadInfo> delegate;
    private final DownloadDatabase requestDatabase;
    private final SupportSQLiteDatabase database;
    private final String pendingCountQuery;
    private final String pendingCountIncludeAddedQuery;
    private final List<DownloadInfo> updatedDownloadsList;
    private final String namespace;
    @NotNull
    private final Logger logger;
    private final LiveSettings liveSettings;
    private final boolean fileExistChecksEnabled;
    private final DefaultStorageResolver defaultStorageResolver;

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    @Nullable
    public FetchDatabaseManager.Delegate<DownloadInfo> getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable FetchDatabaseManager.Delegate<DownloadInfo> delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Pair<DownloadInfo, Boolean> insert(@NotNull DownloadInfo downloadInfo2) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo2, (String)"downloadInfo");
        this.throwExceptionIfClosed();
        long row = this.requestDatabase.requestDao().insert(downloadInfo2);
        return new Pair((Object)downloadInfo2, (Object)this.requestDatabase.wasRowInserted(row));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<DownloadInfo, Boolean>> insert(@NotNull List<? extends DownloadInfo> downloadInfoList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(downloadInfoList, (String)"downloadInfoList");
        this.throwExceptionIfClosed();
        List<Long> rowsList = this.requestDatabase.requestDao().insert(downloadInfoList);
        Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)rowsList);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = new Pair((Object)downloadInfoList.get((int)it), (Object)this.requestDatabase.wasRowInserted(((Number)rowsList.get((int)it)).longValue()));
            collection.add(pair);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void delete(@NotNull DownloadInfo downloadInfo2) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo2, (String)"downloadInfo");
        this.throwExceptionIfClosed();
        this.requestDatabase.requestDao().delete(downloadInfo2);
    }

    @Override
    public void delete(@NotNull List<? extends DownloadInfo> downloadInfoList) {
        Intrinsics.checkParameterIsNotNull(downloadInfoList, (String)"downloadInfoList");
        this.throwExceptionIfClosed();
        this.requestDatabase.requestDao().delete(downloadInfoList);
    }

    @Override
    public void deleteAll() {
        this.throwExceptionIfClosed();
        this.requestDatabase.requestDao().deleteAll();
        this.getLogger().d("Cleared Database " + this.namespace);
    }

    @Override
    public void update(@NotNull DownloadInfo downloadInfo2) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo2, (String)"downloadInfo");
        this.throwExceptionIfClosed();
        this.requestDatabase.requestDao().update(downloadInfo2);
    }

    @Override
    public void update(@NotNull List<? extends DownloadInfo> downloadInfoList) {
        Intrinsics.checkParameterIsNotNull(downloadInfoList, (String)"downloadInfoList");
        this.throwExceptionIfClosed();
        this.requestDatabase.requestDao().update(downloadInfoList);
    }

    @Override
    public void updateFileBytesInfoAndStatusOnly(@NotNull DownloadInfo downloadInfo2) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo2, (String)"downloadInfo");
        this.throwExceptionIfClosed();
        try {
            this.database.beginTransaction();
            this.database.execSQL("UPDATE requests SET _written_bytes = ?, _total_bytes = ?, _status = ? WHERE _id = ?", new Object[]{downloadInfo2.getDownloaded(), downloadInfo2.getTotal(), downloadInfo2.getStatus().getValue(), downloadInfo2.getId()});
            this.database.setTransactionSuccessful();
        }
        catch (SQLiteException e) {
            this.getLogger().e("DatabaseManager exception", (Throwable)e);
        }
        try {
            this.database.endTransaction();
        }
        catch (SQLiteException e) {
            this.getLogger().e("DatabaseManager exception", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public DownloadInfo updateExtras(int id, @NotNull Extras extras) {
        Intrinsics.checkParameterIsNotNull((Object)extras, (String)"extras");
        this.throwExceptionIfClosed();
        this.database.beginTransaction();
        this.database.execSQL("UPDATE requests SET _extras = '?' WHERE _id = ?", new Object[]{extras.toJSONString(), id});
        this.database.setTransactionSuccessful();
        this.database.endTransaction();
        DownloadInfo download = this.requestDatabase.requestDao().get(id);
        FetchDatabaseManagerImpl.sanitize$default(this, download, false, 2, null);
        return download;
    }

    @Override
    @NotNull
    public List<DownloadInfo> get() {
        this.throwExceptionIfClosed();
        List<DownloadInfo> downloads = this.requestDatabase.requestDao().get();
        FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null);
        return downloads;
    }

    @Override
    @Nullable
    public DownloadInfo get(int id) {
        this.throwExceptionIfClosed();
        DownloadInfo download = this.requestDatabase.requestDao().get(id);
        FetchDatabaseManagerImpl.sanitize$default(this, download, false, 2, null);
        return download;
    }

    @Override
    @NotNull
    public List<DownloadInfo> get(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        this.throwExceptionIfClosed();
        List<DownloadInfo> downloads = this.requestDatabase.requestDao().get(ids);
        FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null);
        return downloads;
    }

    @Override
    @Nullable
    public DownloadInfo getByFile(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.throwExceptionIfClosed();
        DownloadInfo download = this.requestDatabase.requestDao().getByFile(file);
        FetchDatabaseManagerImpl.sanitize$default(this, download, false, 2, null);
        return download;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getByStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        this.throwExceptionIfClosed();
        List downloads = this.requestDatabase.requestDao().getByStatus(status);
        if (FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = downloads;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DownloadInfo it = (DownloadInfo)element$iv$iv;
                boolean bl = false;
                if (!(it.getStatus() == status)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            downloads = (List)destination$iv$iv;
        }
        return downloads;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getByStatus(@NotNull List<? extends Status> statuses) {
        Intrinsics.checkParameterIsNotNull(statuses, (String)"statuses");
        this.throwExceptionIfClosed();
        List downloads = this.requestDatabase.requestDao().getByStatus(statuses);
        if (FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = downloads;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DownloadInfo it = (DownloadInfo)element$iv$iv;
                boolean bl = false;
                if (!statuses.contains((Object)it.getStatus())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            downloads = (List)destination$iv$iv;
        }
        return downloads;
    }

    @Override
    @NotNull
    public List<DownloadInfo> getByGroup(int group) {
        this.throwExceptionIfClosed();
        List<DownloadInfo> downloads = this.requestDatabase.requestDao().getByGroup(group);
        FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null);
        return downloads;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getDownloadsInGroupWithStatus(int groupId, @NotNull List<? extends Status> statuses) {
        Intrinsics.checkParameterIsNotNull(statuses, (String)"statuses");
        this.throwExceptionIfClosed();
        List downloads = this.requestDatabase.requestDao().getByGroupWithStatus(groupId, statuses);
        if (FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = downloads;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block5: {
                    DownloadInfo download = (DownloadInfo)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = statuses;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Status it = (Status)((Object)element$iv);
                            boolean bl3 = false;
                            if (!(it == download.getStatus())) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            downloads = (List)destination$iv$iv;
        }
        return downloads;
    }

    @Override
    @NotNull
    public List<DownloadInfo> getDownloadsByRequestIdentifier(long identifier) {
        this.throwExceptionIfClosed();
        List<DownloadInfo> downloads = this.requestDatabase.requestDao().getDownloadsByRequestIdentifier(identifier);
        FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null);
        return downloads;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getPendingDownloadsSorted(@NotNull PrioritySort prioritySort) {
        List<Object> downloads;
        Intrinsics.checkParameterIsNotNull((Object)((Object)prioritySort), (String)"prioritySort");
        this.throwExceptionIfClosed();
        List<Object> list = downloads = prioritySort == PrioritySort.ASC ? this.requestDatabase.requestDao().getPendingDownloadsSorted(Status.QUEUED) : this.requestDatabase.requestDao().getPendingDownloadsSortedDesc(Status.QUEUED);
        if (FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = downloads;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DownloadInfo it = (DownloadInfo)element$iv$iv;
                boolean bl = false;
                if (!(it.getStatus() == Status.QUEUED)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            downloads = (List<Object>)destination$iv$iv;
        }
        return downloads;
    }

    @Override
    @NotNull
    public List<Integer> getAllGroupIds() {
        this.throwExceptionIfClosed();
        return this.requestDatabase.requestDao().getAllGroupIds();
    }

    @Override
    @NotNull
    public List<DownloadInfo> getDownloadsByTag(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.throwExceptionIfClosed();
        List<DownloadInfo> downloads = this.requestDatabase.requestDao().getDownloadsByTag(tag);
        FetchDatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null);
        return downloads;
    }

    @Override
    public long getPendingCount(boolean includeAddedDownloads) {
        long l;
        try {
            Cursor cursor;
            String query = includeAddedDownloads ? this.pendingCountIncludeAddedQuery : this.pendingCountQuery;
            Cursor cursor2 = cursor = this.database.query(query);
            long count = cursor2 != null ? (long)cursor2.getCount() : -1L;
            Cursor cursor3 = cursor;
            if (cursor3 != null) {
                cursor3.close();
            }
            l = count;
        }
        catch (Exception e) {
            l = -1L;
        }
        return l;
    }

    @Override
    public void sanitizeOnFirstEntry() {
        this.throwExceptionIfClosed();
        this.liveSettings.execute((Function1<? super LiveSettings, Unit>)((Function1)new Function1<LiveSettings, Unit>(this){
            final /* synthetic */ FetchDatabaseManagerImpl this$0;

            public final void invoke(@NotNull LiveSettings it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (!it.getDidSanitizeDatabaseOnFirstEntry()) {
                    FetchDatabaseManagerImpl.access$sanitize(this.this$0, this.this$0.get(), true);
                    it.setDidSanitizeDatabaseOnFirstEntry(true);
                }
            }
            {
                this.this$0 = fetchDatabaseManagerImpl;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean sanitize(List<? extends DownloadInfo> downloads, boolean firstEntry) {
        this.updatedDownloadsList.clear();
        DownloadInfo downloadInfo2 = null;
        int n = 0;
        int n2 = downloads.size();
        while (n < n2) {
            void i;
            downloadInfo2 = downloads.get((int)i);
            switch (FetchDatabaseManagerImpl$WhenMappings.$EnumSwitchMapping$0[downloadInfo2.getStatus().ordinal()]) {
                case 1: {
                    this.onCompleted(downloadInfo2);
                    break;
                }
                case 2: {
                    this.onDownloading(downloadInfo2, firstEntry);
                    break;
                }
                case 3: 
                case 4: {
                    this.onPaused(downloadInfo2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            ++i;
        }
        int updatedCount = this.updatedDownloadsList.size();
        if (updatedCount > 0) {
            try {
                this.update((List<? extends DownloadInfo>)this.updatedDownloadsList);
            }
            catch (Exception e) {
                this.getLogger().e("Failed to update", (Throwable)e);
            }
        }
        this.updatedDownloadsList.clear();
        return updatedCount > 0;
    }

    static /* synthetic */ boolean sanitize$default(FetchDatabaseManagerImpl fetchDatabaseManagerImpl, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return fetchDatabaseManagerImpl.sanitize(list, bl);
    }

    private final void onPaused(DownloadInfo downloadInfo2) {
        block1: {
            if (downloadInfo2.getDownloaded() <= 0L || !this.fileExistChecksEnabled || this.defaultStorageResolver.fileExists(downloadInfo2.getFile())) break block1;
            downloadInfo2.setDownloaded(0L);
            downloadInfo2.setTotal(-1L);
            downloadInfo2.setError(FetchDefaults.getDefaultNoError());
            this.updatedDownloadsList.add(downloadInfo2);
            FetchDatabaseManager.Delegate<DownloadInfo> delegate = this.getDelegate();
            if (delegate != null) {
                delegate.deleteTempFilesForDownload(downloadInfo2);
            }
        }
    }

    private final void onDownloading(DownloadInfo downloadInfo2, boolean firstEntry) {
        if (firstEntry) {
            Status status = downloadInfo2.getDownloaded() > 0L && downloadInfo2.getTotal() > 0L && downloadInfo2.getDownloaded() >= downloadInfo2.getTotal() ? Status.COMPLETED : Status.QUEUED;
            downloadInfo2.setStatus(status);
            downloadInfo2.setError(FetchDefaults.getDefaultNoError());
            this.updatedDownloadsList.add(downloadInfo2);
        }
    }

    private final void onCompleted(DownloadInfo downloadInfo2) {
        if (downloadInfo2.getTotal() < 1L && downloadInfo2.getDownloaded() > 0L) {
            downloadInfo2.setTotal(downloadInfo2.getDownloaded());
            downloadInfo2.setError(FetchDefaults.getDefaultNoError());
            this.updatedDownloadsList.add(downloadInfo2);
        }
    }

    private final boolean sanitize(DownloadInfo downloadInfo2, boolean initializing) {
        return downloadInfo2 == null ? false : this.sanitize(CollectionsKt.listOf((Object)downloadInfo2), initializing);
    }

    static /* synthetic */ boolean sanitize$default(FetchDatabaseManagerImpl fetchDatabaseManagerImpl, DownloadInfo downloadInfo2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return fetchDatabaseManagerImpl.sanitize(downloadInfo2, bl);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.database.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.requestDatabase.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getLogger().d("Database closed");
    }

    @Override
    @NotNull
    public DownloadInfo getNewDownloadInfoInstance() {
        return new DownloadInfo();
    }

    private final void throwExceptionIfClosed() {
        if (this.closed) {
            throw (Throwable)new FetchException(this.namespace + " database is closed");
        }
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    public FetchDatabaseManagerImpl(@NotNull Context context, @NotNull String namespace, @NotNull Logger logger, @NotNull Migration[] migrations, @NotNull LiveSettings liveSettings, boolean fileExistChecksEnabled, @NotNull DefaultStorageResolver defaultStorageResolver) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)migrations, (String)"migrations");
        Intrinsics.checkParameterIsNotNull((Object)liveSettings, (String)"liveSettings");
        Intrinsics.checkParameterIsNotNull((Object)defaultStorageResolver, (String)"defaultStorageResolver");
        this.namespace = namespace;
        this.logger = logger;
        this.liveSettings = liveSettings;
        this.fileExistChecksEnabled = fileExistChecksEnabled;
        this.defaultStorageResolver = defaultStorageResolver;
        RoomDatabase.Builder builder = Room.databaseBuilder((Context)context, DownloadDatabase.class, (String)(this.namespace + ".db"));
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"Room.databaseBuilder(con\u2026ss.java, \"$namespace.db\")");
        RoomDatabase.Builder builder2 = builder;
        androidx.room.migration.Migration[] migrationArray = migrations;
        builder2.addMigrations(Arrays.copyOf(migrationArray, migrationArray.length));
        RoomDatabase roomDatabase = builder2.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)roomDatabase, (String)"builder.build()");
        this.requestDatabase = (DownloadDatabase)roomDatabase;
        SupportSQLiteOpenHelper supportSQLiteOpenHelper = this.requestDatabase.getOpenHelper();
        Intrinsics.checkExpressionValueIsNotNull((Object)supportSQLiteOpenHelper, (String)"requestDatabase.openHelper");
        SupportSQLiteDatabase supportSQLiteDatabase = supportSQLiteOpenHelper.getWritableDatabase();
        Intrinsics.checkExpressionValueIsNotNull((Object)supportSQLiteDatabase, (String)"requestDatabase.openHelper.writableDatabase");
        this.database = supportSQLiteDatabase;
        this.pendingCountQuery = "SELECT _id FROM requests" + " WHERE _status = '" + Status.QUEUED.getValue() + '\'' + " OR _status = '" + Status.DOWNLOADING.getValue() + '\'';
        this.pendingCountIncludeAddedQuery = "SELECT _id FROM requests" + " WHERE _status = '" + Status.QUEUED.getValue() + '\'' + " OR _status = '" + Status.DOWNLOADING.getValue() + '\'' + " OR _status = '" + Status.ADDED.getValue() + '\'';
        FetchDatabaseManagerImpl fetchDatabaseManagerImpl = this;
        boolean bl = false;
        fetchDatabaseManagerImpl.updatedDownloadsList = list = (List)new ArrayList();
    }

    public static final /* synthetic */ boolean access$sanitize(FetchDatabaseManagerImpl $this, List downloads, boolean firstEntry) {
        return $this.sanitize(downloads, firstEntry);
    }
}

