/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2okhttp;

import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.InterruptMonitor;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\b\u0007\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001f\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0002\u0010$J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020#H\u0016J \u0010(\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020#H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u001eH\u0016R\u001e\u0010\b\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/tonyodev/fetch2okhttp/OkHttpDownloader;", "Lcom/tonyodev/fetch2core/Downloader;", "fileDownloaderType", "Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;", "(Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;)V", "okHttpClient", "Lokhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;)V", "client", "getClient", "()Lokhttp3/OkHttpClient;", "setClient", "(Lokhttp3/OkHttpClient;)V", "connections", "", "Lcom/tonyodev/fetch2core/Downloader$Response;", "Lokhttp3/Response;", "getConnections", "()Ljava/util/Map;", "close", "", "closeResponse", "response", "disconnect", "execute", "request", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "interruptMonitor", "Lcom/tonyodev/fetch2core/InterruptMonitor;", "getDirectoryForFileDownloaderTypeParallel", "", "getFileDownloaderType", "getFileSlicingCount", "", "contentLength", "", "(Lcom/tonyodev/fetch2core/Downloader$ServerRequest;J)Ljava/lang/Integer;", "getRequestOutputStream", "Ljava/io/OutputStream;", "filePointerOffset", "seekOutputStreamToPosition", "outputStream", "verifyContentMD5", "", "md5", "fetch2okhttp_release"})
public class OkHttpDownloader
implements Downloader {
    @NotNull
    private final Map<Downloader.Response, Response> connections;
    @NotNull
    private volatile OkHttpClient client;
    private final Downloader.FileDownloaderType fileDownloaderType;

    @NotNull
    protected final Map<Downloader.Response, Response> getConnections() {
        return this.connections;
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    public final void setClient(@NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"<set-?>");
        this.client = okHttpClient;
    }

    @Nullable
    public Downloader.Response execute(@NotNull Downloader.ServerRequest request, @Nullable InterruptMonitor interruptMonitor) {
        String md5;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Request.Builder okHttpRequestBuilder = new Request.Builder().url(request.getUrl());
        Iterable $receiver$iv = request.getHeaders().entrySet();
        for (Object element$iv : $receiver$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            okHttpRequestBuilder.addHeader((String)it.getKey(), (String)it.getValue());
        }
        Request okHttpRequest = okHttpRequestBuilder.build();
        Response okHttpResponse = this.client.newCall(okHttpRequest).execute();
        int code = okHttpResponse.code();
        Response response = okHttpResponse;
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"okHttpResponse");
        boolean success = response.isSuccessful();
        ResponseBody responseBody = okHttpResponse.body();
        long contentLength = responseBody != null ? responseBody.contentLength() : -1L;
        ResponseBody responseBody2 = okHttpResponse.body();
        InputStream byteStream = responseBody2 != null ? responseBody2.byteStream() : null;
        String string = okHttpResponse.header("Content-MD5");
        if (string == null) {
            string = "";
        }
        String string2 = md5 = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"md5");
        Downloader.Response response2 = new Downloader.Response(code, success, contentLength, byteStream, request, string2);
        Map<Downloader.Response, Response> map = this.connections;
        Response response3 = okHttpResponse;
        map.put(response2, response3);
        return response2;
    }

    public void disconnect(@NotNull Downloader.Response response) {
        Map<Downloader.Response, Response> map;
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Map<Downloader.Response, Response> map2 = map = this.connections;
        if (map2.containsKey(response)) {
            Response response2 = this.connections.get(response);
            if (response2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type okhttp3.Response");
            }
            Response okHttpResponse = response2;
            this.connections.remove(response);
            this.closeResponse(okHttpResponse);
        }
    }

    public void close() {
        Iterable $receiver$iv = this.connections.entrySet();
        for (Object element$iv : $receiver$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            this.closeResponse((Response)it.getValue());
        }
        this.connections.clear();
    }

    private final void closeResponse(Response response) {
        try {
            Response response2 = response;
            if (response2 != null) {
                response2.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public OutputStream getRequestOutputStream(@NotNull Downloader.ServerRequest request, long filePointerOffset) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return null;
    }

    @Nullable
    public Integer getFileSlicingCount(@NotNull Downloader.ServerRequest request, long contentLength) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return null;
    }

    @Nullable
    public String getDirectoryForFileDownloaderTypeParallel(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return null;
    }

    public void seekOutputStreamToPosition(@NotNull Downloader.ServerRequest request, @NotNull OutputStream outputStream, long filePointerOffset) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
    }

    @NotNull
    public Downloader.FileDownloaderType getFileDownloaderType(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return this.fileDownloaderType;
    }

    public boolean verifyContentMD5(@NotNull Downloader.ServerRequest request, @NotNull String md5) {
        boolean bl;
        String fileMd5;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)md5, (String)"md5");
        CharSequence charSequence = md5;
        if (charSequence.length() == 0) {
            return true;
        }
        String string = fileMd5 = FetchCoreUtils.getFileMd5String((String)request.getFile());
        if (string != null) {
            String string2;
            String string3 = string2 = string;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            bl = string3.contentEquals(md5);
        } else {
            bl = true;
        }
        return bl;
    }

    @JvmOverloads
    public OkHttpDownloader(@Nullable OkHttpClient okHttpClient, @NotNull Downloader.FileDownloaderType fileDownloaderType) {
        Intrinsics.checkParameterIsNotNull((Object)fileDownloaderType, (String)"fileDownloaderType");
        this.fileDownloaderType = fileDownloaderType;
        Map map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.synchronized\u2026er.Response, Response>())");
        this.connections = map;
        OkHttpClient okHttpClient2 = okHttpClient;
        if (okHttpClient2 == null) {
            OkHttpClient okHttpClient3 = new OkHttpClient.Builder().readTimeout(20000L, TimeUnit.MILLISECONDS).connectTimeout(15000L, TimeUnit.MILLISECONDS).cache(null).followRedirects(true).followSslRedirects(true).retryOnConnectionFailure(false).build();
            okHttpClient2 = okHttpClient3;
            Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient3, (String)"OkHttpClient.Builder()\n \u2026lse)\n            .build()");
        }
        this.client = okHttpClient2;
    }

    @JvmOverloads
    public /* synthetic */ OkHttpDownloader(OkHttpClient okHttpClient, Downloader.FileDownloaderType fileDownloaderType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            okHttpClient = null;
        }
        if ((n & 2) != 0) {
            fileDownloaderType = Downloader.FileDownloaderType.SEQUENTIAL;
        }
        this(okHttpClient, fileDownloaderType);
    }

    @JvmOverloads
    public OkHttpDownloader(@Nullable OkHttpClient okHttpClient) {
        this(okHttpClient, null, 2, null);
    }

    @JvmOverloads
    public OkHttpDownloader() {
        this(null, null, 3, null);
    }

    public OkHttpDownloader(@NotNull Downloader.FileDownloaderType fileDownloaderType) {
        Intrinsics.checkParameterIsNotNull((Object)fileDownloaderType, (String)"fileDownloaderType");
        this(null, fileDownloaderType);
    }
}

