/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.fetch;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.FetchConfiguration;
import com.tonyodev.fetch2.database.DownloadDatabase;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.database.FetchDatabaseManager;
import com.tonyodev.fetch2.database.FetchDatabaseManagerImpl;
import com.tonyodev.fetch2.database.FetchDatabaseManagerWrapper;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.downloader.DownloadManagerCoordinator;
import com.tonyodev.fetch2.downloader.DownloadManagerImpl;
import com.tonyodev.fetch2.fetch.FetchHandler;
import com.tonyodev.fetch2.fetch.FetchHandlerImpl;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.fetch.LiveSettings;
import com.tonyodev.fetch2.helper.DownloadInfoUpdater;
import com.tonyodev.fetch2.helper.PriorityBackoffResetCallback;
import com.tonyodev.fetch2.helper.PriorityListProcessor;
import com.tonyodev.fetch2.helper.PriorityListProcessorImpl;
import com.tonyodev.fetch2.provider.DownloadProvider;
import com.tonyodev.fetch2.provider.GroupInfoProvider;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.DefaultStorageResolver;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.HandlerWrapper;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder;", "", "<init>", "()V", "lock", "holderMap", "", "", "Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder$Holder;", "mainUIHandler", "Landroid/os/Handler;", "getMainUIHandler", "()Landroid/os/Handler;", "buildModulesFromPrefs", "Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder$Modules;", "fetchConfiguration", "Lcom/tonyodev/fetch2/FetchConfiguration;", "removeNamespaceInstanceReference", "", "namespace", "Holder", "Modules", "fetch2_release"})
public final class FetchModulesBuilder {
    @NotNull
    public static final FetchModulesBuilder INSTANCE = new FetchModulesBuilder();
    @NotNull
    private static final Object lock = new Object();
    @NotNull
    private static final Map<String, Holder> holderMap = new LinkedHashMap();
    @NotNull
    private static final Handler mainUIHandler = new Handler(Looper.getMainLooper());

    private FetchModulesBuilder() {
    }

    @NotNull
    public final Handler getMainUIHandler() {
        return mainUIHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Modules buildModulesFromPrefs(@NotNull FetchConfiguration fetchConfiguration) {
        Modules modules;
        Intrinsics.checkNotNullParameter((Object)fetchConfiguration, (String)"fetchConfiguration");
        Object object = lock;
        synchronized (object) {
            Modules modules2;
            boolean bl = false;
            Holder holder = holderMap.get(fetchConfiguration.getNamespace());
            if (holder != null) {
                modules2 = new Modules(fetchConfiguration, holder.getHandlerWrapper(), holder.getFetchDatabaseManagerWrapper(), holder.getDownloadProvider(), holder.getGroupInfoProvider(), holder.getUiHandler(), holder.getDownloadManagerCoordinator(), holder.getListenerCoordinator());
            } else {
                HandlerWrapper newHandlerWrapper = new HandlerWrapper(fetchConfiguration.getNamespace(), fetchConfiguration.getBackgroundHandler());
                LiveSettings liveSettings = new LiveSettings(fetchConfiguration.getNamespace());
                FetchDatabaseManager fetchDatabaseManager = fetchConfiguration.getFetchDatabaseManager();
                if (fetchDatabaseManager == null) {
                    fetchDatabaseManager = new FetchDatabaseManagerImpl(fetchConfiguration.getAppContext(), fetchConfiguration.getNamespace(), fetchConfiguration.getLogger(), DownloadDatabase.Companion.getMigrations(), liveSettings, fetchConfiguration.getFileExistChecksEnabled(), new DefaultStorageResolver(fetchConfiguration.getAppContext(), FetchCoreUtils.getFileTempDir((Context)fetchConfiguration.getAppContext())));
                }
                FetchDatabaseManager newDatabaseManager = fetchDatabaseManager;
                FetchDatabaseManagerWrapper databaseManagerWrapper = new FetchDatabaseManagerWrapper(newDatabaseManager);
                DownloadProvider downloadProvider = new DownloadProvider(databaseManagerWrapper);
                DownloadManagerCoordinator downloadManagerCoordinator = new DownloadManagerCoordinator(fetchConfiguration.getNamespace());
                GroupInfoProvider groupInfoProvider = new GroupInfoProvider(fetchConfiguration.getNamespace(), downloadProvider);
                ListenerCoordinator listenerCoordinator = new ListenerCoordinator(fetchConfiguration.getNamespace(), groupInfoProvider, downloadProvider, mainUIHandler);
                Modules newModules = new Modules(fetchConfiguration, newHandlerWrapper, databaseManagerWrapper, downloadProvider, groupInfoProvider, mainUIHandler, downloadManagerCoordinator, listenerCoordinator);
                holderMap.put(fetchConfiguration.getNamespace(), new Holder(newHandlerWrapper, databaseManagerWrapper, downloadProvider, groupInfoProvider, mainUIHandler, downloadManagerCoordinator, listenerCoordinator, newModules.getNetworkInfoProvider()));
                modules2 = newModules;
            }
            Modules modules3 = modules2;
            modules3.getHandlerWrapper().incrementUsageCounter();
            modules = modules3;
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNamespaceInstanceReference(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Object object = lock;
        synchronized (object) {
            boolean bl = false;
            Holder holder = holderMap.get(namespace);
            if (holder != null) {
                holder.getHandlerWrapper().decrementUsageCounter();
                if (holder.getHandlerWrapper().usageCount() == 0) {
                    holder.getHandlerWrapper().close();
                    holder.getListenerCoordinator().clearAll();
                    holder.getGroupInfoProvider().clear();
                    holder.getFetchDatabaseManagerWrapper().close();
                    holder.getDownloadManagerCoordinator().clearAll();
                    holder.getNetworkInfoProvider().unregisterAllNetworkChangeListeners();
                    holderMap.remove(namespace);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0007H\u00c6\u0003J\t\u0010'\u001a\u00020\tH\u00c6\u0003J\t\u0010(\u001a\u00020\u000bH\u00c6\u0003J\t\u0010)\u001a\u00020\rH\u00c6\u0003J\t\u0010*\u001a\u00020\u000fH\u00c6\u0003J\t\u0010+\u001a\u00020\u0011H\u00c6\u0003JY\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00100\u001a\u000201H\u00d6\u0001J\t\u00102\u001a\u000203H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00064"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder$Holder;", "", "handlerWrapper", "Lcom/tonyodev/fetch2core/HandlerWrapper;", "fetchDatabaseManagerWrapper", "Lcom/tonyodev/fetch2/database/FetchDatabaseManagerWrapper;", "downloadProvider", "Lcom/tonyodev/fetch2/provider/DownloadProvider;", "groupInfoProvider", "Lcom/tonyodev/fetch2/provider/GroupInfoProvider;", "uiHandler", "Landroid/os/Handler;", "downloadManagerCoordinator", "Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "<init>", "(Lcom/tonyodev/fetch2core/HandlerWrapper;Lcom/tonyodev/fetch2/database/FetchDatabaseManagerWrapper;Lcom/tonyodev/fetch2/provider/DownloadProvider;Lcom/tonyodev/fetch2/provider/GroupInfoProvider;Landroid/os/Handler;Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;)V", "getHandlerWrapper", "()Lcom/tonyodev/fetch2core/HandlerWrapper;", "getFetchDatabaseManagerWrapper", "()Lcom/tonyodev/fetch2/database/FetchDatabaseManagerWrapper;", "getDownloadProvider", "()Lcom/tonyodev/fetch2/provider/DownloadProvider;", "getGroupInfoProvider", "()Lcom/tonyodev/fetch2/provider/GroupInfoProvider;", "getUiHandler", "()Landroid/os/Handler;", "getDownloadManagerCoordinator", "()Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;", "getListenerCoordinator", "()Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "getNetworkInfoProvider", "()Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "", "fetch2_release"})
    public static final class Holder {
        @NotNull
        private final HandlerWrapper handlerWrapper;
        @NotNull
        private final FetchDatabaseManagerWrapper fetchDatabaseManagerWrapper;
        @NotNull
        private final DownloadProvider downloadProvider;
        @NotNull
        private final GroupInfoProvider groupInfoProvider;
        @NotNull
        private final Handler uiHandler;
        @NotNull
        private final DownloadManagerCoordinator downloadManagerCoordinator;
        @NotNull
        private final ListenerCoordinator listenerCoordinator;
        @NotNull
        private final NetworkInfoProvider networkInfoProvider;

        public Holder(@NotNull HandlerWrapper handlerWrapper, @NotNull FetchDatabaseManagerWrapper fetchDatabaseManagerWrapper, @NotNull DownloadProvider downloadProvider, @NotNull GroupInfoProvider groupInfoProvider, @NotNull Handler uiHandler, @NotNull DownloadManagerCoordinator downloadManagerCoordinator, @NotNull ListenerCoordinator listenerCoordinator, @NotNull NetworkInfoProvider networkInfoProvider) {
            Intrinsics.checkNotNullParameter((Object)handlerWrapper, (String)"handlerWrapper");
            Intrinsics.checkNotNullParameter((Object)fetchDatabaseManagerWrapper, (String)"fetchDatabaseManagerWrapper");
            Intrinsics.checkNotNullParameter((Object)downloadProvider, (String)"downloadProvider");
            Intrinsics.checkNotNullParameter((Object)groupInfoProvider, (String)"groupInfoProvider");
            Intrinsics.checkNotNullParameter((Object)uiHandler, (String)"uiHandler");
            Intrinsics.checkNotNullParameter((Object)downloadManagerCoordinator, (String)"downloadManagerCoordinator");
            Intrinsics.checkNotNullParameter((Object)listenerCoordinator, (String)"listenerCoordinator");
            Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"networkInfoProvider");
            this.handlerWrapper = handlerWrapper;
            this.fetchDatabaseManagerWrapper = fetchDatabaseManagerWrapper;
            this.downloadProvider = downloadProvider;
            this.groupInfoProvider = groupInfoProvider;
            this.uiHandler = uiHandler;
            this.downloadManagerCoordinator = downloadManagerCoordinator;
            this.listenerCoordinator = listenerCoordinator;
            this.networkInfoProvider = networkInfoProvider;
        }

        @NotNull
        public final HandlerWrapper getHandlerWrapper() {
            return this.handlerWrapper;
        }

        @NotNull
        public final FetchDatabaseManagerWrapper getFetchDatabaseManagerWrapper() {
            return this.fetchDatabaseManagerWrapper;
        }

        @NotNull
        public final DownloadProvider getDownloadProvider() {
            return this.downloadProvider;
        }

        @NotNull
        public final GroupInfoProvider getGroupInfoProvider() {
            return this.groupInfoProvider;
        }

        @NotNull
        public final Handler getUiHandler() {
            return this.uiHandler;
        }

        @NotNull
        public final DownloadManagerCoordinator getDownloadManagerCoordinator() {
            return this.downloadManagerCoordinator;
        }

        @NotNull
        public final ListenerCoordinator getListenerCoordinator() {
            return this.listenerCoordinator;
        }

        @NotNull
        public final NetworkInfoProvider getNetworkInfoProvider() {
            return this.networkInfoProvider;
        }

        @NotNull
        public final HandlerWrapper component1() {
            return this.handlerWrapper;
        }

        @NotNull
        public final FetchDatabaseManagerWrapper component2() {
            return this.fetchDatabaseManagerWrapper;
        }

        @NotNull
        public final DownloadProvider component3() {
            return this.downloadProvider;
        }

        @NotNull
        public final GroupInfoProvider component4() {
            return this.groupInfoProvider;
        }

        @NotNull
        public final Handler component5() {
            return this.uiHandler;
        }

        @NotNull
        public final DownloadManagerCoordinator component6() {
            return this.downloadManagerCoordinator;
        }

        @NotNull
        public final ListenerCoordinator component7() {
            return this.listenerCoordinator;
        }

        @NotNull
        public final NetworkInfoProvider component8() {
            return this.networkInfoProvider;
        }

        @NotNull
        public final Holder copy(@NotNull HandlerWrapper handlerWrapper, @NotNull FetchDatabaseManagerWrapper fetchDatabaseManagerWrapper, @NotNull DownloadProvider downloadProvider, @NotNull GroupInfoProvider groupInfoProvider, @NotNull Handler uiHandler, @NotNull DownloadManagerCoordinator downloadManagerCoordinator, @NotNull ListenerCoordinator listenerCoordinator, @NotNull NetworkInfoProvider networkInfoProvider) {
            Intrinsics.checkNotNullParameter((Object)handlerWrapper, (String)"handlerWrapper");
            Intrinsics.checkNotNullParameter((Object)fetchDatabaseManagerWrapper, (String)"fetchDatabaseManagerWrapper");
            Intrinsics.checkNotNullParameter((Object)downloadProvider, (String)"downloadProvider");
            Intrinsics.checkNotNullParameter((Object)groupInfoProvider, (String)"groupInfoProvider");
            Intrinsics.checkNotNullParameter((Object)uiHandler, (String)"uiHandler");
            Intrinsics.checkNotNullParameter((Object)downloadManagerCoordinator, (String)"downloadManagerCoordinator");
            Intrinsics.checkNotNullParameter((Object)listenerCoordinator, (String)"listenerCoordinator");
            Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"networkInfoProvider");
            return new Holder(handlerWrapper, fetchDatabaseManagerWrapper, downloadProvider, groupInfoProvider, uiHandler, downloadManagerCoordinator, listenerCoordinator, networkInfoProvider);
        }

        public static /* synthetic */ Holder copy$default(Holder holder, HandlerWrapper handlerWrapper, FetchDatabaseManagerWrapper fetchDatabaseManagerWrapper, DownloadProvider downloadProvider, GroupInfoProvider groupInfoProvider, Handler handler, DownloadManagerCoordinator downloadManagerCoordinator, ListenerCoordinator listenerCoordinator, NetworkInfoProvider networkInfoProvider, int n, Object object) {
            if ((n & 1) != 0) {
                handlerWrapper = holder.handlerWrapper;
            }
            if ((n & 2) != 0) {
                fetchDatabaseManagerWrapper = holder.fetchDatabaseManagerWrapper;
            }
            if ((n & 4) != 0) {
                downloadProvider = holder.downloadProvider;
            }
            if ((n & 8) != 0) {
                groupInfoProvider = holder.groupInfoProvider;
            }
            if ((n & 0x10) != 0) {
                handler = holder.uiHandler;
            }
            if ((n & 0x20) != 0) {
                downloadManagerCoordinator = holder.downloadManagerCoordinator;
            }
            if ((n & 0x40) != 0) {
                listenerCoordinator = holder.listenerCoordinator;
            }
            if ((n & 0x80) != 0) {
                networkInfoProvider = holder.networkInfoProvider;
            }
            return holder.copy(handlerWrapper, fetchDatabaseManagerWrapper, downloadProvider, groupInfoProvider, handler, downloadManagerCoordinator, listenerCoordinator, networkInfoProvider);
        }

        @NotNull
        public String toString() {
            return "Holder(handlerWrapper=" + this.handlerWrapper + ", fetchDatabaseManagerWrapper=" + this.fetchDatabaseManagerWrapper + ", downloadProvider=" + this.downloadProvider + ", groupInfoProvider=" + this.groupInfoProvider + ", uiHandler=" + this.uiHandler + ", downloadManagerCoordinator=" + this.downloadManagerCoordinator + ", listenerCoordinator=" + this.listenerCoordinator + ", networkInfoProvider=" + this.networkInfoProvider + ")";
        }

        public int hashCode() {
            int result = this.handlerWrapper.hashCode();
            result = result * 31 + this.fetchDatabaseManagerWrapper.hashCode();
            result = result * 31 + this.downloadProvider.hashCode();
            result = result * 31 + this.groupInfoProvider.hashCode();
            result = result * 31 + this.uiHandler.hashCode();
            result = result * 31 + this.downloadManagerCoordinator.hashCode();
            result = result * 31 + this.listenerCoordinator.hashCode();
            result = result * 31 + this.networkInfoProvider.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Holder)) {
                return false;
            }
            Holder holder = (Holder)other;
            if (!Intrinsics.areEqual((Object)this.handlerWrapper, (Object)holder.handlerWrapper)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fetchDatabaseManagerWrapper, (Object)holder.fetchDatabaseManagerWrapper)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.downloadProvider, (Object)holder.downloadProvider)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.groupInfoProvider, (Object)holder.groupInfoProvider)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.uiHandler, (Object)holder.uiHandler)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.downloadManagerCoordinator, (Object)holder.downloadManagerCoordinator)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.listenerCoordinator, (Object)holder.listenerCoordinator)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.networkInfoProvider, (Object)holder.networkInfoProvider);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchModulesBuilder$Modules;", "", "fetchConfiguration", "Lcom/tonyodev/fetch2/FetchConfiguration;", "handlerWrapper", "Lcom/tonyodev/fetch2core/HandlerWrapper;", "fetchDatabaseManagerWrapper", "Lcom/tonyodev/fetch2/database/FetchDatabaseManagerWrapper;", "downloadProvider", "Lcom/tonyodev/fetch2/provider/DownloadProvider;", "groupInfoProvider", "Lcom/tonyodev/fetch2/provider/GroupInfoProvider;", "uiHandler", "Landroid/os/Handler;", "downloadManagerCoordinator", "Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "<init>", "(Lcom/tonyodev/fetch2/FetchConfiguration;Lcom/tonyodev/fetch2core/HandlerWrapper;Lcom/tonyodev/fetch2/database/FetchDatabaseManagerWrapper;Lcom/tonyodev/fetch2/provider/DownloadProvider;Lcom/tonyodev/fetch2/provider/GroupInfoProvider;Landroid/os/Handler;Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;)V", "getFetchConfiguration", "()Lcom/tonyodev/fetch2/FetchConfiguration;", "getHandlerWrapper", "()Lcom/tonyodev/fetch2core/HandlerWrapper;", "getFetchDatabaseManagerWrapper", "()Lcom/tonyodev/fetch2/database/FetchDatabaseManagerWrapper;", "getUiHandler", "()Landroid/os/Handler;", "getListenerCoordinator", "()Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "priorityListProcessor", "Lcom/tonyodev/fetch2/helper/PriorityListProcessor;", "Lcom/tonyodev/fetch2/Download;", "downloadInfoUpdater", "Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "getNetworkInfoProvider", "()Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "fetchHandler", "Lcom/tonyodev/fetch2/fetch/FetchHandler;", "getFetchHandler", "()Lcom/tonyodev/fetch2/fetch/FetchHandler;", "fetch2_release"})
    public static final class Modules {
        @NotNull
        private final FetchConfiguration fetchConfiguration;
        @NotNull
        private final HandlerWrapper handlerWrapper;
        @NotNull
        private final FetchDatabaseManagerWrapper fetchDatabaseManagerWrapper;
        @NotNull
        private final Handler uiHandler;
        @NotNull
        private final ListenerCoordinator listenerCoordinator;
        @NotNull
        private final DownloadManager downloadManager;
        @NotNull
        private final PriorityListProcessor<Download> priorityListProcessor;
        @NotNull
        private final DownloadInfoUpdater downloadInfoUpdater;
        @NotNull
        private final NetworkInfoProvider networkInfoProvider;
        @NotNull
        private final FetchHandler fetchHandler;

        public Modules(@NotNull FetchConfiguration fetchConfiguration, @NotNull HandlerWrapper handlerWrapper, @NotNull FetchDatabaseManagerWrapper fetchDatabaseManagerWrapper, @NotNull DownloadProvider downloadProvider, @NotNull GroupInfoProvider groupInfoProvider, @NotNull Handler uiHandler, @NotNull DownloadManagerCoordinator downloadManagerCoordinator, @NotNull ListenerCoordinator listenerCoordinator) {
            Intrinsics.checkNotNullParameter((Object)fetchConfiguration, (String)"fetchConfiguration");
            Intrinsics.checkNotNullParameter((Object)handlerWrapper, (String)"handlerWrapper");
            Intrinsics.checkNotNullParameter((Object)fetchDatabaseManagerWrapper, (String)"fetchDatabaseManagerWrapper");
            Intrinsics.checkNotNullParameter((Object)downloadProvider, (String)"downloadProvider");
            Intrinsics.checkNotNullParameter((Object)groupInfoProvider, (String)"groupInfoProvider");
            Intrinsics.checkNotNullParameter((Object)uiHandler, (String)"uiHandler");
            Intrinsics.checkNotNullParameter((Object)downloadManagerCoordinator, (String)"downloadManagerCoordinator");
            Intrinsics.checkNotNullParameter((Object)listenerCoordinator, (String)"listenerCoordinator");
            this.fetchConfiguration = fetchConfiguration;
            this.handlerWrapper = handlerWrapper;
            this.fetchDatabaseManagerWrapper = fetchDatabaseManagerWrapper;
            this.uiHandler = uiHandler;
            this.listenerCoordinator = listenerCoordinator;
            this.downloadInfoUpdater = new DownloadInfoUpdater(this.fetchDatabaseManagerWrapper);
            this.networkInfoProvider = new NetworkInfoProvider(this.fetchConfiguration.getAppContext(), this.fetchConfiguration.getInternetCheckUrl());
            this.downloadManager = new DownloadManagerImpl(this.fetchConfiguration.getHttpDownloader(), this.fetchConfiguration.getConcurrentLimit(), this.fetchConfiguration.getProgressReportingIntervalMillis(), this.fetchConfiguration.getLogger(), this.networkInfoProvider, this.fetchConfiguration.getRetryOnNetworkGain(), this.downloadInfoUpdater, downloadManagerCoordinator, this.listenerCoordinator, this.fetchConfiguration.getFileServerDownloader(), this.fetchConfiguration.getHashCheckingEnabled(), this.fetchConfiguration.getStorageResolver(), this.fetchConfiguration.getNamespace(), groupInfoProvider, this.fetchConfiguration.getMaxAutoRetryAttempts(), this.fetchConfiguration.getPreAllocateFileOnCreation());
            this.priorityListProcessor = new PriorityListProcessorImpl(this.handlerWrapper, downloadProvider, this.downloadManager, this.networkInfoProvider, this.fetchConfiguration.getLogger(), this.listenerCoordinator, this.fetchConfiguration.getConcurrentLimit(), this.fetchConfiguration.getNamespace(), this.fetchConfiguration.getPrioritySort());
            ((DownloadManagerImpl)this.downloadManager).setPriorityBackoffResetCallback((PriorityBackoffResetCallback)((Object)this.priorityListProcessor));
            ((PriorityListProcessorImpl)this.priorityListProcessor).setGlobalNetworkType(this.fetchConfiguration.getGlobalNetworkType());
            FetchHandler fetchHandler = this.fetchConfiguration.getFetchHandler();
            if (fetchHandler == null) {
                fetchHandler = new FetchHandlerImpl(this.fetchConfiguration.getNamespace(), this.fetchDatabaseManagerWrapper, this.downloadManager, this.priorityListProcessor, this.fetchConfiguration.getLogger(), this.fetchConfiguration.getAutoStart(), this.fetchConfiguration.getHttpDownloader(), this.fetchConfiguration.getFileServerDownloader(), this.listenerCoordinator, this.uiHandler, this.fetchConfiguration.getStorageResolver(), this.fetchConfiguration.getFetchNotificationManager(), groupInfoProvider, this.fetchConfiguration.getPrioritySort(), this.fetchConfiguration.getCreateFileOnEnqueue());
            }
            this.fetchHandler = fetchHandler;
            this.fetchDatabaseManagerWrapper.setDelegate(new FetchDatabaseManager.Delegate<DownloadInfo>(){

                @Override
                public void deleteTempFilesForDownload(DownloadInfo downloadInfo) {
                    Intrinsics.checkNotNullParameter((Object)downloadInfo, (String)"downloadInfo");
                    String tempDir = this.getFetchConfiguration().getStorageResolver().getDirectoryForFileDownloaderTypeParallel(FetchUtils.getRequestForDownload$default(downloadInfo, null, 2, null));
                    FetchUtils.deleteAllInFolderForId(downloadInfo.getId(), tempDir);
                }
            });
        }

        @NotNull
        public final FetchConfiguration getFetchConfiguration() {
            return this.fetchConfiguration;
        }

        @NotNull
        public final HandlerWrapper getHandlerWrapper() {
            return this.handlerWrapper;
        }

        @NotNull
        public final FetchDatabaseManagerWrapper getFetchDatabaseManagerWrapper() {
            return this.fetchDatabaseManagerWrapper;
        }

        @NotNull
        public final Handler getUiHandler() {
            return this.uiHandler;
        }

        @NotNull
        public final ListenerCoordinator getListenerCoordinator() {
            return this.listenerCoordinator;
        }

        @NotNull
        public final NetworkInfoProvider getNetworkInfoProvider() {
            return this.networkInfoProvider;
        }

        @NotNull
        public final FetchHandler getFetchHandler() {
            return this.fetchHandler;
        }
    }
}

