/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.fetch;

import android.os.Handler;
import android.os.Looper;
import com.tonyodev.fetch2.CompletedDownload;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.EnqueueAction;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchErrorUtils;
import com.tonyodev.fetch2.FetchGroup;
import com.tonyodev.fetch2.FetchListener;
import com.tonyodev.fetch2.FetchNotificationManager;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.PrioritySort;
import com.tonyodev.fetch2.Request;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.database.FetchDatabaseManager;
import com.tonyodev.fetch2.database.FetchDatabaseManagerWrapper;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.FetchHandler;
import com.tonyodev.fetch2.fetch.FetchModulesBuilder;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.helper.PriorityListProcessor;
import com.tonyodev.fetch2.provider.GroupInfoProvider;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.DownloadBlock;
import com.tonyodev.fetch2core.DownloadBlockInfo;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.Extras;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FetchObserver;
import com.tonyodev.fetch2core.FileResource;
import com.tonyodev.fetch2core.FileServerDownloader;
import com.tonyodev.fetch2core.FileSliceInfo;
import com.tonyodev.fetch2core.InterruptMonitor;
import com.tonyodev.fetch2core.Logger;
import com.tonyodev.fetch2core.Reason;
import com.tonyodev.fetch2core.StorageResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u008f\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020\u000e\u00a2\u0006\u0004\b \u0010!J\b\u0010(\u001a\u00020)H\u0016J\u001c\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.H\u0016J(\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020,0+0/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020.0/H\u0016J(\u00101\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u000e0+0/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020.0/H\u0016J(\u00103\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020,0+0/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020.0/H\u0002J\u0010\u00104\u001a\u00020\u000e2\u0006\u00105\u001a\u000202H\u0002J\u0010\u00106\u001a\u00020\n2\u0006\u00107\u001a\u000208H\u0016J\u001c\u00109\u001a\b\u0012\u0004\u0012\u00020\n0/2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002080/H\u0016J\u0010\u0010;\u001a\u00020)2\u0006\u00105\u001a\u000202H\u0002J\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020\n0/2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020#0/H\u0016J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\n0/2\u0006\u0010?\u001a\u00020#H\u0016J\u001c\u0010@\u001a\b\u0012\u0004\u0012\u00020\n0/2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002020/H\u0002J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020\n0/H\u0016J\b\u0010C\u001a\u00020)H\u0016J\b\u0010D\u001a\u00020)H\u0016J\u001c\u0010E\u001a\b\u0012\u0004\u0012\u00020\n0/2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020#0/H\u0016J\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020\n0/2\u0006\u0010?\u001a\u00020#H\u0016J\u001c\u0010G\u001a\b\u0012\u0004\u0012\u00020\n0/2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020#0/H\u0002J\u000e\u0010I\u001a\b\u0012\u0004\u0012\u00020\n0/H\u0016J\u001c\u0010J\u001a\b\u0012\u0004\u0012\u00020\n0/2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020#0/H\u0016J\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020\n0/2\u0006\u0010?\u001a\u00020#H\u0016J\u000e\u0010L\u001a\b\u0012\u0004\u0012\u00020\n0/H\u0016J\u0016\u0010M\u001a\b\u0012\u0004\u0012\u00020\n0/2\u0006\u0010N\u001a\u00020OH\u0016J$\u0010P\u001a\b\u0012\u0004\u0012\u00020\n0/2\u0006\u0010Q\u001a\u00020#2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020O0/H\u0016J\u001c\u0010S\u001a\b\u0012\u0004\u0012\u00020\n0/2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002020/H\u0002J\u001c\u0010T\u001a\b\u0012\u0004\u0012\u00020\n0/2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020#0/H\u0016J\u0016\u0010U\u001a\b\u0012\u0004\u0012\u00020\n0/2\u0006\u0010?\u001a\u00020#H\u0016J\u000e\u0010V\u001a\b\u0012\u0004\u0012\u00020\n0/H\u0016J\u0016\u0010W\u001a\b\u0012\u0004\u0012\u00020\n0/2\u0006\u0010N\u001a\u00020OH\u0016J$\u0010X\u001a\b\u0012\u0004\u0012\u00020\n0/2\u0006\u0010Q\u001a\u00020#2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020O0/H\u0016J\u001c\u0010Y\u001a\b\u0012\u0004\u0012\u00020\n0/2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002020/H\u0002J\u001c\u0010Z\u001a\b\u0012\u0004\u0012\u00020\n0/2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020#0/H\u0016J\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\n0/2\u0006\u0010?\u001a\u00020#H\u0016J\u000e\u0010\\\u001a\b\u0012\u0004\u0012\u00020\n0/H\u0016J\u001c\u0010]\u001a\b\u0012\u0004\u0012\u00020\n0/2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002020/H\u0002J\u001c\u0010^\u001a\b\u0012\u0004\u0012\u00020\n0/2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020#0/H\u0016J\u001a\u0010_\u001a\u0004\u0018\u00010\n2\u0006\u0010`\u001a\u00020#2\u0006\u0010a\u001a\u00020\u000eH\u0016J$\u0010b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0+2\u0006\u0010c\u001a\u00020#2\u0006\u0010d\u001a\u00020.H\u0016J\u0018\u0010e\u001a\u00020\n2\u0006\u0010?\u001a\u00020#2\u0006\u0010f\u001a\u00020\u0003H\u0016J\u0018\u0010g\u001a\u00020\n2\u0006\u0010?\u001a\u00020#2\u0006\u0010h\u001a\u00020iH\u0016J\u000e\u0010j\u001a\b\u0012\u0004\u0012\u00020\n0/H\u0016J\u0012\u0010k\u001a\u0004\u0018\u00010\n2\u0006\u0010?\u001a\u00020#H\u0016J\u001c\u0010j\u001a\b\u0012\u0004\u0012\u00020\n0/2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020#0/H\u0016J\u0016\u0010m\u001a\b\u0012\u0004\u0012\u00020\n0/2\u0006\u0010?\u001a\u00020#H\u0016J\u0016\u0010n\u001a\b\u0012\u0004\u0012\u00020\n0/2\u0006\u0010N\u001a\u00020OH\u0016J\u001c\u0010n\u001a\b\u0012\u0004\u0012\u00020\n0/2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020O0/H\u0016J$\u0010o\u001a\b\u0012\u0004\u0012\u00020\n0/2\u0006\u0010Q\u001a\u00020#2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020O0/H\u0016J\u0016\u0010p\u001a\b\u0012\u0004\u0012\u00020\n0/2\u0006\u0010q\u001a\u00020rH\u0016J\u000e\u0010s\u001a\b\u0012\u0004\u0012\u00020#0/H\u0016J\u0016\u0010t\u001a\b\u0012\u0004\u0012\u00020\n0/2\u0006\u0010u\u001a\u00020\u0003H\u0016J\u0016\u0010v\u001a\b\u0012\u0004\u0012\u00020w0/2\u0006\u0010?\u001a\u00020#H\u0016J\u0018\u0010x\u001a\u00020r2\u0006\u0010-\u001a\u00020.2\u0006\u0010y\u001a\u00020\u000eH\u0016J&\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020\u00032\u0014\u0010}\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010~H\u0016J\u0017\u0010\u007f\u001a\t\u0012\u0005\u0012\u00030\u0080\u00010/2\u0006\u0010-\u001a\u00020.H\u0016J\t\u0010\u0081\u0001\u001a\u00020)H\u0016J\u0013\u0010\u0082\u0001\u001a\u00020)2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0016J\u0012\u0010\u0085\u0001\u001a\u00020)2\u0007\u0010\u0086\u0001\u001a\u00020#H\u0016J\u0012\u0010\u0087\u0001\u001a\u00020)2\u0007\u0010\u0088\u0001\u001a\u00020\u000eH\u0016J#\u0010\u0089\u0001\u001a\u00020)2\u0007\u0010\u008a\u0001\u001a\u00020&2\u0007\u0010\u008b\u0001\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u008c\u0001\u001a\u00020)2\u0007\u0010\u008a\u0001\u001a\u00020&H\u0016J\u0010\u0010\u008d\u0001\u001a\t\u0012\u0004\u0012\u00020&0\u008e\u0001H\u0016J\u0012\u0010\u008f\u0001\u001a\u00020\u000e2\u0007\u0010\u0090\u0001\u001a\u00020\u000eH\u0016J\t\u0010\u0091\u0001\u001a\u00020rH\u0016J\u0017\u0010\u0092\u0001\u001a\u00020)2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002020/H\u0002J\t\u0010\u0093\u0001\u001a\u00020)H\u0002J\u0012\u0010\u0094\u0001\u001a\u00030\u0095\u00012\u0006\u0010?\u001a\u00020#H\u0016J;\u0010\u0096\u0001\u001a\u00020)2\u0006\u0010`\u001a\u00020#2\"\u0010\u0097\u0001\u001a\u0012\u0012\r\b\u0001\u0012\t\u0012\u0004\u0012\u00020\n0\u0099\u00010\u0098\u0001\"\t\u0012\u0004\u0012\u00020\n0\u0099\u0001H\u0016\u00a2\u0006\u0003\u0010\u009a\u0001J;\u0010\u009b\u0001\u001a\u00020)2\u0006\u0010`\u001a\u00020#2\"\u0010\u0097\u0001\u001a\u0012\u0012\r\b\u0001\u0012\t\u0012\u0004\u0012\u00020\n0\u0099\u00010\u0098\u0001\"\t\u0012\u0004\u0012\u00020\n0\u0099\u0001H\u0016\u00a2\u0006\u0003\u0010\u009a\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009c\u0001"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchHandlerImpl;", "Lcom/tonyodev/fetch2/fetch/FetchHandler;", "namespace", "", "fetchDatabaseManagerWrapper", "Lcom/tonyodev/fetch2/database/FetchDatabaseManagerWrapper;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "priorityListProcessor", "Lcom/tonyodev/fetch2/helper/PriorityListProcessor;", "Lcom/tonyodev/fetch2/Download;", "logger", "Lcom/tonyodev/fetch2core/Logger;", "autoStart", "", "httpDownloader", "Lcom/tonyodev/fetch2core/Downloader;", "fileServerDownloader", "Lcom/tonyodev/fetch2core/FileServerDownloader;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "uiHandler", "Landroid/os/Handler;", "storageResolver", "Lcom/tonyodev/fetch2core/StorageResolver;", "fetchNotificationManager", "Lcom/tonyodev/fetch2/FetchNotificationManager;", "groupInfoProvider", "Lcom/tonyodev/fetch2/provider/GroupInfoProvider;", "prioritySort", "Lcom/tonyodev/fetch2/PrioritySort;", "createFileOnEnqueue", "<init>", "(Ljava/lang/String;Lcom/tonyodev/fetch2/database/FetchDatabaseManagerWrapper;Lcom/tonyodev/fetch2/downloader/DownloadManager;Lcom/tonyodev/fetch2/helper/PriorityListProcessor;Lcom/tonyodev/fetch2core/Logger;ZLcom/tonyodev/fetch2core/Downloader;Lcom/tonyodev/fetch2core/FileServerDownloader;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;Landroid/os/Handler;Lcom/tonyodev/fetch2core/StorageResolver;Lcom/tonyodev/fetch2/FetchNotificationManager;Lcom/tonyodev/fetch2/provider/GroupInfoProvider;Lcom/tonyodev/fetch2/PrioritySort;Z)V", "listenerId", "", "listenerSet", "", "Lcom/tonyodev/fetch2/FetchListener;", "isTerminating", "init", "", "enqueue", "Lkotlin/Pair;", "Lcom/tonyodev/fetch2/Error;", "request", "Lcom/tonyodev/fetch2/Request;", "", "requests", "enqueueBatch", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "enqueueRequests", "prepareDownloadInfoForEnqueue", "downloadInfo", "enqueueCompletedDownload", "completedDownload", "Lcom/tonyodev/fetch2/CompletedDownload;", "enqueueCompletedDownloads", "completedDownloads", "prepareCompletedDownloadInfoForEnqueue", "pause", "ids", "pausedGroup", "id", "pauseDownloads", "downloads", "pauseAll", "freeze", "unfreeze", "resume", "resumeGroup", "resumeDownloads", "downloadIds", "resumeAll", "remove", "removeGroup", "removeAll", "removeAllWithStatus", "status", "Lcom/tonyodev/fetch2/Status;", "removeAllInGroupWithStatus", "groupId", "statuses", "removeDownloads", "delete", "deleteGroup", "deleteAll", "deleteAllWithStatus", "deleteAllInGroupWithStatus", "deleteDownloads", "cancel", "cancelGroup", "cancelAll", "cancelDownloads", "retry", "resetAutoRetryAttempts", "downloadId", "retryDownload", "updateRequest", "requestId", "newRequest", "renameCompletedDownloadFile", "newFileName", "replaceExtras", "extras", "Lcom/tonyodev/fetch2core/Extras;", "getDownloads", "getDownload", "idList", "getDownloadsInGroup", "getDownloadsWithStatus", "getDownloadsInGroupWithStatus", "getDownloadsByRequestIdentifier", "identifier", "", "getAllGroupIds", "getDownloadsByTag", "tag", "getDownloadBlocks", "Lcom/tonyodev/fetch2core/DownloadBlock;", "getContentLengthForRequest", "fromServer", "getServerResponse", "Lcom/tonyodev/fetch2core/Downloader$Response;", "url", "header", "", "getFetchFileServerCatalog", "Lcom/tonyodev/fetch2core/FileResource;", "close", "setGlobalNetworkType", "networkType", "Lcom/tonyodev/fetch2/NetworkType;", "setDownloadConcurrentLimit", "downloadConcurrentLimit", "enableLogging", "enabled", "addListener", "listener", "notify", "removeListener", "getListenerSet", "", "hasActiveDownloads", "includeAddedDownloads", "getPendingCount", "cancelDownloadsIfDownloading", "startPriorityQueueIfNotStarted", "getFetchGroup", "Lcom/tonyodev/fetch2/FetchGroup;", "addFetchObserversForDownload", "fetchObservers", "", "Lcom/tonyodev/fetch2core/FetchObserver;", "(I[Lcom/tonyodev/fetch2core/FetchObserver;)V", "removeFetchObserversForDownload", "fetch2_release"})
@SourceDebugExtension(value={"SMAP\nFetchHandlerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FetchHandlerImpl.kt\ncom/tonyodev/fetch2/fetch/FetchHandlerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,790:1\n1863#2,2:791\n1863#2,2:793\n1557#2:795\n1628#2,3:796\n1863#2,2:799\n1557#2:801\n1628#2,3:802\n1863#2,2:805\n1557#2:807\n1628#2,3:808\n1863#2,2:811\n1863#2,2:813\n1863#2,2:815\n1863#2,2:817\n1863#2,2:823\n1863#2,2:825\n1863#2,2:827\n216#3,2:819\n32#4,2:821\n*S KotlinDebug\n*F\n+ 1 FetchHandlerImpl.kt\ncom/tonyodev/fetch2/fetch/FetchHandlerImpl\n*L\n62#1:791,2\n84#1:793,2\n212#1:795\n212#1:796,3\n241#1:799,2\n269#1:801\n269#1:802,3\n275#1:805,2\n287#1:807\n287#1:808,3\n313#1:811,2\n343#1:813,2\n366#1:815,2\n380#1:817,2\n643#1:823,2\n665#1:825,2\n689#1:827,2\n583#1:819,2\n619#1:821,2\n*E\n"})
public final class FetchHandlerImpl
implements FetchHandler {
    @NotNull
    private final String namespace;
    @NotNull
    private final FetchDatabaseManagerWrapper fetchDatabaseManagerWrapper;
    @NotNull
    private final DownloadManager downloadManager;
    @NotNull
    private final PriorityListProcessor<Download> priorityListProcessor;
    @NotNull
    private final Logger logger;
    private final boolean autoStart;
    @NotNull
    private final Downloader<?, ?> httpDownloader;
    @NotNull
    private final FileServerDownloader fileServerDownloader;
    @NotNull
    private final ListenerCoordinator listenerCoordinator;
    @NotNull
    private final Handler uiHandler;
    @NotNull
    private final StorageResolver storageResolver;
    @Nullable
    private final FetchNotificationManager fetchNotificationManager;
    @NotNull
    private final GroupInfoProvider groupInfoProvider;
    @NotNull
    private final PrioritySort prioritySort;
    private final boolean createFileOnEnqueue;
    private final int listenerId;
    @NotNull
    private final Set<FetchListener> listenerSet;
    private volatile boolean isTerminating;

    public FetchHandlerImpl(@NotNull String namespace, @NotNull FetchDatabaseManagerWrapper fetchDatabaseManagerWrapper, @NotNull DownloadManager downloadManager, @NotNull PriorityListProcessor<? extends Download> priorityListProcessor, @NotNull Logger logger, boolean autoStart, @NotNull Downloader<?, ?> httpDownloader, @NotNull FileServerDownloader fileServerDownloader, @NotNull ListenerCoordinator listenerCoordinator, @NotNull Handler uiHandler, @NotNull StorageResolver storageResolver, @Nullable FetchNotificationManager fetchNotificationManager, @NotNull GroupInfoProvider groupInfoProvider, @NotNull PrioritySort prioritySort, boolean createFileOnEnqueue) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)fetchDatabaseManagerWrapper, (String)"fetchDatabaseManagerWrapper");
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter(priorityListProcessor, (String)"priorityListProcessor");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(httpDownloader, (String)"httpDownloader");
        Intrinsics.checkNotNullParameter((Object)fileServerDownloader, (String)"fileServerDownloader");
        Intrinsics.checkNotNullParameter((Object)listenerCoordinator, (String)"listenerCoordinator");
        Intrinsics.checkNotNullParameter((Object)uiHandler, (String)"uiHandler");
        Intrinsics.checkNotNullParameter((Object)storageResolver, (String)"storageResolver");
        Intrinsics.checkNotNullParameter((Object)groupInfoProvider, (String)"groupInfoProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)prioritySort), (String)"prioritySort");
        this.namespace = namespace;
        this.fetchDatabaseManagerWrapper = fetchDatabaseManagerWrapper;
        this.downloadManager = downloadManager;
        this.priorityListProcessor = priorityListProcessor;
        this.logger = logger;
        this.autoStart = autoStart;
        this.httpDownloader = httpDownloader;
        this.fileServerDownloader = fileServerDownloader;
        this.listenerCoordinator = listenerCoordinator;
        this.uiHandler = uiHandler;
        this.storageResolver = storageResolver;
        this.fetchNotificationManager = fetchNotificationManager;
        this.groupInfoProvider = groupInfoProvider;
        this.prioritySort = prioritySort;
        this.createFileOnEnqueue = createFileOnEnqueue;
        this.listenerId = UUID.randomUUID().hashCode();
        this.listenerSet = new LinkedHashSet();
    }

    @Override
    public void init() {
        if (this.fetchNotificationManager != null) {
            this.listenerCoordinator.addNotificationManager(this.fetchNotificationManager);
        }
        this.fetchDatabaseManagerWrapper.sanitizeOnFirstEntry();
        if (this.autoStart) {
            this.priorityListProcessor.start();
        }
    }

    @Override
    @NotNull
    public Pair<Download, Error> enqueue(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return (Pair)CollectionsKt.first(this.enqueueRequests(CollectionsKt.listOf((Object)request)));
    }

    @Override
    @NotNull
    public List<Pair<Download, Error>> enqueue(@NotNull List<? extends Request> requests) {
        Intrinsics.checkNotNullParameter(requests, (String)"requests");
        return this.enqueueRequests(requests);
    }

    @Override
    @NotNull
    public List<Pair<DownloadInfo, Boolean>> enqueueBatch(@NotNull List<? extends Request> requests) {
        Intrinsics.checkNotNullParameter(requests, (String)"requests");
        List downloadInfos = new ArrayList();
        Iterable $this$forEach$iv = requests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Request it = (Request)element$iv;
            boolean bl = false;
            DownloadInfo downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(it, this.fetchDatabaseManagerWrapper.getNewDownloadInfoInstance());
            downloadInfo.setNamespace(this.namespace);
            boolean existing = this.prepareDownloadInfoForEnqueue(downloadInfo);
            downloadInfo.setStatus(it.getDownloadOnEnqueue() ? Status.QUEUED : Status.ADDED);
            if (downloadInfo.getStatus() == Status.COMPLETED || existing) continue;
            downloadInfos.add(downloadInfo);
        }
        List<Pair<DownloadInfo, Boolean>> results = this.fetchDatabaseManagerWrapper.insert(downloadInfos);
        this.startPriorityQueueIfNotStarted();
        return results;
    }

    private final List<Pair<Download, Error>> enqueueRequests(List<? extends Request> requests) {
        List results = new ArrayList();
        Iterable $this$forEach$iv = requests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Request it = (Request)element$iv;
            boolean bl = false;
            DownloadInfo downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(it, this.fetchDatabaseManagerWrapper.getNewDownloadInfoInstance());
            downloadInfo.setNamespace(this.namespace);
            try {
                boolean existing = this.prepareDownloadInfoForEnqueue(downloadInfo);
                if (downloadInfo.getStatus() != Status.COMPLETED) {
                    downloadInfo.setStatus(it.getDownloadOnEnqueue() ? Status.QUEUED : Status.ADDED);
                    if (!existing) {
                        Pair<DownloadInfo, Boolean> downloadPair = this.fetchDatabaseManagerWrapper.insert(downloadInfo);
                        this.logger.d("Enqueued download " + downloadPair.getFirst());
                        results.add(new Pair(downloadPair.getFirst(), (Object)Error.NONE));
                        this.startPriorityQueueIfNotStarted();
                    } else {
                        this.fetchDatabaseManagerWrapper.update(downloadInfo);
                        this.logger.d("Updated download " + downloadInfo);
                        results.add(new Pair((Object)downloadInfo, (Object)Error.NONE));
                    }
                } else {
                    results.add(new Pair((Object)downloadInfo, (Object)Error.NONE));
                }
                if (this.prioritySort != PrioritySort.DESC || this.downloadManager.canAccommodateNewDownload()) continue;
                this.priorityListProcessor.pause();
            }
            catch (Exception e) {
                Error error = FetchErrorUtils.getErrorFromThrowable(e);
                error.setThrowable(e);
                results.add(new Pair((Object)downloadInfo, (Object)error));
            }
        }
        this.startPriorityQueueIfNotStarted();
        return results;
    }

    private final boolean prepareDownloadInfoForEnqueue(DownloadInfo downloadInfo) {
        boolean bl;
        this.cancelDownloadsIfDownloading(CollectionsKt.listOf((Object)downloadInfo));
        DownloadInfo existingDownload = this.fetchDatabaseManagerWrapper.getByFile(downloadInfo.getFile());
        if (existingDownload == null) {
            if (downloadInfo.getEnqueueAction() != EnqueueAction.INCREMENT_FILE_NAME && this.createFileOnEnqueue) {
                StorageResolver.DefaultImpls.createFile$default((StorageResolver)this.storageResolver, (String)downloadInfo.getFile(), (boolean)false, (int)2, null);
            }
        } else {
            this.cancelDownloadsIfDownloading(CollectionsKt.listOf((Object)existingDownload));
            existingDownload = this.fetchDatabaseManagerWrapper.getByFile(downloadInfo.getFile());
            if (existingDownload != null && existingDownload.getStatus() == Status.DOWNLOADING) {
                existingDownload.setStatus(Status.QUEUED);
                try {
                    this.fetchDatabaseManagerWrapper.update(existingDownload);
                }
                catch (Exception e) {
                    String string2 = e.getMessage();
                    if (string2 == null) {
                        string2 = "";
                    }
                    this.logger.e(string2, (Throwable)e);
                }
            } else {
                DownloadInfo downloadInfo2 = existingDownload;
                if ((downloadInfo2 != null ? downloadInfo2.getStatus() : null) == Status.COMPLETED && downloadInfo.getEnqueueAction() == EnqueueAction.UPDATE_ACCORDINGLY && !this.storageResolver.fileExists(existingDownload.getFile())) {
                    try {
                        this.fetchDatabaseManagerWrapper.delete(existingDownload);
                    }
                    catch (Exception e) {
                        String string3 = e.getMessage();
                        if (string3 == null) {
                            string3 = "";
                        }
                        this.logger.e(string3, (Throwable)e);
                    }
                    existingDownload = null;
                    if (downloadInfo.getEnqueueAction() != EnqueueAction.INCREMENT_FILE_NAME && this.createFileOnEnqueue) {
                        StorageResolver.DefaultImpls.createFile$default((StorageResolver)this.storageResolver, (String)downloadInfo.getFile(), (boolean)false, (int)2, null);
                    }
                }
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[downloadInfo.getEnqueueAction().ordinal()]) {
            case 1: {
                if (existingDownload != null) {
                    downloadInfo.setDownloaded(existingDownload.getDownloaded());
                    downloadInfo.setTotal(existingDownload.getTotal());
                    downloadInfo.setError(existingDownload.getError());
                    downloadInfo.setStatus(existingDownload.getStatus());
                    if (downloadInfo.getStatus() != Status.COMPLETED) {
                        downloadInfo.setStatus(Status.QUEUED);
                        downloadInfo.setError(FetchDefaults.getDefaultNoError());
                    }
                    if (downloadInfo.getStatus() == Status.COMPLETED && !this.storageResolver.fileExists(downloadInfo.getFile())) {
                        if (this.createFileOnEnqueue) {
                            StorageResolver.DefaultImpls.createFile$default((StorageResolver)this.storageResolver, (String)downloadInfo.getFile(), (boolean)false, (int)2, null);
                        }
                        downloadInfo.setDownloaded(0L);
                        downloadInfo.setTotal(-1L);
                        downloadInfo.setStatus(Status.QUEUED);
                        downloadInfo.setError(FetchDefaults.getDefaultNoError());
                    }
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (existingDownload != null) {
                    throw new FetchException("request_with_file_path_already_exist");
                }
                bl = false;
                break;
            }
            case 3: {
                if (existingDownload != null) {
                    this.deleteDownloads(CollectionsKt.listOf((Object)existingDownload));
                }
                this.deleteDownloads(CollectionsKt.listOf((Object)downloadInfo));
                return false;
            }
            case 4: {
                if (this.createFileOnEnqueue) {
                    this.storageResolver.createFile(downloadInfo.getFile(), true);
                }
                downloadInfo.setFile(downloadInfo.getFile());
                downloadInfo.setId(FetchCoreUtils.getUniqueId((String)downloadInfo.getUrl(), (String)downloadInfo.getFile()));
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Download enqueueCompletedDownload(@NotNull CompletedDownload completedDownload) {
        Intrinsics.checkNotNullParameter((Object)completedDownload, (String)"completedDownload");
        return (Download)CollectionsKt.first(this.enqueueCompletedDownloads(CollectionsKt.listOf((Object)completedDownload)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> enqueueCompletedDownloads(@NotNull List<? extends CompletedDownload> completedDownloads) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(completedDownloads, (String)"completedDownloads");
        Iterable $this$map$iv = completedDownloads;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CompletedDownload completedDownload = (CompletedDownload)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DownloadInfo downloadInfo = FetchTypeConverterExtensions.toDownloadInfo((CompletedDownload)it, this.fetchDatabaseManagerWrapper.getNewDownloadInfoInstance());
            downloadInfo.setNamespace(this.namespace);
            downloadInfo.setStatus(Status.COMPLETED);
            this.prepareCompletedDownloadInfoForEnqueue(downloadInfo);
            Pair<DownloadInfo, Boolean> downloadPair = this.fetchDatabaseManagerWrapper.insert(downloadInfo);
            this.logger.d("Enqueued CompletedDownload " + downloadPair.getFirst());
            collection.add((DownloadInfo)downloadPair.getFirst());
        }
        return (List)destination$iv$iv;
    }

    private final void prepareCompletedDownloadInfoForEnqueue(DownloadInfo downloadInfo) {
        DownloadInfo existingDownload = this.fetchDatabaseManagerWrapper.getByFile(downloadInfo.getFile());
        if (existingDownload != null) {
            this.deleteDownloads(CollectionsKt.listOf((Object)downloadInfo));
        }
    }

    @Override
    @NotNull
    public List<Download> pause(@NotNull List<Integer> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return this.pauseDownloads(CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids)));
    }

    @Override
    @NotNull
    public List<Download> pausedGroup(int id) {
        return this.pauseDownloads(this.fetchDatabaseManagerWrapper.getByGroup(id));
    }

    private final List<Download> pauseDownloads(List<? extends DownloadInfo> downloads) {
        this.cancelDownloadsIfDownloading(downloads);
        List pausedDownloads = new ArrayList();
        Iterable $this$forEach$iv = downloads;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            boolean bl = false;
            if (!FetchUtils.canPauseDownload(it)) continue;
            it.setStatus(Status.PAUSED);
            pausedDownloads.add(it);
        }
        this.fetchDatabaseManagerWrapper.update(pausedDownloads);
        return pausedDownloads;
    }

    @Override
    @NotNull
    public List<Download> pauseAll() {
        return this.pauseDownloads(this.fetchDatabaseManagerWrapper.get());
    }

    @Override
    public void freeze() {
        this.priorityListProcessor.pause();
        this.downloadManager.cancelAll();
    }

    @Override
    public void unfreeze() {
        this.priorityListProcessor.resume();
    }

    @Override
    @NotNull
    public List<Download> resume(@NotNull List<Integer> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return this.resumeDownloads(ids);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> resumeGroup(int id) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.fetchDatabaseManagerWrapper.getByGroup(id);
        FetchHandlerImpl fetchHandlerImpl = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DownloadInfo downloadInfo = (DownloadInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return fetchHandlerImpl.resumeDownloads((List)destination$iv$iv);
    }

    private final List<Download> resumeDownloads(List<Integer> downloadIds) {
        List downloads = CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(downloadIds));
        List resumedDownloads = new ArrayList();
        Iterable $this$forEach$iv = downloads;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            boolean bl = false;
            if (this.downloadManager.contains(it.getId()) || !FetchUtils.canResumeDownload(it)) continue;
            it.setStatus(Status.QUEUED);
            resumedDownloads.add(it);
        }
        this.fetchDatabaseManagerWrapper.update(resumedDownloads);
        this.startPriorityQueueIfNotStarted();
        return resumedDownloads;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> resumeAll() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.fetchDatabaseManagerWrapper.get();
        FetchHandlerImpl fetchHandlerImpl = this;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DownloadInfo downloadInfo = (DownloadInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return fetchHandlerImpl.resumeDownloads((List)destination$iv$iv);
    }

    @Override
    @NotNull
    public List<Download> remove(@NotNull List<Integer> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return this.removeDownloads(CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids)));
    }

    @Override
    @NotNull
    public List<Download> removeGroup(int id) {
        return this.removeDownloads(this.fetchDatabaseManagerWrapper.getByGroup(id));
    }

    @Override
    @NotNull
    public List<Download> removeAll() {
        return this.removeDownloads(this.fetchDatabaseManagerWrapper.get());
    }

    @Override
    @NotNull
    public List<Download> removeAllWithStatus(@NotNull Status status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        return this.removeDownloads(this.fetchDatabaseManagerWrapper.getByStatus(status));
    }

    @Override
    @NotNull
    public List<Download> removeAllInGroupWithStatus(int groupId, @NotNull List<? extends Status> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        return this.removeDownloads(this.fetchDatabaseManagerWrapper.getDownloadsInGroupWithStatus(groupId, statuses));
    }

    private final List<Download> removeDownloads(List<? extends DownloadInfo> downloads) {
        this.cancelDownloadsIfDownloading(downloads);
        this.fetchDatabaseManagerWrapper.delete((List<? extends DownloadInfo>)downloads);
        Iterable $this$forEach$iv = downloads;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            boolean bl = false;
            it.setStatus(Status.REMOVED);
            FetchDatabaseManager.Delegate<DownloadInfo> delegate = this.fetchDatabaseManagerWrapper.getDelegate();
            if (delegate == null) continue;
            delegate.deleteTempFilesForDownload(it);
        }
        return downloads;
    }

    @Override
    @NotNull
    public List<Download> delete(@NotNull List<Integer> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return this.deleteDownloads(CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids)));
    }

    @Override
    @NotNull
    public List<Download> deleteGroup(int id) {
        return this.deleteDownloads(this.fetchDatabaseManagerWrapper.getByGroup(id));
    }

    @Override
    @NotNull
    public List<Download> deleteAll() {
        return this.deleteDownloads(this.fetchDatabaseManagerWrapper.get());
    }

    @Override
    @NotNull
    public List<Download> deleteAllWithStatus(@NotNull Status status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        return this.deleteDownloads(this.fetchDatabaseManagerWrapper.getByStatus(status));
    }

    @Override
    @NotNull
    public List<Download> deleteAllInGroupWithStatus(int groupId, @NotNull List<? extends Status> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        return this.deleteDownloads(this.fetchDatabaseManagerWrapper.getDownloadsInGroupWithStatus(groupId, statuses));
    }

    private final List<Download> deleteDownloads(List<? extends DownloadInfo> downloads) {
        this.cancelDownloadsIfDownloading(downloads);
        this.fetchDatabaseManagerWrapper.delete((List<? extends DownloadInfo>)downloads);
        Iterable $this$forEach$iv = downloads;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            boolean bl = false;
            it.setStatus(Status.DELETED);
            this.storageResolver.deleteFile(it.getFile());
            FetchDatabaseManager.Delegate<DownloadInfo> delegate = this.fetchDatabaseManagerWrapper.getDelegate();
            if (delegate == null) continue;
            delegate.deleteTempFilesForDownload(it);
        }
        return downloads;
    }

    @Override
    @NotNull
    public List<Download> cancel(@NotNull List<Integer> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return this.cancelDownloads(CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids)));
    }

    @Override
    @NotNull
    public List<Download> cancelGroup(int id) {
        return this.cancelDownloads(this.fetchDatabaseManagerWrapper.getByGroup(id));
    }

    @Override
    @NotNull
    public List<Download> cancelAll() {
        return this.cancelDownloads(this.fetchDatabaseManagerWrapper.get());
    }

    private final List<Download> cancelDownloads(List<? extends DownloadInfo> downloads) {
        this.cancelDownloadsIfDownloading(downloads);
        List cancelledDownloads = new ArrayList();
        Iterable $this$forEach$iv = downloads;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            boolean bl = false;
            if (!FetchUtils.canCancelDownload(it)) continue;
            it.setStatus(Status.CANCELLED);
            it.setError(FetchDefaults.getDefaultNoError());
            cancelledDownloads.add(it);
        }
        this.fetchDatabaseManagerWrapper.update(cancelledDownloads);
        return cancelledDownloads;
    }

    @Override
    @NotNull
    public List<Download> retry(@NotNull List<Integer> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        List downloadInfoList = CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids));
        List retryDownloads = new ArrayList();
        Iterable $this$forEach$iv = downloadInfoList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            boolean bl = false;
            if (!FetchUtils.canRetryDownload(it)) continue;
            it.setStatus(Status.QUEUED);
            it.setError(FetchDefaults.getDefaultNoError());
            retryDownloads.add(it);
        }
        this.fetchDatabaseManagerWrapper.update(retryDownloads);
        this.startPriorityQueueIfNotStarted();
        return retryDownloads;
    }

    @Override
    @Nullable
    public Download resetAutoRetryAttempts(int downloadId, boolean retryDownload) {
        DownloadInfo download = this.fetchDatabaseManagerWrapper.get(downloadId);
        if (download != null) {
            this.cancelDownloadsIfDownloading(CollectionsKt.listOf((Object)download));
            if (retryDownload && FetchUtils.canRetryDownload(download)) {
                download.setStatus(Status.QUEUED);
                download.setError(FetchDefaults.getDefaultNoError());
            }
            download.setAutoRetryAttempts(0);
            this.fetchDatabaseManagerWrapper.update(download);
            this.startPriorityQueueIfNotStarted();
        }
        return download;
    }

    @Override
    @NotNull
    public Pair<Download, Boolean> updateRequest(int requestId, @NotNull Request newRequest) {
        Intrinsics.checkNotNullParameter((Object)newRequest, (String)"newRequest");
        DownloadInfo oldDownloadInfo = this.fetchDatabaseManagerWrapper.get(requestId);
        if (oldDownloadInfo != null) {
            this.cancelDownloadsIfDownloading(CollectionsKt.listOf((Object)oldDownloadInfo));
            oldDownloadInfo = this.fetchDatabaseManagerWrapper.get(requestId);
        }
        if (oldDownloadInfo != null) {
            if (Intrinsics.areEqual((Object)newRequest.getFile(), (Object)oldDownloadInfo.getFile())) {
                DownloadInfo newDownloadInfo = FetchTypeConverterExtensions.toDownloadInfo(newRequest, this.fetchDatabaseManagerWrapper.getNewDownloadInfoInstance());
                newDownloadInfo.setNamespace(this.namespace);
                newDownloadInfo.setDownloaded(oldDownloadInfo.getDownloaded());
                newDownloadInfo.setTotal(oldDownloadInfo.getTotal());
                if (oldDownloadInfo.getStatus() == Status.DOWNLOADING) {
                    newDownloadInfo.setStatus(Status.QUEUED);
                    newDownloadInfo.setError(FetchDefaults.getDefaultNoError());
                } else {
                    newDownloadInfo.setStatus(oldDownloadInfo.getStatus());
                    newDownloadInfo.setError(oldDownloadInfo.getError());
                }
                this.fetchDatabaseManagerWrapper.delete(oldDownloadInfo);
                this.listenerCoordinator.getMainListener().onDeleted(oldDownloadInfo);
                this.fetchDatabaseManagerWrapper.insert(newDownloadInfo);
                this.startPriorityQueueIfNotStarted();
                return new Pair((Object)newDownloadInfo, (Object)true);
            }
        } else {
            throw new FetchException("request_does_not_exist");
        }
        this.delete(CollectionsKt.listOf((Object)requestId));
        Pair<Download, Error> enqueuePair = this.enqueue(newRequest);
        return new Pair(enqueuePair.getFirst(), (Object)(enqueuePair.getSecond() == Error.NONE ? 1 : 0));
    }

    @Override
    @NotNull
    public Download renameCompletedDownloadFile(int id, @NotNull String newFileName) {
        Intrinsics.checkNotNullParameter((Object)newFileName, (String)"newFileName");
        DownloadInfo downloadInfo = this.fetchDatabaseManagerWrapper.get(id);
        if (downloadInfo == null) {
            throw new FetchException("request_does_not_exist");
        }
        DownloadInfo download = downloadInfo;
        if (download.getStatus() != Status.COMPLETED) {
            throw new FetchException("cannot rename file associated with incomplete download");
        }
        DownloadInfo downloadWithFile = this.fetchDatabaseManagerWrapper.getByFile(newFileName);
        if (downloadWithFile != null) {
            throw new FetchException("request_with_file_path_already_exist");
        }
        DownloadInfo copy = FetchTypeConverterExtensions.toDownloadInfo(download, this.fetchDatabaseManagerWrapper.getNewDownloadInfoInstance());
        copy.setId(FetchCoreUtils.getUniqueId((String)download.getUrl(), (String)newFileName));
        copy.setFile(newFileName);
        Pair<DownloadInfo, Boolean> pair = this.fetchDatabaseManagerWrapper.insert(copy);
        if (!((Boolean)pair.getSecond()).booleanValue()) {
            throw new FetchException("file_cannot_be_renamed");
        }
        boolean renamed = this.storageResolver.renameFile(download.getFile(), newFileName);
        if (!renamed) {
            this.fetchDatabaseManagerWrapper.delete(copy);
            throw new FetchException("file_cannot_be_renamed");
        }
        this.fetchDatabaseManagerWrapper.delete(download);
        return (Download)pair.getFirst();
    }

    @Override
    @NotNull
    public Download replaceExtras(int id, @NotNull Extras extras) {
        DownloadInfo downloadInfo;
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        DownloadInfo downloadInfo2 = this.fetchDatabaseManagerWrapper.get(id);
        if (downloadInfo2 != null) {
            this.cancelDownloadsIfDownloading(CollectionsKt.listOf((Object)downloadInfo2));
            downloadInfo2 = this.fetchDatabaseManagerWrapper.get(id);
        }
        if (downloadInfo2 != null) {
            DownloadInfo download;
            downloadInfo = download = this.fetchDatabaseManagerWrapper.updateExtras(id, extras);
            if (downloadInfo == null) {
                throw new FetchException("request_does_not_exist");
            }
        } else {
            throw new FetchException("request_does_not_exist");
        }
        return downloadInfo;
    }

    @Override
    @NotNull
    public List<Download> getDownloads() {
        return this.fetchDatabaseManagerWrapper.get();
    }

    @Override
    @Nullable
    public Download getDownload(int id) {
        return this.fetchDatabaseManagerWrapper.get(id);
    }

    @Override
    @NotNull
    public List<Download> getDownloads(@NotNull List<Integer> idList) {
        Intrinsics.checkNotNullParameter(idList, (String)"idList");
        return CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(idList));
    }

    @Override
    @NotNull
    public List<Download> getDownloadsInGroup(int id) {
        return this.fetchDatabaseManagerWrapper.getByGroup(id);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsWithStatus(@NotNull Status status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        return this.fetchDatabaseManagerWrapper.getByStatus(status);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsWithStatus(@NotNull List<? extends Status> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        return this.fetchDatabaseManagerWrapper.getByStatus(statuses);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsInGroupWithStatus(int groupId, @NotNull List<? extends Status> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        return this.fetchDatabaseManagerWrapper.getDownloadsInGroupWithStatus(groupId, statuses);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsByRequestIdentifier(long identifier) {
        return this.fetchDatabaseManagerWrapper.getDownloadsByRequestIdentifier(identifier);
    }

    @Override
    @NotNull
    public List<Integer> getAllGroupIds() {
        return this.fetchDatabaseManagerWrapper.getAllGroupIds();
    }

    @Override
    @NotNull
    public List<Download> getDownloadsByTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return this.fetchDatabaseManagerWrapper.getDownloadsByTag(tag);
    }

    @Override
    @NotNull
    public List<DownloadBlock> getDownloadBlocks(int id) {
        List list;
        DownloadInfo download = this.fetchDatabaseManagerWrapper.get(id);
        if (download != null) {
            String fileTempDir = this.downloadManager.getDownloadFileTempDir(download);
            FileSliceInfo fileSliceInfo = FetchUtils.getFileSliceInfo(FetchUtils.getPreviousSliceCount(download.getId(), fileTempDir), download.getTotal());
            if (download.getTotal() < 1L) {
                list = CollectionsKt.emptyList();
            } else if (fileSliceInfo.getSlicingCount() < 2) {
                DownloadBlockInfo downloadBlockInfo = new DownloadBlockInfo();
                downloadBlockInfo.setDownloadId(download.getId());
                downloadBlockInfo.setBlockPosition(1);
                downloadBlockInfo.setStartByte(0L);
                downloadBlockInfo.setEndByte(download.getTotal());
                downloadBlockInfo.setDownloadedBytes(download.getDownloaded());
                list = CollectionsKt.listOf((Object)downloadBlockInfo);
            } else {
                long counterBytes = 0L;
                List downloadBlocksList = new ArrayList();
                int position = 1;
                int n = fileSliceInfo.getSlicingCount();
                if (position <= n) {
                    while (true) {
                        long endBytes;
                        long startBytes = counterBytes;
                        counterBytes = endBytes = fileSliceInfo.getSlicingCount() == position ? download.getTotal() : counterBytes + fileSliceInfo.getBytesPerFileSlice();
                        DownloadBlockInfo downloadBlockInfo = new DownloadBlockInfo();
                        downloadBlockInfo.setDownloadId(download.getId());
                        downloadBlockInfo.setBlockPosition(position);
                        downloadBlockInfo.setStartByte(startBytes);
                        downloadBlockInfo.setEndByte(endBytes);
                        downloadBlockInfo.setDownloadedBytes(FetchUtils.getSavedDownloadedInfo(download.getId(), position, fileTempDir));
                        downloadBlocksList.add(downloadBlockInfo);
                        if (position == n) break;
                        ++position;
                    }
                }
                list = downloadBlocksList;
            }
        } else {
            return CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public long getContentLengthForRequest(@NotNull Request request, boolean fromServer) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        DownloadInfo download = this.fetchDatabaseManagerWrapper.get(request.getId());
        if (download != null && download.getTotal() > 0L) {
            return download.getTotal();
        }
        return fromServer ? (FetchCoreUtils.isFetchFileServerUrl((String)request.getUrl()) ? this.fileServerDownloader.getRequestContentLength(FetchUtils.getServerRequestFromRequest(request)) : this.httpDownloader.getRequestContentLength(FetchUtils.getServerRequestFromRequest(request))) : -1L;
    }

    @Override
    @NotNull
    public Downloader.Response getServerResponse(@NotNull String url, @Nullable Map<String, String> header) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Request request = new Request(url, "");
        Map<String, String> map = header;
        if (map != null) {
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                boolean bl = false;
                request.addHeader(it.getKey(), it.getValue());
            }
        }
        Downloader.ServerRequest serverRequest = FetchUtils.getServerRequestFromRequest(request);
        InterruptMonitor interruptMonitor2 = new InterruptMonitor(){

            public boolean isInterrupted() {
                return false;
            }
        };
        if (FetchCoreUtils.isFetchFileServerUrl((String)request.getUrl())) {
            response = this.fileServerDownloader.execute(serverRequest, interruptMonitor2);
            if (response != null) {
                copy = FetchCoreUtils.copyDownloadResponseNoStream((Downloader.Response)response);
                this.fileServerDownloader.disconnect(response);
                return copy;
            }
        } else {
            response = this.httpDownloader.execute(serverRequest, interruptMonitor2);
            if (response != null) {
                copy = FetchCoreUtils.copyDownloadResponseNoStream((Downloader.Response)response);
                this.httpDownloader.disconnect(response);
                return copy;
            }
        }
        throw new IOException("request_not_successful");
    }

    @Override
    @NotNull
    public List<FileResource> getFetchFileServerCatalog(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.fileServerDownloader.getFetchFileServerCatalog(FetchUtils.getCatalogServerRequestFromRequest(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isTerminating) {
            return;
        }
        this.isTerminating = true;
        Set<FetchListener> set = this.listenerSet;
        synchronized (set) {
            boolean bl = false;
            Iterator<FetchListener> $this$forEach$iv = this.listenerSet.iterator();
            boolean $i$f$forEach = false;
            Iterator<FetchListener> iterator = $this$forEach$iv;
            while (iterator.hasNext()) {
                FetchListener element$iv;
                FetchListener it = element$iv = iterator.next();
                boolean bl2 = false;
                this.listenerCoordinator.removeListener(this.listenerId, it);
            }
            this.listenerSet.clear();
            Unit unit = Unit.INSTANCE;
        }
        if (this.fetchNotificationManager != null) {
            this.listenerCoordinator.removeNotificationManager(this.fetchNotificationManager);
            this.listenerCoordinator.cancelOnGoingNotifications(this.fetchNotificationManager);
        }
        this.priorityListProcessor.stop();
        this.priorityListProcessor.close();
        this.downloadManager.close();
        FetchModulesBuilder.INSTANCE.removeNamespaceInstanceReference(this.namespace);
    }

    @Override
    public void setGlobalNetworkType(@NotNull NetworkType networkType) {
        List downloads;
        Intrinsics.checkNotNullParameter((Object)((Object)networkType), (String)"networkType");
        this.priorityListProcessor.stop();
        this.priorityListProcessor.setGlobalNetworkType(networkType);
        List<Integer> ids = this.downloadManager.getActiveDownloadsIds();
        if (!((Collection)ids).isEmpty() && !((Collection)(downloads = CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids)))).isEmpty()) {
            this.cancelDownloadsIfDownloading(downloads);
            downloads = CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids));
            Iterable $this$forEach$iv = downloads;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DownloadInfo it = (DownloadInfo)element$iv;
                boolean bl = false;
                if (it.getStatus() != Status.DOWNLOADING) continue;
                it.setStatus(Status.QUEUED);
                it.setError(FetchDefaults.getDefaultNoError());
            }
            this.fetchDatabaseManagerWrapper.update(downloads);
        }
        this.priorityListProcessor.start();
    }

    @Override
    public void setDownloadConcurrentLimit(int downloadConcurrentLimit) {
        List downloads;
        this.priorityListProcessor.stop();
        List<Integer> ids = this.downloadManager.getActiveDownloadsIds();
        if (!((Collection)ids).isEmpty() && !((Collection)(downloads = CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids)))).isEmpty()) {
            this.cancelDownloadsIfDownloading(downloads);
            downloads = CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids));
            this.downloadManager.setConcurrentLimit(downloadConcurrentLimit);
            this.priorityListProcessor.setDownloadConcurrentLimit(downloadConcurrentLimit);
            Iterable $this$forEach$iv = downloads;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DownloadInfo it = (DownloadInfo)element$iv;
                boolean bl = false;
                if (it.getStatus() != Status.DOWNLOADING) continue;
                it.setStatus(Status.QUEUED);
                it.setError(FetchDefaults.getDefaultNoError());
            }
            this.fetchDatabaseManagerWrapper.update(downloads);
        }
        this.priorityListProcessor.start();
    }

    @Override
    public void enableLogging(boolean enabled) {
        this.logger.d("Enable logging - " + enabled);
        this.logger.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(@NotNull FetchListener listener, boolean notify, boolean autoStart) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Set<FetchListener> set = this.listenerSet;
        synchronized (set) {
            boolean bl = false;
            bl = this.listenerSet.add(listener);
        }
        this.listenerCoordinator.addListener(this.listenerId, listener);
        if (notify) {
            List<DownloadInfo> downloads = this.fetchDatabaseManagerWrapper.get();
            Iterable $this$forEach$iv = downloads;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DownloadInfo it = (DownloadInfo)element$iv;
                boolean bl = false;
                this.uiHandler.post(() -> FetchHandlerImpl.addListener$lambda$18$lambda$17(it, listener));
            }
        }
        this.logger.d("Added listener " + listener);
        if (autoStart) {
            this.startPriorityQueueIfNotStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(@NotNull FetchListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Set<FetchListener> set = this.listenerSet;
        synchronized (set) {
            boolean bl = false;
            Iterator<FetchListener> iterator = this.listenerSet.iterator();
            while (iterator.hasNext()) {
                FetchListener fetchListener = iterator.next();
                if (!Intrinsics.areEqual((Object)fetchListener, (Object)listener)) continue;
                iterator.remove();
                this.logger.d("Removed listener " + listener);
                break;
            }
            this.listenerCoordinator.removeListener(this.listenerId, listener);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Set<FetchListener> getListenerSet() {
        Set set;
        Set<FetchListener> set2 = this.listenerSet;
        synchronized (set2) {
            boolean bl = false;
            set = CollectionsKt.toSet((Iterable)this.listenerSet);
        }
        return set;
    }

    @Override
    public boolean hasActiveDownloads(boolean includeAddedDownloads) {
        if (Intrinsics.areEqual((Object)Thread.currentThread(), (Object)Looper.getMainLooper().getThread())) {
            throw new FetchException("blocking_call_on_ui_thread");
        }
        return this.fetchDatabaseManagerWrapper.getPendingCount(includeAddedDownloads) > 0L;
    }

    @Override
    public long getPendingCount() {
        return this.fetchDatabaseManagerWrapper.getPendingCount(false);
    }

    private final void cancelDownloadsIfDownloading(List<? extends DownloadInfo> downloads) {
        for (DownloadInfo downloadInfo : downloads) {
            this.downloadManager.cancel(downloadInfo.getId());
        }
    }

    private final void startPriorityQueueIfNotStarted() {
        this.priorityListProcessor.sendBackOffResetSignal();
        if (this.priorityListProcessor.isStopped() && !this.isTerminating) {
            this.priorityListProcessor.start();
        }
        if (this.priorityListProcessor.isPaused() && !this.isTerminating) {
            this.priorityListProcessor.resume();
        }
    }

    @Override
    @NotNull
    public FetchGroup getFetchGroup(int id) {
        return this.groupInfoProvider.getGroupInfo(id, Reason.OBSERVER_ATTACHED);
    }

    @Override
    public void addFetchObserversForDownload(int downloadId, FetchObserver<Download> ... fetchObservers) {
        Intrinsics.checkNotNullParameter(fetchObservers, (String)"fetchObservers");
        this.listenerCoordinator.addFetchObserversForDownload(downloadId, Arrays.copyOf(fetchObservers, fetchObservers.length));
    }

    @Override
    public void removeFetchObserversForDownload(int downloadId, FetchObserver<Download> ... fetchObservers) {
        Intrinsics.checkNotNullParameter(fetchObservers, (String)"fetchObservers");
        this.listenerCoordinator.removeFetchObserversForDownload(downloadId, Arrays.copyOf(fetchObservers, fetchObservers.length));
    }

    private static final void addListener$lambda$18$lambda$17(DownloadInfo $it, FetchListener $listener) {
        switch (WhenMappings.$EnumSwitchMapping$1[$it.getStatus().ordinal()]) {
            case 1: {
                $listener.onCompleted($it);
                break;
            }
            case 2: {
                $listener.onError($it, $it.getError(), null);
                break;
            }
            case 3: {
                $listener.onCancelled($it);
                break;
            }
            case 4: {
                $listener.onDeleted($it);
                break;
            }
            case 5: {
                $listener.onPaused($it);
                break;
            }
            case 6: {
                $listener.onQueued($it, false);
                break;
            }
            case 7: {
                $listener.onRemoved($it);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                $listener.onAdded($it);
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[EnqueueAction.values().length];
            try {
                nArray[EnqueueAction.UPDATE_ACCORDINGLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnqueueAction.DO_NOT_ENQUEUE_IF_EXISTING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnqueueAction.REPLACE_EXISTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnqueueAction.INCREMENT_FILE_NAME.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Status.values().length];
            try {
                nArray[Status.COMPLETED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.CANCELLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.DELETED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.PAUSED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.QUEUED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.REMOVED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.DOWNLOADING.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ADDED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.NONE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

