/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.database;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DownloadInfo;
import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0006H'J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0016\u0010\b\u001a\u00020\t2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0006H'J\b\u0010\n\u001a\u00020\tH'J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005H'J\u0016\u0010\u000b\u001a\u00020\t2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0006H'J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0006H'J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH'J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H'J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0013H'J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u0015\u001a\u00020\u0016H'J!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0011\u0010\u0017\u001a\r\u0012\t\u0012\u00070\u0016\u00a2\u0006\u0002\b\u00180\u0006H'J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u001a\u001a\u00020\u000fH'J)\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u001a\u001a\u00020\u000f2\u0011\u0010\u0017\u001a\r\u0012\t\u0012\u00070\u0016\u00a2\u0006\u0002\b\u00180\u0006H'J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u0015\u001a\u00020\u0016H'J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u0015\u001a\u00020\u0016H'J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u001f\u001a\u00020\u0003H'J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010!\u001a\u00020\u0013H'J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H'\u00a8\u0006#"}, d2={"Lcom/tonyodev/fetch2/database/DownloadDao;", "", "insert", "", "downloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "", "downloadInfoList", "delete", "", "deleteAll", "update", "download", "get", "id", "", "ids", "getByFile", "file", "", "getByStatus", "status", "Lcom/tonyodev/fetch2/Status;", "statuses", "Lkotlin/jvm/JvmSuppressWildcards;", "getByGroup", "group", "getByGroupWithStatus", "getPendingDownloadsSorted", "getPendingDownloadsSortedDesc", "getDownloadsByRequestIdentifier", "identifier", "getDownloadsByTag", "tag", "getAllGroupIds", "fetch2_release"})
@Dao
public interface DownloadDao {
    @Insert(onConflict=3)
    public long insert(@NotNull DownloadInfo var1);

    @Insert(onConflict=3)
    @NotNull
    public List<Long> insert(@NotNull List<? extends DownloadInfo> var1);

    @Delete
    public void delete(@NotNull DownloadInfo var1);

    @Delete
    public void delete(@NotNull List<? extends DownloadInfo> var1);

    @Query(value="DELETE FROM requests")
    public void deleteAll();

    @Update(onConflict=1)
    public void update(@NotNull DownloadInfo var1);

    @Update(onConflict=1)
    public void update(@NotNull List<? extends DownloadInfo> var1);

    @Query(value="SELECT * FROM requests")
    @NotNull
    public List<DownloadInfo> get();

    @Query(value="SELECT * FROM requests WHERE _id = :id")
    @Nullable
    public DownloadInfo get(int var1);

    @Query(value="SELECT * FROM requests WHERE _id IN (:ids)")
    @NotNull
    public List<DownloadInfo> get(@NotNull List<Integer> var1);

    @Query(value="SELECT * FROM requests WHERE _file = :file")
    @Nullable
    public DownloadInfo getByFile(@NotNull String var1);

    @Query(value="SELECT * FROM requests WHERE _status = :status")
    @NotNull
    public List<DownloadInfo> getByStatus(@NotNull Status var1);

    @Query(value="SELECT * FROM requests WHERE _status IN (:statuses)")
    @NotNull
    public List<DownloadInfo> getByStatus(@NotNull List<Status> var1);

    @Query(value="SELECT * FROM requests WHERE _group = :group")
    @NotNull
    public List<DownloadInfo> getByGroup(int var1);

    @Query(value="SELECT * FROM requests WHERE _group = :group AND _status IN (:statuses)")
    @NotNull
    public List<DownloadInfo> getByGroupWithStatus(int var1, @NotNull List<Status> var2);

    @Query(value="SELECT * FROM requests WHERE _status = :status ORDER BY _priority DESC, _created ASC")
    @NotNull
    public List<DownloadInfo> getPendingDownloadsSorted(@NotNull Status var1);

    @Query(value="SELECT * FROM requests WHERE _status = :status ORDER BY _priority DESC, _created DESC")
    @NotNull
    public List<DownloadInfo> getPendingDownloadsSortedDesc(@NotNull Status var1);

    @Query(value="SELECT * FROM requests WHERE _identifier = :identifier")
    @NotNull
    public List<DownloadInfo> getDownloadsByRequestIdentifier(long var1);

    @Query(value="SELECT * FROM requests WHERE _tag = :tag")
    @NotNull
    public List<DownloadInfo> getDownloadsByTag(@NotNull String var1);

    @Query(value="SELECT DISTINCT _group from requests")
    @NotNull
    public List<Integer> getAllGroupIds();
}

